/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.SpringEmbeddedLayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 868213052692609076L;
    protected ClusterManager clusterManager;
    public final List<NodeCluster> clusters;
    public final AbstractClusterResults clusterResults;
    private final CyNetwork network;
    private CyNetworkView networkView;
    private final CyApplicationManager applicationMgr;
    private final TaskMonitor monitor;
    private static final int graphPicSize = 80;
    private static final int defaultRowHeight = 88;
    private final VisualStyleFactory visualStyleFactory;
    private final CyNetworkViewFactory networkViewFactory;
    private final VisualMappingManager visualMappingMgr;
    private final RenderingEngineFactory<CyNetwork> renderingEngineFactory;
    private JPanel[] exploreContent;
    private VisualStyle clusterStyle;
    private boolean interrupted;
    private ClusterBrowserPanel clusterBrowserPanel;
    private String clusterType = null;

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.EAST;
    }

    public Icon getIcon() {
        return null;
    }

    public ResultsPanel(List<NodeCluster> clusters, AbstractClusterResults clusterResults, CyNetwork network, CyNetworkView networkView, ClusterManager clusterManager, TaskMonitor monitor) {
        this.setLayout(new BorderLayout());
        this.clusterManager = clusterManager;
        this.clusters = clusters;
        this.clusterResults = clusterResults;
        this.network = network;
        this.networkView = networkView;
        this.monitor = monitor;
        this.visualStyleFactory = clusterManager.getService(VisualStyleFactory.class);
        this.applicationMgr = clusterManager.getService(CyApplicationManager.class);
        this.networkViewFactory = clusterManager.getService(CyNetworkViewFactory.class);
        this.visualMappingMgr = clusterManager.getService(VisualMappingManager.class);
        this.renderingEngineFactory = clusterManager.getService(RenderingEngineFactory.class);
        this.clusterType = (String)network.getRow((CyIdentifiable)network).get("__clusterType", String.class);
        this.clusterBrowserPanel = new ClusterBrowserPanel();
        this.add((Component)this.clusterBrowserPanel, "Center");
        this.setSize(this.getMinimumSize());
    }

    public String getTitle() {
        return this.clusterType + " Cluster Results";
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public List<NodeCluster> getClusters() {
        return this.clusters;
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    private static StringBuffer getClusterScore(NodeCluster cluster2) {
        StringBuffer details = new StringBuffer();
        details.append("Score: ");
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        details.append(nf.format(cluster2.getClusterScore()));
        return details;
    }

    public Image createClusterImage(final NodeCluster cluster2, final int height, final int width, SpringEmbeddedLayouter layouter, boolean layoutNecessary) {
        CyRootNetwork root = this.clusterManager.getService(CyRootNetworkManager.class).getRootNetwork(this.network);
        CySubNetwork net = cluster2.getSubNetwork(this.network, root, SavePolicy.DO_NOT_SAVE);
        int weightSetupNodes = 20;
        int weightSetupEdges = 5;
        double weightLayout = 75.0;
        double goalTotal = weightSetupNodes + weightSetupEdges;
        if (layoutNecessary) {
            goalTotal += weightLayout;
        }
        double progress = 0.0;
        final VisualStyle vs = this.getClusterStyle();
        final CyNetworkView clusterView = this.createNetworkView((CyNetwork)net, vs);
        clusterView.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)new Double(width));
        clusterView.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)new Double(height));
        for (View nv : clusterView.getNodeViews()) {
            double y;
            double x;
            if (this.interrupted) {
                if (layouter != null) {
                    layouter.resetDoLayout();
                }
                this.resetLoading();
                return null;
            }
            if (cluster2.getView() != null && cluster2.getView().getNodeView((CyNode)nv.getModel()) != null) {
                x = (Double)cluster2.getView().getNodeView((CyNode)nv.getModel()).getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                y = (Double)cluster2.getView().getNodeView((CyNode)nv.getModel()).getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            } else {
                x = ((Double)clusterView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH) + 100.0) * Math.random();
                y = ((Double)clusterView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT) + 100.0) * Math.random();
                if (!layoutNecessary) {
                    progress /= (goalTotal += weightLayout) / (goalTotal - weightLayout);
                    layoutNecessary = true;
                }
            }
            nv.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
            nv.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
        }
        if (clusterView.getEdgeViews() != null) {
            for (int i = 0; i < clusterView.getEdgeViews().size(); ++i) {
                if (!this.interrupted) continue;
                if (layouter != null) {
                    layouter.resetDoLayout();
                }
                this.resetLoading();
                return null;
            }
        }
        if (layoutNecessary) {
            if (layouter == null) {
                layouter = new SpringEmbeddedLayouter();
            }
            layouter.setGraphView(clusterView);
            if (!layouter.doLayout(weightLayout, goalTotal, progress)) {
                this.resetLoading();
                return null;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        final Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Dimension size = new Dimension(width, height);
                    JPanel panel = new JPanel();
                    panel.setPreferredSize(size);
                    panel.setSize(size);
                    panel.setMinimumSize(size);
                    panel.setMaximumSize(size);
                    panel.setBackground((Color)vs.getDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT));
                    JWindow window = new JWindow();
                    window.getContentPane().add((Component)panel, "Center");
                    RenderingEngine re = ResultsPanel.this.renderingEngineFactory.createRenderingEngine((Object)panel, (View)clusterView);
                    vs.apply(clusterView);
                    clusterView.fitContent();
                    clusterView.updateView();
                    window.pack();
                    window.repaint();
                    re.createImage(width, height);
                    re.printCanvas((Graphics)g);
                    g.dispose();
                    if (clusterView.getNodeViews().size() > 0) {
                        cluster2.setView(clusterView);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        layouter.resetDoLayout();
        this.resetLoading();
        return image;
    }

    public VisualStyle getClusterStyle() {
        if (this.clusterStyle == null) {
            this.clusterStyle = this.visualStyleFactory.createVisualStyle("Cluster");
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_SIZE, (Object)40.0);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_WIDTH, (Object)40.0);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_HEIGHT, (Object)40.0);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_PAINT, (Object)Color.RED);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)Color.RED);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)0.0);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_WIDTH, (Object)5.0);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_PAINT, (Object)Color.BLUE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_UNSELECTED_PAINT, (Object)Color.BLUE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, (Object)Color.BLUE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_SELECTED_PAINT, (Object)Color.BLUE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT, (Object)Color.BLUE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE, (Object)ArrowShapeVisualProperty.NONE);
            this.clusterStyle.setDefaultValue(BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE, (Object)ArrowShapeVisualProperty.NONE);
        }
        return this.clusterStyle;
    }

    public CyNetworkView createNetworkView(CyNetwork net, VisualStyle vs) {
        CyNetworkView view = this.networkViewFactory.createNetworkView(net);
        if (vs == null) {
            vs = this.visualMappingMgr.getDefaultVisualStyle();
        }
        this.visualMappingMgr.setVisualStyle(vs, view);
        vs.apply(view);
        view.updateView();
        return view;
    }

    public void interruptLoading() {
        this.interrupted = true;
    }

    public void resetLoading() {
        this.interrupted = false;
    }

    static /* synthetic */ JPanel[] access$402(ResultsPanel x0, JPanel[] x1) {
        x0.exploreContent = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterImageIcon
    extends ImageIcon
    implements Comparable<ClusterImageIcon> {
        protected NodeCluster nodeCluster;
        static final long serialVersionUID = 1L;

        public ClusterImageIcon() {
            this.nodeCluster = null;
        }

        public ClusterImageIcon(Image image, NodeCluster c) {
            super(image);
            this.nodeCluster = c;
        }

        @Override
        public int compareTo(ClusterImageIcon cii2) {
            if (this.nodeCluster == null && cii2.nodeCluster == null || this.nodeCluster.size() == cii2.nodeCluster.size()) {
                return 0;
            }
            if (this.nodeCluster == null || this.nodeCluster.size() < cii2.nodeCluster.size()) {
                return -1;
            }
            return 1;
        }

        public NodeCluster getNodeCluster() {
            return this.nodeCluster;
        }
    }

    private static class JTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        int minHeight;

        public JTextAreaRenderer(int minHeight) {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.setFont(new Font(this.getFont().getFontName(), 0, 11));
            this.minHeight = minHeight;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StringBuffer sb = (StringBuffer)value;
            this.setText(sb.toString());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            int currentRowHeight = table.getRowHeight(row);
            int rowMargin = table.getRowMargin();
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), currentRowHeight - 2 * rowMargin);
            int textAreaPreferredHeight = (int)this.getPreferredSize().getHeight();
            if (currentRowHeight != Math.max(textAreaPreferredHeight + 2 * rowMargin, this.minHeight + 2 * rowMargin)) {
                table.setRowHeight(row, Math.max(textAreaPreferredHeight + 2 * rowMargin, this.minHeight + 2 * rowMargin));
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterBrowserTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Network", "Score"};
        private final Object[][] data;

        public ClusterBrowserTableModel() {
            ResultsPanel.access$402(ResultsPanel.this, new JPanel[ResultsPanel.this.clusters.size()]);
            this.data = new Object[ResultsPanel.this.clusters.size()][this.columnNames.length];
            for (int i = 0; i < ResultsPanel.this.clusters.size(); ++i) {
                NodeCluster c = ResultsPanel.this.clusters.get(i);
                StringBuffer details = ResultsPanel.getClusterScore(c);
                this.data[i][1] = new StringBuffer(details);
                SpringEmbeddedLayouter layouter = new SpringEmbeddedLayouter();
                Image image = ResultsPanel.this.createClusterImage(c, 80, 80, layouter, false);
                this.data[i][0] = image != null ? new ClusterImageIcon(image, c) : new ClusterImageIcon();
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public void setValueAt(Object object, int row, int col) {
            this.data[row][col] = object;
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    private class ClusterBrowserPanel
    extends JPanel
    implements ListSelectionListener {
        private final ClusterBrowserTableModel browserModel;
        private final JTable table;

        public ClusterBrowserPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Cluster Browser"));
            String title = ResultsPanel.this.clusterType + " cluster summary for " + ModelUtils.getNetworkName(ResultsPanel.this.network);
            TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            border.setTitlePosition(2);
            border.setTitleJustification(1);
            border.setTitleColor(Color.BLUE);
            JLabel summary = new JLabel("<html>" + ResultsPanel.this.clusterResults.toHTML() + "</html>");
            summary.setBorder(border);
            this.add((Component)summary, "North");
            this.browserModel = new ClusterBrowserTableModel();
            this.table = new JTable(this.browserModel);
            this.table.setSelectionMode(2);
            this.table.setAutoCreateRowSorter(true);
            this.table.setDefaultRenderer(StringBuffer.class, new JTextAreaRenderer(88));
            this.table.setIntercellSpacing(new Dimension(0, 4));
            this.table.setFocusable(false);
            ListSelectionModel rowSM = this.table.getSelectionModel();
            rowSM.addListSelectionListener(this);
            JScrollPane tableScrollPane = new JScrollPane(this.table);
            tableScrollPane.getViewport().setBackground(Color.WHITE);
            this.add((Component)tableScrollPane, "Center");
        }

        public int getSelectedRow() {
            return this.table.getSelectedRow();
        }

        public void update(ImageIcon image, int row) {
            this.table.setValueAt(image, row, 0);
        }

        public void update(NodeCluster cluster2, int row) {
            StringBuffer score = ResultsPanel.getClusterScore(cluster2);
            this.table.setValueAt(score, row, 1);
        }

        JTable getTable() {
            return this.table;
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int[] rowIndices = this.table.getSelectedRows();
            HashMap<CyNode, CyNode> selectedMap = new HashMap<CyNode, CyNode>();
            for (int i = 0; i < rowIndices.length; ++i) {
                ClusterImageIcon cii = (ClusterImageIcon)this.table.getValueAt(rowIndices[i], 0);
                if (cii.getNodeCluster() == null) continue;
                for (CyNode node : cii.getNodeCluster()) {
                    selectedMap.put(node, node);
                }
            }
            for (CyNode node : ResultsPanel.this.network.getNodeList()) {
                if (selectedMap.containsKey(node)) {
                    ResultsPanel.this.network.getRow((CyIdentifiable)node).set("selected", (Object)true);
                    continue;
                }
                ResultsPanel.this.network.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            ResultsPanel.this.networkView.updateView();
        }
    }
}

