/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import org.baderlab.wordcloud.internal.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.CloudWordInfo;
import org.baderlab.wordcloud.internal.SemanticSummaryClusterBuilder;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SliderBarPanel;
import org.baderlab.wordcloud.internal.Stemmer;
import org.baderlab.wordcloud.internal.WordDelimiters;
import org.baderlab.wordcloud.internal.WordFilter;
import org.baderlab.wordcloud.internal.WordPair;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;

public class CloudParameters
implements Comparable<CloudParameters> {
    private String cloudName;
    private List<String> attributeNames;
    private String displayStyle;
    private SemanticSummaryParameters networkParams;
    private int maxWords;
    private int cloudNum;
    private Map<String, Set<CyNode>> stringNodeMapping;
    private Map<String, Integer> networkCounts;
    private Map<String, Integer> selectedCounts;
    private Map<WordPair, Integer> networkPairCounts;
    private Map<WordPair, Integer> selectedPairCounts;
    private Map<String, Double> ratios;
    private Map<WordPair, Double> pairRatios;
    private List<CloudWordInfo> cloudWords;
    private double netWeightFactor;
    private double clusterCutoff;
    private double minRatio;
    private double maxRatio;
    private double meanRatio;
    private double meanWeight;
    private double minWeight;
    private double maxWeight;
    private boolean countInitialized = false;
    private boolean selInitialized = false;
    private boolean ratiosInitialized = false;
    private boolean useNetNormal = false;
    private static final String NODEDELIMITER = "CloudParamNodeDelimiter";
    private static final String WORDDELIMITER = "CloudParamWordDelimiter";
    private static final char controlChar = '\u001f';
    private int networkCount = 1;
    private static final String NETWORKNAME = "Net";
    private static final String SEPARATER = "_";
    private static final double EPSILON = 1.0E-5;
    private double defaultNetWeight = 0.0;
    private String defaultAttName = "name";
    private int defaultMaxWords = 250;
    private double defaultClusterCutoff = 1.0;
    private String defaultStyle = CloudDisplayStyles.DEFAULT_STYLE;
    private String clusterColumnName;
    private CyTable clusterTable;

    public CloudParameters(SemanticSummaryParameters networkParams) {
        this.networkParams = networkParams;
        this.stringNodeMapping = new HashMap<String, Set<CyNode>>();
        this.networkCounts = new HashMap<String, Integer>();
        this.selectedCounts = new HashMap<String, Integer>();
        this.networkPairCounts = new HashMap<WordPair, Integer>();
        this.selectedPairCounts = new HashMap<WordPair, Integer>();
        this.ratios = new HashMap<String, Double>();
        this.pairRatios = new HashMap<WordPair, Double>();
        this.cloudWords = new ArrayList<CloudWordInfo>();
        this.netWeightFactor = this.getDefaultNetWeight();
        this.clusterCutoff = this.getDefaultClusterCutoff();
        this.maxWords = this.getDefaultMaxWords();
        this.displayStyle = this.getDefaultDisplayStyle();
    }

    public CloudParameters(SemanticSummaryParameters networkParams, String propFile) {
        this(networkParams);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.cloudName = (String)props.get("CloudName");
        this.displayStyle = (String)props.get("DisplayStyle");
        this.netWeightFactor = new Double((String)props.get("NetWeightFactor"));
        this.clusterCutoff = new Double((String)props.get("ClusterCutoff"));
        this.countInitialized = Boolean.parseBoolean((String)props.get("CountInitialized"));
        this.selInitialized = Boolean.parseBoolean((String)props.get("SelInitialized"));
        this.ratiosInitialized = Boolean.parseBoolean((String)props.get("RatiosInitialized"));
        this.maxRatio = new Double((String)props.get("MaxRatio"));
        this.minRatio = new Double((String)props.get("MinRatio"));
        this.maxWords = new Integer((String)props.get("MaxWords"));
        this.cloudNum = new Integer((String)props.get("CloudNum"));
        for (CyTable table : networkParams.getModelManager().getTableManager().getAllTables(true)) {
            if (!table.getTitle().equals(props.get("ClusterTableName"))) continue;
            this.clusterTable = table;
        }
        String val = (String)props.get("UseNetNormal");
        this.useNetNormal = val == null ? true : Boolean.parseBoolean((String)props.get("UseNetNormal"));
        val = (String)props.get("MeanRatio");
        if (val == null) {
            this.ratiosInitialized = false;
        } else {
            this.meanRatio = new Double((String)props.get("MeanRatio"));
        }
        val = (String)props.get("MeanWeight");
        if (val != null) {
            this.meanWeight = new Double((String)props.get("MeanWeight"));
        }
        if ((val = (String)props.get("MinWeight")) != null) {
            this.minWeight = new Double((String)props.get("MinWeight"));
        }
        if ((val = (String)props.get("MaxWeight")) != null) {
            this.maxWeight = new Double((String)props.get("MaxWeight"));
        }
        if ((val = (String)props.get("NetworkCount")) != null) {
            this.networkCount = new Integer((String)props.get("NetworkCount"));
        }
        String value = (String)props.get("AttributeName");
        String[] attributes = value.split(WORDDELIMITER);
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            String curAttribute = attributes[i];
            attributeList.add(curAttribute);
        }
        this.attributeNames = attributeList;
        if (props.containsKey("CloudWords")) {
            String value2 = (String)props.get("CloudWords");
            String[] words = value2.split(WORDDELIMITER);
            ArrayList<CloudWordInfo> cloudWordList = new ArrayList<CloudWordInfo>();
            for (int i = 0; i < words.length; ++i) {
                String wordInfo = words[i];
                CloudWordInfo curInfo = new CloudWordInfo(wordInfo);
                curInfo.setCloudParameters(this);
                cloudWordList.add(curInfo);
            }
            this.cloudWords = cloudWordList;
        } else {
            this.cloudWords = new ArrayList<CloudWordInfo>();
        }
        CyTable cloudTable = networkParams.getNetwork().getDefaultNodeTable();
        if (cloudTable == null) {
            throw new RuntimeException();
        }
    }

    public void initializeNetworkCounts() {
        CyNetwork network = this.networkParams.getNetwork();
        if (this.countInitialized || network == null || this.attributeNames == null) {
            return;
        }
        this.networkCounts = new HashMap<String, Integer>();
        this.networkPairCounts = new HashMap<WordPair, Integer>();
        this.stringNodeMapping = new HashMap<String, Set<CyNode>>();
        CyTable table = network.getDefaultNodeTable();
        for (String attributeName : this.attributeNames) {
            for (CyNode curNode : this.networkParams.getNetwork().getNodeList()) {
                List list;
                CyColumn column = table.getColumn(attributeName);
                if (column.getType().equals(String.class)) {
                    String value = (String)table.getRow((Object)curNode.getSUID()).get(attributeName, String.class);
                    this.updateNetworkWordCounts(curNode, value);
                }
                if (!column.getType().equals(List.class) || !column.getListElementType().equals(String.class) || (list = table.getRow((Object)curNode.getSUID()).getList(attributeName, String.class)) == null) continue;
                String value = this.join(" ", list);
                this.updateNetworkWordCounts(curNode, value);
            }
        }
        this.countInitialized = true;
    }

    private void updateNetworkWordCounts(CyNode curNode, String nodeValue) {
        if (nodeValue == null) {
            return;
        }
        List<String> wordSet = this.processNodeString(nodeValue);
        String lastWord = "";
        for (String curWord : wordSet) {
            WordFilter filter = this.networkParams.getFilter();
            if (filter.contains(curWord)) continue;
            Map<String, Set<CyNode>> curMapping = this.getStringNodeMapping();
            if (!curMapping.containsKey(curWord)) {
                curMapping.put(curWord, new HashSet());
                this.networkCounts.put(curWord, 0);
            }
            curMapping.get(curWord).add(curNode);
            int num = this.networkCounts.get(curWord);
            this.networkCounts.put(curWord, ++num);
            if (!lastWord.equals("")) {
                WordPair pair = new WordPair(lastWord, curWord, this);
                Integer curPairCount = this.networkPairCounts.get(pair);
                int count = curPairCount == null ? 1 : curPairCount;
                this.networkPairCounts.put(pair, count);
            }
            lastWord = curWord;
        }
    }

    private void updateSelectedWordCounts(CyNode curNode, String nodeValue) {
        if (nodeValue == null) {
            return;
        }
        List<String> wordSet = this.processNodeString(nodeValue);
        String lastWord = "";
        for (String curWord : wordSet) {
            WordFilter filter = this.networkParams.getFilter();
            if (filter.contains(curWord)) continue;
            int curCount = 0;
            if (this.selectedCounts.containsKey(curWord)) {
                curCount = this.selectedCounts.get(curWord);
            }
            this.selectedCounts.put(curWord, ++curCount);
            if (!lastWord.equals("")) {
                WordPair pair = new WordPair(lastWord, curWord, this);
                Integer curPairCount = this.selectedPairCounts.get(pair);
                int count = curPairCount == null ? 1 : curPairCount;
                this.selectedPairCounts.put(pair, count);
            }
            lastWord = curWord;
        }
    }

    public void updateSelectedCounts() {
        if (this.selInitialized || this.attributeNames == null) {
            return;
        }
        if (!this.countInitialized) {
            this.initializeNetworkCounts();
        }
        this.selectedCounts = new HashMap<String, Integer>();
        this.selectedPairCounts = new HashMap<WordPair, Integer>();
        CyNetwork network = this.networkParams.getNetwork();
        CyTable table = network.getDefaultNodeTable();
        for (String attributeName : this.attributeNames) {
            for (CyNode curNode : this.getSelectedNodes()) {
                List list;
                CyColumn column = table.getColumn(attributeName);
                if (column.getType().equals(String.class)) {
                    String value = (String)table.getRow((Object)curNode.getSUID()).get(attributeName, String.class);
                    this.updateSelectedWordCounts(curNode, value);
                }
                if (!column.getType().equals(List.class) || !column.getListElementType().equals(String.class) || (list = table.getRow((Object)curNode.getSUID()).getList(attributeName, String.class)) == null) continue;
                String value = this.join(" ", list);
                this.updateSelectedWordCounts(curNode, value);
            }
        }
        this.calculateWeights();
        this.selInitialized = true;
    }

    public void calculateWeights() {
        double curMin = 0.0;
        double curMax = 0.0;
        double total = 0.0;
        int count = 0;
        boolean initialized = false;
        for (Map.Entry<String, Integer> entry : this.selectedCounts.entrySet()) {
            String curWord = entry.getKey();
            int selTotal = this.getSelectedNumNodes();
            int selCount = entry.getValue();
            int netCount = this.networkCounts.get(curWord);
            double newNetCount = Math.pow(netCount, 0.0);
            int netTotal = this.getNetworkNumNodes();
            double newNetTotal = Math.pow(netTotal, 0.0);
            double numerator = (double)selCount * newNetTotal;
            double denominator = (double)selTotal * newNetCount;
            double ratio = numerator / denominator;
            total += ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.setMinWeight(curMin);
        this.setMeanWeight(total / (double)count);
        this.setMaxWeight(curMax);
    }

    public void updateRatios() {
        double ratio;
        double denominator;
        double numerator;
        double newNetTotal;
        int netTotal;
        double newNetCount;
        int selTotal;
        if (this.ratiosInitialized) {
            return;
        }
        if (!this.selInitialized) {
            this.updateSelectedCounts();
        }
        this.ratios = new HashMap<String, Double>();
        double curMin = 0.0;
        double curMax = 0.0;
        double total = 0.0;
        int count = 0;
        boolean initialized = false;
        for (Map.Entry<String, Integer> entry : this.selectedCounts.entrySet()) {
            String curWord = entry.getKey();
            selTotal = this.getSelectedNumNodes();
            int selCount = entry.getValue();
            int netCount = this.networkCounts.get(curWord);
            newNetCount = Math.pow(netCount, this.netWeightFactor);
            netTotal = this.getNetworkNumNodes();
            newNetTotal = Math.pow(netTotal, this.netWeightFactor);
            numerator = (double)selCount * newNetTotal;
            denominator = (double)selTotal * newNetCount;
            ratio = numerator / denominator;
            this.ratios.put(curWord, ratio);
            total += ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.setMaxRatio(curMax);
        this.setMinRatio(curMin);
        this.setMeanRatio(total / (double)count);
        this.pairRatios = new HashMap<WordPair, Double>();
        for (Map.Entry<Object, Integer> entry : this.selectedPairCounts.entrySet()) {
            WordPair pair = (WordPair)entry.getKey();
            selTotal = this.getSelectedNumNodes();
            int selPairCount = entry.getValue();
            int netPairCount = this.networkPairCounts.get(pair);
            newNetCount = Math.pow(netPairCount, this.netWeightFactor);
            netTotal = this.getNetworkNumNodes();
            newNetTotal = Math.pow(netTotal, this.netWeightFactor);
            numerator = (double)selPairCount * newNetTotal;
            denominator = (double)selTotal * newNetCount;
            ratio = numerator / denominator;
            this.pairRatios.put(pair, ratio);
        }
        this.ratiosInitialized = true;
    }

    public void calculateFontSizes() {
        if (!this.ratiosInitialized) {
            this.updateRatios();
        }
        this.cloudWords = new ArrayList<CloudWordInfo>();
        if (this.displayStyle.equals(CloudDisplayStyles.NO_CLUSTERING)) {
            for (Map.Entry<String, Double> entry : this.ratios.entrySet()) {
                String curWord = entry.getKey();
                int fontSize = this.calculateFontSize(curWord, entry.getValue());
                CloudWordInfo curInfo = new CloudWordInfo(curWord, fontSize);
                curInfo.setCloudParameters(this);
                this.cloudWords.add(curInfo);
            }
            Collections.sort(this.cloudWords);
        } else {
            SemanticSummaryClusterBuilder builder = new SemanticSummaryClusterBuilder();
            builder.initialize(this);
            builder.clusterData(this.getClusterCutoff());
            builder.buildCloudWords();
            this.cloudWords = builder.getCloudWords();
        }
    }

    public int calculateFontSize(String aWord, double ratio) {
        double zeroedMinWeight = this.minWeight - this.minWeight;
        double zeroedMeanWeight = this.meanWeight - this.minWeight;
        double zeroedMaxWeight = this.maxWeight - this.minWeight;
        double zeroedMinRatio = this.minRatio - this.minRatio;
        double zeroedMeanRatio = this.meanRatio - this.minRatio;
        double zeroedMaxRatio = this.maxRatio - this.minRatio;
        double zeroedRatio = ratio - this.minRatio;
        double newRatio = zeroedRatio * zeroedMeanWeight / zeroedMeanRatio;
        int maxFont = this.networkParams.getMaxFont();
        int minFont = this.networkParams.getMinFont();
        if (this.isCloseEnough(zeroedMaxRatio, zeroedMinRatio)) {
            return minFont + (maxFont - minFont) / 2;
        }
        double slope = (double)(maxFont - minFont) / (zeroedMaxWeight - zeroedMinWeight);
        double yIntercept = (double)maxFont - slope * zeroedMaxWeight;
        long temp = Math.round(slope * newRatio + yIntercept);
        int fontSize = Math.round(temp);
        return fontSize;
    }

    private boolean isCloseEnough(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-5 * Math.max(Math.abs(d1), Math.abs(d2));
    }

    public void retrieveInputVals(SemanticSummaryInputPanel inputPanel) {
        SliderBarPanel panel = inputPanel.getSliderBarPanel();
        JSlider slider = panel.getSlider();
        double netNorm = (double)slider.getValue() / panel.getPrecision();
        this.setNetWeightFactor(netNorm);
        Boolean selected = inputPanel.getUseNetworkCounts().isSelected();
        this.useNetNormal = selected;
        Object[] attributes = inputPanel.getAttributeList().getSelectedValues();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            Object curAttribute = attributes[i];
            if (!(curAttribute instanceof String)) continue;
            attributeList.add((String)curAttribute);
        }
        this.setAttributeNames(attributeList);
        JFormattedTextField maxWordsTextField = inputPanel.getMaxWordsTextField();
        Number value = (Number)maxWordsTextField.getValue();
        if (value != null && value.intValue() >= 0) {
            this.setMaxWords(value.intValue());
        } else {
            maxWordsTextField.setValue(this.defaultMaxWords);
            this.setMaxWords(this.defaultMaxWords);
            String message = "The maximum number of words to display must be greater than or equal to 0.";
            JOptionPane.showMessageDialog(inputPanel, message, "Parameter out of bounds", 2);
        }
        JFormattedTextField clusterCutoffTextField = inputPanel.getClusterCutoffTextField();
        value = (Number)clusterCutoffTextField.getValue();
        if (value != null && value.doubleValue() >= 0.0) {
            this.setClusterCutoff(value.doubleValue());
        } else {
            clusterCutoffTextField.setValue(this.defaultClusterCutoff);
            this.setClusterCutoff(this.defaultClusterCutoff);
            String message = "The cluster cutoff must be greater than or equal to 0";
            JOptionPane.showMessageDialog(inputPanel, message, "Parameter out of bounds", 2);
        }
        Object style = inputPanel.getCMBStyle().getSelectedItem();
        if (style instanceof String) {
            this.setDisplayStyle((String)style);
        } else {
            this.setDisplayStyle(this.defaultStyle);
            inputPanel.getCMBStyle().setSelectedItem(this.defaultStyle);
            String message = "You must select one of the available styles.";
            JOptionPane.showMessageDialog(inputPanel, message, "Parameter out of bounds", 2);
        }
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("CloudName\t" + this.cloudName + "\n");
        paramVariables.append("DisplayStyle\t" + this.displayStyle + "\n");
        StringBuffer output = new StringBuffer();
        if (this.attributeNames != null) {
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                output.append(this.attributeNames.get(i) + WORDDELIMITER);
            }
        }
        paramVariables.append("AttributeName\t" + output.toString() + "\n");
        paramVariables.append("NetWeightFactor\t" + this.netWeightFactor + "\n");
        paramVariables.append("ClusterCutoff\t" + this.clusterCutoff + "\n");
        paramVariables.append("CountInitialized\t" + this.countInitialized + "\n");
        paramVariables.append("SelInitialized\t" + this.selInitialized + "\n");
        paramVariables.append("RatiosInitialized\t" + this.ratiosInitialized + "\n");
        paramVariables.append("MinRatio\t" + this.minRatio + "\n");
        paramVariables.append("MaxRatio\t" + this.maxRatio + "\n");
        paramVariables.append("MaxWords\t" + this.maxWords + "\n");
        paramVariables.append("MeanRatio\t" + this.meanRatio + "\n");
        paramVariables.append("MeanWeight\t" + this.meanWeight + "\n");
        paramVariables.append("MaxWeight\t" + this.maxWeight + "\n");
        paramVariables.append("MinWeight\t" + this.minWeight + "\n");
        paramVariables.append("CloudNum\t" + this.cloudNum + "\n");
        paramVariables.append("UseNetNormal\t" + this.useNetNormal + "\n");
        paramVariables.append("NetworkCount\t" + this.networkCount + "\n");
        if (this.clusterTable != null) {
            paramVariables.append("ClusterTableName\t" + this.clusterTable.getTitle() + "\n");
        }
        StringBuffer output2 = new StringBuffer();
        for (int i = 0; i < this.cloudWords.size(); ++i) {
            output2.append(this.cloudWords.get(i).toString() + WORDDELIMITER);
        }
        paramVariables.append("CloudWords\t" + output2.toString() + "\n");
        return paramVariables.toString();
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        HashMap<String, Serializable> newMap = type == 1 ? new HashMap<String, Serializable>() : (type == 2 ? new HashMap() : (type == 3 ? new HashMap() : new HashMap()));
        if (!fileInput.equals("")) {
            String[] lines = fileInput.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (type == 1) {
                    newMap.put(tokens[0], Integer.valueOf(Integer.parseInt(tokens[1])));
                }
                if (type == 2) {
                    String[] nodes = tokens[1].split(NODEDELIMITER);
                    ArrayList<String> nodeNames = new ArrayList<String>();
                    for (int j = 0; j < nodes.length; ++j) {
                        nodeNames.add(nodes[j]);
                    }
                    newMap.put(tokens[0], nodeNames);
                }
                if (type != 3) continue;
                newMap.put(tokens[0], Double.valueOf(Double.parseDouble(tokens[1])));
            }
        }
        return newMap;
    }

    private String getNodeAttributeVal(CyNetwork network, CyNode curNode, String attributeName) {
        CyTable table = network.getDefaultNodeTable();
        CyColumn column = table.getColumn(attributeName);
        if (column.getType().equals(String.class)) {
            return (String)table.getRow((Object)curNode.getSUID()).get(attributeName, String.class);
        }
        if (column.getType().equals(List.class) && column.getListElementType().equals(String.class)) {
            List list = table.getRow((Object)curNode.getSUID()).getList(attributeName, String.class);
            if (list == null) {
                return null;
            }
            return this.join(" ", list);
        }
        return null;
    }

    private String join(String delimiter, List<String> list) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                buffer.append(delimiter);
            }
            buffer.append(item);
        }
        return buffer.toString();
    }

    private List<String> processNodeString(String nodeValue) {
        nodeValue = nodeValue.toLowerCase();
        String controlString = Character.toString('\u001f');
        WordDelimiters delims = this.getNetworkParams().getDelimiter();
        nodeValue = nodeValue.replaceAll(delims.getRegex(), controlString);
        for (String userDelim : delims.getUserDelims()) {
            nodeValue = nodeValue.replaceAll(userDelim, controlString);
        }
        ArrayList<String> wordSet = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(nodeValue, controlString);
        while (token.hasMoreTokens()) {
            String a = token.nextToken();
            if (this.getNetworkParams().getIsStemming()) {
                Stemmer stem = new Stemmer();
                for (int i = 0; i < a.length(); ++i) {
                    char ch = a.charAt(i);
                    stem.add(ch);
                }
                stem.stem();
                a = stem.toString();
            }
            if (wordSet.contains(a)) continue;
            wordSet.add(a);
        }
        return wordSet;
    }

    @Override
    public int compareTo(CloudParameters compare) {
        int thisCount = this.getCloudNum();
        int compareCount = compare.getCloudNum();
        return thisCount - compareCount;
    }

    public String getNextNetworkName() {
        String name = this.networkParams.getNetworkName() + "-" + this.cloudName + "-" + NETWORKNAME + SEPARATER + this.networkCount;
        ++this.networkCount;
        return name;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void setCloudName(String name) {
        CyNetwork network = this.networkParams.getNetwork();
        if (network == null) {
            this.cloudName = name;
            return;
        }
        CyTable table = network.getDefaultNodeTable();
        if (this.cloudName != null) {
            CyColumn column = table.getColumn(this.cloudName);
            column.setName(name);
        } else {
            if (table.getColumn(name) != null) {
                table.deleteColumn(name);
            }
            table.createColumn(name, Boolean.class, false);
        }
        this.cloudName = name;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(List<String> names) {
        boolean changed = false;
        if (this.attributeNames == null || names.size() != this.attributeNames.size()) {
            changed = true;
        } else {
            for (int i = 0; i < names.size(); ++i) {
                String curAttribute = names.get(i);
                if (this.attributeNames.contains(curAttribute)) continue;
                changed = true;
            }
        }
        if (changed) {
            this.countInitialized = false;
            this.selInitialized = false;
            this.ratiosInitialized = false;
        }
        this.attributeNames = names;
    }

    public void addAttributeName(String name) {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList<String>();
        }
        if (!this.attributeNames.contains(name)) {
            this.attributeNames.add(name);
            this.countInitialized = false;
            this.selInitialized = false;
            this.ratiosInitialized = false;
        }
    }

    public SemanticSummaryParameters getNetworkParams() {
        return this.networkParams;
    }

    public Set<CyNode> getSelectedNodes() {
        return this.getSelectedNodes(this.networkParams.getNetwork());
    }

    private Set<CyNode> getSelectedNodes(CyNetwork network) {
        if (network == null) {
            return Collections.emptySet();
        }
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyNode node : network.getNodeList()) {
            CyRow row = network.getRow((CyIdentifiable)node);
            Boolean selected = (Boolean)row.get(this.cloudName, Boolean.class);
            if (selected == null || !selected.booleanValue()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public void setSelectedNodes(Set<CyNode> nodes) {
        this.setSelectedNodes(this.networkParams.getNetwork(), nodes);
        this.selInitialized = false;
        this.ratiosInitialized = false;
    }

    private void setSelectedNodes(CyNetwork network, Set<CyNode> nodes) {
        if (network == null) {
            return;
        }
        for (CyNode node : network.getNodeList()) {
            CyRow row = network.getRow((CyIdentifiable)node);
            Boolean wasSelected = (Boolean)row.get(this.cloudName, Boolean.class);
            if (wasSelected == null) {
                wasSelected = Boolean.FALSE;
            }
            boolean selected = nodes.contains(node);
            if (wasSelected == selected) continue;
            row.set(this.cloudName, (Object)selected);
        }
    }

    public int getSelectedNumNodes() {
        return this.getSelectedNumNodes(this.networkParams.getNetwork());
    }

    private int getSelectedNumNodes(CyNetwork network) {
        if (network == null) {
            return 0;
        }
        return this.getSelectedNodes(network).size();
    }

    public Map<String, Set<CyNode>> getStringNodeMapping() {
        return this.stringNodeMapping;
    }

    public Map<String, Integer> getNetworkCounts() {
        return this.networkCounts;
    }

    public Map<String, Integer> getSelectedCounts() {
        return this.selectedCounts;
    }

    public Map<WordPair, Integer> getSelectedPairCounts() {
        return this.selectedPairCounts;
    }

    public Map<WordPair, Integer> getNetworkPairCounts() {
        return this.networkPairCounts;
    }

    public Map<String, Double> getRatios() {
        return this.ratios;
    }

    public Map<WordPair, Double> getPairRatios() {
        return this.pairRatios;
    }

    public List<CloudWordInfo> getCloudWordInfoList() {
        return this.cloudWords;
    }

    public void setCloudWordInfoList(ArrayList<CloudWordInfo> words) {
        this.cloudWords = words;
    }

    public int getNetworkNumNodes() {
        if (this.networkParams == null) {
            return 0;
        }
        CyNetwork network = this.networkParams.getNetwork();
        if (network == null) {
            return 0;
        }
        return network.getNodeCount();
    }

    public double getMinRatio() {
        return this.minRatio;
    }

    public void setMinRatio(double ratio) {
        this.minRatio = ratio;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public void setMaxRatio(double ratio) {
        this.maxRatio = ratio;
    }

    public double getMeanRatio() {
        return this.meanRatio;
    }

    public void setMeanRatio(double ratio) {
        this.meanRatio = ratio;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public void setMinWeight(double val) {
        this.minWeight = val;
    }

    public double getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(double val) {
        this.maxWeight = val;
    }

    public double getMeanWeight() {
        return this.meanWeight;
    }

    public void setMeanWeight(double val) {
        this.meanWeight = val;
    }

    public boolean getCountInitialized() {
        return this.countInitialized;
    }

    public void setCountInitialized(boolean val) {
        this.countInitialized = val;
    }

    public boolean getSelInitialized() {
        return this.selInitialized;
    }

    public void setSelInitialized(boolean val) {
        this.selInitialized = val;
    }

    public boolean getRatiosInitialized() {
        return this.ratiosInitialized;
    }

    public void setRatiosInitialized(boolean val) {
        this.ratiosInitialized = val;
    }

    public double getNetWeightFactor() {
        return this.netWeightFactor;
    }

    public void setNetWeightFactor(double val) {
        if (this.netWeightFactor != val) {
            this.ratiosInitialized = false;
        }
        this.netWeightFactor = val;
    }

    public double getClusterCutoff() {
        return this.clusterCutoff;
    }

    public void setClusterCutoff(double val) {
        this.clusterCutoff = val;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(int val) {
        this.maxWords = val;
    }

    public double getDefaultNetWeight() {
        return this.defaultNetWeight;
    }

    public String getDefaultAttName() {
        return this.defaultAttName;
    }

    public int getDefaultMaxWords() {
        return this.defaultMaxWords;
    }

    public double getDefaultClusterCutoff() {
        return this.defaultClusterCutoff;
    }

    public String getDefaultDisplayStyle() {
        return this.defaultStyle;
    }

    public int getCloudNum() {
        return this.cloudNum;
    }

    public void setCloudNum(int num) {
        this.cloudNum = num;
    }

    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(String style) {
        this.displayStyle = style;
    }

    public boolean getUseNetNormal() {
        return this.useNetNormal;
    }

    public void setUseNetNormal(boolean val) {
        this.useNetNormal = val;
    }

    public String getClusterColumnName() {
        return this.clusterColumnName;
    }

    public void setClusterColumnName(String clusterColumnName) {
        this.clusterColumnName = clusterColumnName;
    }

    public void setClusterTable(CyTable clusterTable) {
        this.clusterTable = clusterTable;
    }

    public CyTable getClusterTable() {
        if (this.clusterTable != null) {
            return this.clusterTable;
        }
        try {
            CyNetwork network = this.networkParams.getNetwork();
            CyTableManager tableManager = this.networkParams.getModelManager().getTableManager();
            String tableName = this.cloudName.substring(0, this.cloudName.indexOf(" Cloud "));
            return tableManager.getTable(((Long)network.getDefaultNetworkTable().getRow((Object)network.getSUID()).get(tableName, Long.class)).longValue());
        }
        catch (Exception e) {
            return null;
        }
    }
}

