/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.WordCloudVisualStyleFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedEdgesListener;
import org.cytoscape.model.events.AddedNodesEvent;
import org.cytoscape.model.events.AddedNodesListener;
import org.cytoscape.model.events.RemovedEdgesEvent;
import org.cytoscape.model.events.RemovedEdgesListener;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.events.RemovedNodesListener;
import org.cytoscape.task.visualize.ApplyPreferredLayoutTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskManager;

public class ModelManager
implements AddedNodesListener,
RemovedNodesListener,
AddedEdgesListener,
RemovedEdgesListener {
    static final Lock uidLock = new ReentrantLock();
    private CyNetworkTableManager networkTableManager;
    private CyTableManager tableManager;
    private CyTableFactory tableFactory;
    private CyNetworkFactory networkFactory;
    private CyNetworkViewFactory networkViewFactory;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager viewManager;
    private VisualMappingManager visualMappingManager;
    private ApplyPreferredLayoutTaskFactory layoutTaskFactory;
    private TaskManager<?, ?> taskManager;
    private Map<CyNetwork, Object> changedNetworks;
    private WordCloudVisualStyleFactory cloudStyleFactory;

    public ModelManager(CyNetworkTableManager networkTableManager, CyTableManager tableManager, CyTableFactory tableFactory, CyNetworkFactory networkFactory, CyNetworkViewFactory networkViewFactory, CyNetworkManager networkManager, CyNetworkViewManager viewManager, VisualMappingManager visualMappingManager, ApplyPreferredLayoutTaskFactory layoutTaskFactory, TaskManager<?, ?> taskManager, WordCloudVisualStyleFactory cloudStyleFactory) {
        this.networkTableManager = networkTableManager;
        this.tableManager = tableManager;
        this.tableFactory = tableFactory;
        this.networkFactory = networkFactory;
        this.networkViewFactory = networkViewFactory;
        this.networkManager = networkManager;
        this.viewManager = viewManager;
        this.visualMappingManager = visualMappingManager;
        this.layoutTaskFactory = layoutTaskFactory;
        this.taskManager = taskManager;
        this.cloudStyleFactory = cloudStyleFactory;
        this.changedNetworks = new WeakHashMap<CyNetwork, Object>();
    }

    public boolean hasCloudMetadata(CyNetwork network) {
        return network.getDefaultNetworkTable().getColumn("Cloud Network UID") != null;
    }

    public void createCloudMetadata(CyNetwork network) {
        CyTable networkTable = network.getDefaultNetworkTable();
        networkTable.createColumn("Use Stemming", Boolean.class, false);
        networkTable.createColumn("Cloud Counter", Integer.class, false);
        networkTable.createColumn("Cloud Network UID", Integer.class, false);
        CyRow row = network.getRow((CyIdentifiable)network);
        row.set("Use Stemming", (Object)Boolean.FALSE);
        row.set("Cloud Counter", (Object)1);
        row.set("Cloud Network UID", (Object)this.getNextNetworkUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNetworkUID() {
        uidLock.lock();
        try {
            int maxUid = 0;
            for (CyNetwork network : this.networkManager.getNetworkSet()) {
                Integer uid;
                if (!this.hasCloudMetadata(network) || (uid = (Integer)network.getRow((CyIdentifiable)network).get("Cloud Network UID", Integer.class)) == null || uid <= maxUid) continue;
                maxUid = uid;
            }
            int n = maxUid + 1;
            return n;
        }
        finally {
            uidLock.unlock();
        }
    }

    public void incrementCloudCounter(CyNetwork network) {
        CyRow row = network.getRow((CyIdentifiable)network);
        int count = (Integer)row.get("Cloud Counter", Integer.class);
        row.set("Cloud Counter", (Object)(count + 1));
    }

    public CyNetwork createNetwork(String name) {
        CyNetwork network = this.networkFactory.createNetwork();
        network.getRow((CyIdentifiable)network).set("name", (Object)name);
        return network;
    }

    public void registerNetwork(CyNetwork network) {
        this.networkManager.addNetwork(network);
    }

    public CyNetworkView createNetworkView(CyNetwork network) {
        return this.networkViewFactory.createNetworkView(network);
    }

    public void registerNetworkView(CyNetworkView view) {
        this.viewManager.addNetworkView(view);
    }

    public void applyVisualStyle(CyNetworkView view, CloudParameters cloud) {
        CyNetwork network = (CyNetwork)view.getModel();
        String newNetworkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        String vs_name = newNetworkName + "WordCloud_style";
        VisualStyle vs = this.getVisualStyle(vs_name);
        if (vs == null) {
            vs = this.cloudStyleFactory.createVisualStyle(vs_name, cloud);
            this.visualMappingManager.addVisualStyle(vs);
        }
        this.visualMappingManager.setVisualStyle(vs, view);
        vs.apply(view);
    }

    public VisualStyle getVisualStyle(String name) {
        for (VisualStyle style : this.visualMappingManager.getAllVisualStyles()) {
            if (!style.getTitle().equals(name)) continue;
            return style;
        }
        return null;
    }

    public void applyPreferredLayout(CyNetworkView view) {
        this.taskManager.execute(this.layoutTaskFactory.createTaskIterator(Collections.singleton(view)));
    }

    public boolean hasChanges(CyNetwork network) {
        return this.changedNetworks.containsKey(network);
    }

    public void acceptChanges(CyNetwork network) {
        this.changedNetworks.remove(network);
    }

    public void handleEvent(AddedEdgesEvent event) {
        this.changedNetworks.put((CyNetwork)event.getSource(), null);
    }

    public void handleEvent(AddedNodesEvent event) {
        this.changedNetworks.put((CyNetwork)event.getSource(), null);
    }

    public void handleEvent(RemovedEdgesEvent event) {
        this.changedNetworks.put((CyNetwork)event.getSource(), null);
    }

    public void handleEvent(RemovedNodesEvent event) {
        this.changedNetworks.put((CyNetwork)event.getSource(), null);
    }

    public Set<CyNetwork> getSemanticSummaryNetworks() {
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
        for (CyNetwork network : this.networkManager.getNetworkSet()) {
            if (!this.hasCloudMetadata(network)) continue;
            networks.add(network);
        }
        return networks;
    }

    public CyNetwork getNetwork(int uid) {
        for (CyNetwork network : this.networkManager.getNetworkSet()) {
            Integer other;
            CyRow row = network.getRow((CyIdentifiable)network);
            if (row == null || (other = (Integer)row.get("Cloud Network UID", Integer.class)) == null || uid != other) continue;
            return network;
        }
        return null;
    }

    public CyTableManager getTableManager() {
        return this.tableManager;
    }
}

