/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.HashMap;
import java.util.Map;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.ModelManager;
import org.baderlab.wordcloud.internal.WordDelimiters;
import org.baderlab.wordcloud.internal.WordFilter;
import org.baderlab.wordcloud.internal.WordFilterFactory;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;

public class SemanticSummaryParameters {
    private CyNetwork network;
    private Map<String, CloudParameters> clouds = new HashMap<String, CloudParameters>();
    private static final String CLOUDNAME = "Cloud";
    private static final String SEPARATER = "_";
    private static final Integer MINFONTSIZE = 12;
    private static final Integer MAXFONTSIZE = 64;
    private WordFilter filter;
    private WordDelimiters delimiters;
    private ModelManager modelManager;

    public SemanticSummaryParameters(ModelManager modelManager, CySwingApplication application, WordFilterFactory filterFactory) {
        this.filter = filterFactory.createWordFilter();
        this.delimiters = new WordDelimiters(application);
        this.modelManager = modelManager;
    }

    public SemanticSummaryParameters(CyNetwork network, ModelManager modelManager, CySwingApplication application, WordFilterFactory filterFactory) {
        this(modelManager, application, filterFactory);
        this.network = network;
        if (!modelManager.hasCloudMetadata(network)) {
            modelManager.createCloudMetadata(network);
        }
    }

    public void addCloud(String name, CloudParameters params) {
        if (!this.clouds.containsKey(name)) {
            this.clouds.put(name, params);
        }
    }

    public void removeCloud(String name) {
        if (this.clouds.containsKey(name)) {
            this.clouds.remove(name);
        }
    }

    public boolean containsCloud(String name) {
        return this.clouds.containsKey(name);
    }

    public CloudParameters getCloud(String name) {
        if (this.containsCloud(name)) {
            return this.clouds.get(name);
        }
        return null;
    }

    public void networkChanged() {
        for (String curCloud : this.clouds.keySet()) {
            CloudParameters cloudParams = this.clouds.get(curCloud);
            cloudParams.setCountInitialized(false);
            cloudParams.setSelInitialized(false);
            cloudParams.setRatiosInitialized(false);
        }
        this.modelManager.acceptChanges(this.network);
    }

    public String getNextCloudName() {
        int cloudCount = this.getCloudCount();
        String name = "Cloud_" + cloudCount;
        this.modelManager.incrementCloudCounter(this.network);
        return name;
    }

    public void updateParameters(CyNetwork network) {
        this.networkChanged();
    }

    public boolean networkHasChanged(CyNetwork network) {
        return this.modelManager.hasChanges(network);
    }

    public String getNetworkName() {
        if (this.network == null) {
            return "No Network Loaded";
        }
        return (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
    }

    public Map<String, CloudParameters> getClouds() {
        return this.clouds;
    }

    public void setClouds(HashMap<String, CloudParameters> cloudMap) {
        this.clouds = cloudMap;
    }

    public Integer getMaxFont() {
        return MAXFONTSIZE;
    }

    public Integer getMinFont() {
        return MINFONTSIZE;
    }

    public Integer getCloudCount() {
        return (Integer)this.network.getRow((CyIdentifiable)this.network).get("Cloud Counter", Integer.class);
    }

    public String getCloudName() {
        return CLOUDNAME;
    }

    public String getSeparater() {
        return SEPARATER;
    }

    public WordFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WordFilter aFilter) {
        this.filter = aFilter;
    }

    public WordDelimiters getDelimiter() {
        return this.delimiters;
    }

    public void setDelimiter(WordDelimiters aDelimiter) {
        this.delimiters = aDelimiter;
    }

    public boolean getIsStemming() {
        return (Boolean)this.network.getRow((CyIdentifiable)this.network).get("Use Stemming", Boolean.class);
    }

    public void setIsStemming(boolean val) {
        this.network.getRow((CyIdentifiable)this.network).set("Use Stemming", (Object)val);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }
}

