/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.baderlab.wordcloud.internal.AbstractSemanticSummaryAction;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.CloudWordInfo;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;

public class UpdateCloudAction
extends AbstractSemanticSummaryAction {
    private static final long serialVersionUID = -814444939886393362L;
    private SemanticSummaryManager cloudManager;
    private CyApplicationManager applicationManager;

    public UpdateCloudAction(SemanticSummaryManager cloudManager, CyApplicationManager applicationManager) {
        super("Update Cloud");
        this.cloudManager = cloudManager;
        this.applicationManager = applicationManager;
    }

    public void actionPerformed(ActionEvent ae) {
        this.doRealAction();
    }

    public void doRealAction() {
        this.pluginAction.doRealAction();
        CloudParameters cloudParams = this.cloudManager.getCurCloud();
        SemanticSummaryParameters networkParams = cloudParams.getNetworkParams();
        CyNetwork network = networkParams.getNetwork();
        if (network == null || !this.cloudManager.isSemanticSummary(network)) {
            return;
        }
        if (networkParams.networkHasChanged(network)) {
            networkParams.updateParameters(network);
        }
        cloudParams.retrieveInputVals(this.cloudManager.getInputWindow());
        cloudParams.calculateFontSizes();
        if (cloudParams.getClusterTable() != null) {
            List<CloudWordInfo> wordInfos = cloudParams.getCloudWordInfoList();
            ArrayList<String> WC_Word = new ArrayList<String>();
            ArrayList<String> WC_FontSize = new ArrayList<String>();
            ArrayList<String> WC_Cluster = new ArrayList<String>();
            ArrayList<String> WC_Number = new ArrayList<String>();
            for (CloudWordInfo cloudWord : wordInfos) {
                String[] wordInfo = cloudWord.toSplitString();
                WC_Word.add(wordInfo[0]);
                WC_FontSize.add(wordInfo[1]);
                WC_Cluster.add(wordInfo[2]);
                WC_Number.add(wordInfo[3]);
            }
            CyRow clusterRow = cloudParams.getClusterTable().getRow((Object)cloudParams.getCloudName());
            clusterRow.set("WC_Word", WC_Word);
            clusterRow.set("WC_FontSize", WC_FontSize);
            clusterRow.set("WC_Cluster", WC_Cluster);
            clusterRow.set("WC_Number", WC_Number);
        }
        CloudDisplayPanel cloudPanel = this.cloudManager.getCloudWindow();
        cloudPanel.updateCloudDisplay(cloudParams);
    }
}

