/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.baderlab.wordcloud.internal.WidestStringProvider;

public class WidestStringComboBoxPopupMenuListener
implements PopupMenuListener {
    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox box = (JComboBox)e.getSource();
        ComboBoxModel cbm = box.getModel();
        if (!(cbm instanceof WidestStringProvider)) {
            return;
        }
        WidestStringProvider wsp = (WidestStringProvider)((Object)cbm);
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        Component scrollObject = ((JComponent)((Object)comp)).getComponent(0);
        if (!(scrollObject instanceof JScrollPane)) {
            return;
        }
        JScrollPane scrollPane = (JScrollPane)scrollObject;
        FontMetrics fm = box.getFontMetrics(scrollPane.getFont());
        int w = fm.stringWidth(wsp.getWidest());
        int h = (int)scrollPane.getMinimumSize().getHeight();
        Dimension d = new Dimension(Math.max((int)((double)w + scrollPane.getVerticalScrollBar().getMinimumSize().getWidth()), box.getWidth()), h);
        scrollPane.setPreferredSize(d);
        scrollPane.setMaximumSize(d);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

