/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Color;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.CreateCloudNetworkAction;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public class WordCloudVisualStyleFactory {
    VisualStyleFactory styleFactory;
    VisualMappingFunctionFactory continuousMappingFactory;
    VisualMappingFunctionFactory passthroughMappingFactory;

    public WordCloudVisualStyleFactory(VisualStyleFactory styleFactory, VisualMappingFunctionFactory continuousMappingFactory, VisualMappingFunctionFactory passthroughMappingFactory) {
        this.styleFactory = styleFactory;
        this.continuousMappingFactory = continuousMappingFactory;
        this.passthroughMappingFactory = passthroughMappingFactory;
    }

    public VisualStyle createVisualStyle(String visualStyleName, CloudParameters cloudParams) {
        VisualStyle style = this.styleFactory.createVisualStyle(visualStyleName);
        this.setEdgeStyles(style);
        this.setNodeStyles(style, cloudParams);
        return style;
    }

    private void setEdgeStyles(VisualStyle style) {
        style.setDefaultValue(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, (Object)new Color(100, 200, 0));
        ContinuousMapping edgeWidth = (ContinuousMapping)this.continuousMappingFactory.createVisualMappingFunction(CreateCloudNetworkAction.CO_VAL, Double.class, BasicVisualLexicon.EDGE_WIDTH);
        Double under_width = 0.5;
        Double min_width = 1.0;
        Double max_width = 8.0;
        Double over_width = 9.0;
        edgeWidth.addPoint((Object)1.0, new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width));
        edgeWidth.addPoint((Object)40.0, new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width));
        style.addVisualMappingFunction((VisualMappingFunction)edgeWidth);
    }

    private void setNodeStyles(VisualStyle style, CloudParameters cloudParams) {
        style.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)Color.gray);
        style.setDefaultValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)Color.gray);
        style.setDefaultValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        style.setDefaultValue(BasicVisualLexicon.NODE_SIZE, (Object)35.0);
        style.setDefaultValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)4.0);
        ContinuousMapping nodeSize = (ContinuousMapping)this.continuousMappingFactory.createVisualMappingFunction(CreateCloudNetworkAction.WORD_VAL, Double.class, BasicVisualLexicon.NODE_SIZE);
        double min = 20.0;
        double max = 65.0;
        nodeSize.addPoint((Object)cloudParams.getMinRatio(), new BoundaryRangeValues((Object)min, (Object)min, (Object)min));
        nodeSize.addPoint((Object)cloudParams.getMaxRatio(), new BoundaryRangeValues((Object)max, (Object)max, (Object)max));
        ContinuousMapping labelSize = (ContinuousMapping)this.continuousMappingFactory.createVisualMappingFunction(CreateCloudNetworkAction.WORD_VAL, Double.class, BasicVisualLexicon.NODE_LABEL_FONT_SIZE);
        int min2 = 12;
        int max2 = 56;
        labelSize.addPoint((Object)cloudParams.getMinRatio(), new BoundaryRangeValues((Object)min2, (Object)min2, (Object)min2));
        labelSize.addPoint((Object)cloudParams.getMaxRatio(), new BoundaryRangeValues((Object)max2, (Object)max2, (Object)max2));
        VisualMappingFunction nodeLabel = this.passthroughMappingFactory.createVisualMappingFunction("name", String.class, BasicVisualLexicon.NODE_LABEL);
        style.addVisualMappingFunction((VisualMappingFunction)nodeSize);
        style.addVisualMappingFunction((VisualMappingFunction)labelSize);
        style.addVisualMappingFunction(nodeLabel);
    }
}

