/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.Map;
import org.baderlab.wordcloud.internal.CloudParameters;

public class WordPair
implements Comparable<WordPair> {
    private String firstWord;
    private String secondWord;
    private Double probability;
    private CloudParameters params;

    public WordPair(String aWord, String nextWord, CloudParameters cloudParams) {
        this.firstWord = aWord;
        this.secondWord = nextWord;
        this.params = cloudParams;
        this.probability = 0.0;
    }

    public void calculateProbability(int pairCount) {
        Map<String, Integer> selectedCounts = this.params.getSelectedCounts();
        Integer total = 0;
        for (String word : selectedCounts.keySet()) {
            total = total + selectedCounts.get(word);
        }
        Integer firstCount = selectedCounts.get(this.firstWord);
        Integer secondCount = selectedCounts.get(this.secondWord);
        Integer numerator = pairCount * total;
        Double doubleNumerator = numerator.doubleValue();
        Integer denominator = firstCount * secondCount;
        Double doubleDenom = denominator.doubleValue();
        this.probability = doubleNumerator / doubleDenom;
    }

    @Override
    public int compareTo(WordPair second) {
        Double firstProb = this.probability;
        Double secondProb = second.probability;
        if (firstProb < secondProb) {
            return -1;
        }
        if (firstProb > secondProb) {
            return 1;
        }
        Double firstRatio = this.getCloudParameters().getPairRatios().get(this);
        Double secondRatio = second.getCloudParameters().getPairRatios().get(second);
        if (firstRatio < secondRatio) {
            return -1;
        }
        if (firstRatio > secondRatio) {
            return 1;
        }
        int result = this.firstWord.compareTo(second.firstWord);
        if (result != 0) {
            return result;
        }
        return this.secondWord.compareTo(second.secondWord);
    }

    public void setFirstWord(String aWord) {
        this.firstWord = aWord;
    }

    public String getFirstWord() {
        return this.firstWord;
    }

    public void setSecondWord(String aWord) {
        this.secondWord = aWord;
    }

    public String getSecondWord() {
        return this.secondWord;
    }

    public void setCloudParameters(CloudParameters aParam) {
        this.params = aParam;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public Double getProbability() {
        return this.probability;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WordPair)) {
            return false;
        }
        WordPair other = (WordPair)object;
        return this.firstWord.equals(other.firstWord) && this.secondWord.equals(other.secondWord);
    }

    public int hashCode() {
        return this.firstWord.hashCode() * 31 + this.secondWord.hashCode();
    }
}

