/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.baderlab.wordcloud.internal.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.CloudWordInfo;
import org.baderlab.wordcloud.internal.ModifiedClusterFlowLayout;
import org.baderlab.wordcloud.internal.ModifiedFlowLayout;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryPluginAction;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;

public class CloudDisplayPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 5996569544692738989L;
    JPanel tagCloudFlowPanel;
    JScrollPane cloudScroll;
    CloudParameters curCloud;
    JPanel saveCloudPanel;
    private CyApplicationManager applicationManager;
    private SemanticSummaryManager cloudManager;
    private SemanticSummaryPluginAction pluginAction;

    public CloudDisplayPanel(CyApplicationManager applicationManager, SemanticSummaryManager cloudManager, SemanticSummaryPluginAction pluginAction) {
        this.applicationManager = applicationManager;
        this.cloudManager = cloudManager;
        this.pluginAction = pluginAction;
        this.setLayout(new BorderLayout());
        this.tagCloudFlowPanel = this.initializeTagCloud();
        this.cloudScroll = new JScrollPane(this.tagCloudFlowPanel);
        this.cloudScroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.cloudScroll, "Center");
    }

    private JPanel initializeTagCloud() {
        JPanel panel = new JPanel(new ModifiedFlowLayout(1, 30, 25));
        return panel;
    }

    public void clearCloud() {
        this.tagCloudFlowPanel.removeAll();
        this.tagCloudFlowPanel.setLayout(new ModifiedFlowLayout(1, 30, 25));
        this.tagCloudFlowPanel.revalidate();
        this.cloudScroll.revalidate();
        this.tagCloudFlowPanel.updateUI();
        this.curCloud = null;
    }

    public void updateCloudDisplay(CloudParameters params) {
        JPanel curPanel;
        this.clearCloud();
        this.curCloud = params;
        ArrayList<CloudWordInfo> copy = new ArrayList<CloudWordInfo>();
        List<CloudWordInfo> original = this.curCloud.getCloudWordInfoList();
        for (int i = 0; i < original.size(); ++i) {
            CloudWordInfo curInfo = original.get(i);
            copy.add(curInfo);
        }
        Collections.sort(copy);
        Integer max = params.getMaxWords();
        Integer numWords = copy.size();
        if (max < numWords) {
            copy.subList(max, numWords).clear();
        }
        int count = 0;
        HashMap<Integer, JPanel> clusters = new HashMap<Integer, JPanel>();
        List<CloudWordInfo> wordInfo = this.curCloud.getCloudWordInfoList();
        Iterator<CloudWordInfo> iter = wordInfo.iterator();
        while (iter.hasNext() && count < params.getMaxWords()) {
            CloudWordInfo curWordInfo = iter.next();
            if (!copy.contains(curWordInfo)) continue;
            Integer clusterNum = curWordInfo.getCluster();
            JLabel curLabel = curWordInfo.createCloudLabel(this.applicationManager, this.cloudManager, this.pluginAction);
            if (clusters.containsKey(clusterNum)) {
                curPanel = (JPanel)clusters.get(clusterNum);
            } else {
                if (params.getDisplayStyle().equals(CloudDisplayStyles.NO_CLUSTERING)) {
                    curPanel = this.tagCloudFlowPanel;
                    curPanel.setLayout(new ModifiedFlowLayout(1, 10, 0));
                } else {
                    curPanel = new JPanel(new ModifiedClusterFlowLayout(1, 10, 0));
                }
                if (params.getDisplayStyle().equals(CloudDisplayStyles.CLUSTERED_BOXES)) {
                    curPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(10, 10, 10, 10)));
                }
            }
            curPanel.add(curLabel);
            clusters.put(clusterNum, curPanel);
            ++count;
        }
        TreeSet sortedSet = new TreeSet(clusters.keySet());
        for (Integer clusterNum : sortedSet) {
            curPanel = (JPanel)clusters.get(clusterNum);
            if (curPanel.equals(this.tagCloudFlowPanel)) continue;
            this.tagCloudFlowPanel.add(curPanel);
        }
        this.tagCloudFlowPanel.revalidate();
        this.revalidate();
        this.updateUI();
        this.repaint();
    }

    public JPanel getTagCloudFlowPanel() {
        return this.tagCloudFlowPanel;
    }

    public void setTagCloudFlowPanel(JPanel aPanel) {
        this.tagCloudFlowPanel = aPanel;
    }

    public CloudParameters getCloudParameters() {
        return this.curCloud;
    }

    public void setCloudParameters(CloudParameters params) {
        this.curCloud = params;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "WordCloud Display";
    }
}

