/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.EditCloudNameDialog;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.cytoscape.application.swing.AbstractCyAction;

public class CloudListMouseListener
extends MouseAdapter {
    private JComponent parent;
    private SemanticSummaryManager cloudManager;

    public CloudListMouseListener(JComponent parent, SemanticSummaryManager cloudManager) {
        this.parent = parent;
        this.cloudManager = cloudManager;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.rightClickList(e);
        } else {
            this.leftClickList(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.rightClickList(e);
        } else {
            this.leftClickList(e);
        }
    }

    private void rightClickList(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)((Object)new ChangeCloudNameAction(this.parent)));
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void leftClickList(MouseEvent e) {
        int clickIndex;
        Point selPoint = new Point(e.getX(), e.getY());
        JList cloudList = this.cloudManager.getInputWindow().getCloudList();
        int selIndex = cloudList.getSelectedIndex();
        if (selIndex == (clickIndex = cloudList.locationToIndex(selPoint))) {
            cloudList.clearSelection();
            cloudList.setSelectedIndex(selIndex);
        }
    }

    public class ChangeCloudNameAction
    extends AbstractCyAction {
        private static final long serialVersionUID = 3741354852598317680L;
        private JComponent parent;

        public ChangeCloudNameAction(JComponent parent) {
            super("Edit Cloud Name");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent ae) {
            String newName;
            String curName;
            DefaultListModel listValues;
            int index;
            JList cloudList;
            block3: {
                cloudList = CloudListMouseListener.this.cloudManager.getInputWindow().getCloudList();
                index = cloudList.getSelectedIndex();
                if (index == -1) {
                    JOptionPane.showMessageDialog(this.parent, "You must fist select a Cloud.");
                    return;
                }
                listValues = CloudListMouseListener.this.cloudManager.getInputWindow().getListValues();
                curName = (String)listValues.get(index);
                newName = "";
                int value = 1;
                Object[] options = new Object[]{"Try Again", "Cancel"};
                do {
                    EditCloudNameDialog theDialog = new EditCloudNameDialog(this.parent, true, curName);
                    theDialog.setLocationRelativeTo(this.parent);
                    theDialog.setVisible(true);
                    newName = theDialog.getNewCloudName();
                    if (curName.equals(newName)) break block3;
                    if (newName == null || newName.trim().equals("")) {
                        newName = curName;
                        break block3;
                    }
                    if (!this.isCloudNameTaken(newName)) break block3;
                } while ((value = JOptionPane.showOptionDialog(this.parent, "That cloud name already exists, try again.", "Duplicate Cloud Name", 2, 1, null, options, options[0])) != 1);
                newName = curName;
            }
            CloudParameters cloudParams = CloudListMouseListener.this.cloudManager.getCurCloud();
            SemanticSummaryParameters networkParams = CloudListMouseListener.this.cloudManager.getCurNetwork();
            networkParams.getClouds().remove(curName);
            cloudParams.setCloudName(newName);
            networkParams.addCloud(newName, cloudParams);
            listValues.setElementAt(newName, index);
            cloudList.updateUI();
        }

        public boolean isCloudNameTaken(String name) {
            return CloudListMouseListener.this.cloudManager.getCurNetwork().containsCloud(name);
        }
    }
}

