/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryPluginAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;

public class CloudListSelectionHandler
implements ListSelectionListener {
    private Component parent;
    private SemanticSummaryManager cloudManager;
    private SemanticSummaryPluginAction pluginAction;
    private CyNetworkViewManager viewManager;

    public CloudListSelectionHandler(Component parent, SemanticSummaryManager cloudManager, SemanticSummaryPluginAction pluginAction, CyNetworkViewManager viewManager) {
        this.parent = parent;
        this.cloudManager = cloudManager;
        this.pluginAction = pluginAction;
        this.viewManager = viewManager;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.getValueIsAdjusting()) {
            return;
        }
        int index = lsm.getMinSelectionIndex();
        if (lsm.isSelectedIndex(index)) {
            SemanticSummaryInputPanel inputPanel = this.cloudManager.getInputWindow();
            String cloudName = (String)inputPanel.getListValues().elementAt(index);
            SemanticSummaryParameters params = this.cloudManager.getCurNetwork();
            if (!params.containsCloud(cloudName)) {
                String message = "Warning - Cloud no longer exists.";
                JOptionPane.showMessageDialog(this.parent, message);
                return;
            }
            CloudParameters cloudParams = params.getCloud(cloudName);
            inputPanel.loadCurrentCloud(cloudParams);
            this.cloudManager.getCloudWindow().updateCloudDisplay(cloudParams);
            CyNetwork network = params.getNetwork();
            if (network == null) {
                return;
            }
            Set<CyNode> selNodes = cloudParams.getSelectedNodes();
            SelectionUtils.setColumns(network.getDefaultNodeTable(), "selected", Boolean.FALSE);
            SelectionUtils.setColumns(network.getDefaultEdgeTable(), "selected", Boolean.FALSE);
            SelectionUtils.setColumns(network, selNodes, "selected", Boolean.TRUE);
            for (CyNetworkView networkView : this.viewManager.getNetworkViews(network)) {
                networkView.updateView();
            }
            this.pluginAction.loadCloudPanel();
        }
    }
}

