/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JLabel;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryPluginAction;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CloudWordInfo
implements Comparable<CloudWordInfo> {
    private String word;
    private Integer fontSize;
    private CloudParameters params;
    private Color textColor;
    private Integer cluster;
    private Integer wordNum;
    private static final String FIRSTDELIMITER = "TabbedEquivalent";
    private static final String SECONDDELIMITER = "NewLineEquivalent";

    public CloudWordInfo() {
        this.fontSize = 0;
        this.textColor = Color.BLACK;
        this.cluster = 0;
        this.wordNum = 0;
    }

    public CloudWordInfo(String aWord, Integer size) {
        this.word = aWord;
        this.fontSize = size;
        this.textColor = Color.BLACK;
        this.cluster = 0;
        this.wordNum = 0;
    }

    public CloudWordInfo(String propFile) {
        this();
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(SECONDDELIMITER);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split(FIRSTDELIMITER);
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.word = (String)props.get("Word");
        this.fontSize = new Integer((String)props.get("FontSize"));
        this.cluster = new Integer((String)props.get("Cluster"));
        this.wordNum = new Integer((String)props.get("WordNum"));
        this.textColor = new Color(new Integer((String)props.get("TextColor")), true);
    }

    @Override
    public int compareTo(CloudWordInfo c) {
        Integer first = this.getFontSize();
        Integer second = c.getFontSize();
        int result = second.compareTo(first);
        if (result == 0 && (result = (first = this.getCluster()).compareTo(second = c.getCluster())) == 0 && (result = (first = this.getWordNumber()).compareTo(second = c.getWordNumber())) == 0) {
            String firstString = this.getWord();
            String secondString = c.getWord();
            result = firstString.compareTo(secondString);
        }
        return result;
    }

    public JLabel createCloudLabel(CyApplicationManager applicationManager, final SemanticSummaryManager cloudManager, final SemanticSummaryPluginAction pluginAction) {
        JLabel label = new JLabel(this.getWord());
        label.setFont(new Font("sansserif", 1, this.getFontSize()));
        label.setForeground(this.textColor);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                String word = clickedLabel.getText();
                CloudParameters cloudParams = cloudManager.getCurCloud();
                Set<CyNode> nodes = cloudParams.getStringNodeMapping().get(word);
                CyNetwork network = cloudParams.getNetworkParams().getNetwork();
                if (network == null) {
                    return;
                }
                SelectionUtils.setColumns(network.getDefaultNodeTable(), "selected", Boolean.FALSE);
                SelectionUtils.setColumns(network.getDefaultEdgeTable(), "selected", Boolean.FALSE);
                SelectionUtils.setColumns(network, nodes, "selected", Boolean.TRUE);
                pluginAction.loadCloudPanel();
                pluginAction.loadInputPanel();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                clickedLabel.setForeground(new Color(0, 200, 255));
                clickedLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                clickedLabel.setForeground(CloudWordInfo.this.textColor);
                clickedLabel.repaint();
            }
        });
        return label;
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("WordTabbedEquivalent" + this.word + SECONDDELIMITER);
        paramVariables.append("FontSizeTabbedEquivalent" + this.fontSize + SECONDDELIMITER);
        paramVariables.append("ClusterTabbedEquivalent" + this.cluster + SECONDDELIMITER);
        paramVariables.append("WordNumTabbedEquivalent" + this.wordNum + SECONDDELIMITER);
        paramVariables.append("TextColorTabbedEquivalent" + this.textColor.getRGB() + SECONDDELIMITER);
        return paramVariables.toString();
    }

    public String[] toSplitString() {
        String[] splitString = new String[]{this.word, Integer.toString(this.fontSize), Integer.toString(this.cluster), Integer.toString(this.wordNum)};
        return splitString;
    }

    public void setWord(String aWord) {
        this.word = aWord;
    }

    public String getWord() {
        return this.word;
    }

    public void setFontSize(Integer size) {
        this.fontSize = size;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setCloudParameters(CloudParameters curParams) {
        this.params = curParams;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color col) {
        this.textColor = col;
    }

    public Integer getCluster() {
        return this.cluster;
    }

    public void setCluster(Integer clusterNum) {
        this.cluster = clusterNum;
    }

    public Integer getWordNumber() {
        return this.wordNum;
    }

    public void setWordNumber(Integer num) {
        this.wordNum = num;
    }
}

