/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.WordPair;

public class ClusterPriorityQueue {
    private ArrayList<WordPair> queue = new ArrayList();
    private CloudParameters params = new CloudParameters(null);
    private boolean initialized = false;
    private static final char controlChar = '\u001f';

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        this.queue = new ArrayList();
        if (!this.params.getRatiosInitialized()) {
            this.params.updateRatios();
        }
        for (Map.Entry<WordPair, Integer> entry : this.params.getSelectedPairCounts().entrySet()) {
            WordPair curPair = entry.getKey();
            curPair.calculateProbability(entry.getValue());
            this.queue.add(curPair);
        }
        Collections.sort(this.queue);
        Collections.reverse(this.queue);
        this.initialized = true;
    }

    public WordPair peak() {
        if (!this.queue.isEmpty()) {
            return this.queue.get(0);
        }
        return null;
    }

    public WordPair remove() {
        WordPair removedPair = !this.queue.isEmpty() ? this.queue.remove(0) : null;
        if (removedPair != null) {
            String firstWord = removedPair.getFirstWord();
            String secondWord = removedPair.getSecondWord();
            Iterator<WordPair> iter = this.queue.iterator();
            while (iter.hasNext()) {
                WordPair curPair = iter.next();
                String curFirst = curPair.getFirstWord();
                String curSecond = curPair.getSecondWord();
                if (!firstWord.equals(curFirst) && !secondWord.equals(curSecond) && (!firstWord.equals(curSecond) || !secondWord.equals(curFirst))) continue;
                iter.remove();
            }
        }
        return removedPair;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public ArrayList<WordPair> getQueue() {
        return this.queue;
    }

    public void setQueue(ArrayList<WordPair> aQueue) {
        this.queue = aQueue;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public void setCloudParameters(CloudParameters cloudParams) {
        this.params = cloudParams;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialialized(boolean val) {
        this.initialized = val;
    }
}

