/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.baderlab.wordcloud.internal.SemanticSummaryPlugin;

public class CollapsiblePanel
extends JPanel {
    CollapsableTitledBorder border;
    Border collapsedBorderLine = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    Border expandedBorderLine = null;
    AbstractButton titleComponent;
    static final int COLLAPSED = 0;
    static final int EXPANDED = 1;
    ImageIcon[] iconArrow = this.createExpandAndCollapseIcon();
    JButton arrow = this.createArrowButton();
    JPanel panel;
    boolean collapsed;

    public CollapsiblePanel(JRadioButton component) {
        component.addItemListener(new ExpandAndCollapseAction());
        this.titleComponent = component;
        this.collapsed = !component.isSelected();
        this.commonConstructor();
    }

    public CollapsiblePanel(String text) {
        this.arrow.setText(text);
        this.titleComponent = this.arrow;
        this.collapsed = true;
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.setLayout(new BorderLayout());
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "Center");
        this.add((Component)this.panel, "Center");
        this.setCollapsed(this.collapsed);
        this.placeTitleComponent();
    }

    private void placeTitleComponent() {
        Insets insets = this.getInsets();
        Rectangle containerRectangle = this.getBounds();
        Rectangle componentRectangle = this.border.getComponentRect(containerRectangle, insets);
        this.titleComponent.setBounds(componentRectangle);
    }

    public void setTitleComponentText(String text) {
        if (this.titleComponent instanceof JButton) {
            this.titleComponent.setText(text);
        }
        this.placeTitleComponent();
    }

    public JPanel getContentPane() {
        return this.panel;
    }

    public void setCollapsed(boolean collapse) {
        if (collapse) {
            this.remove(this.panel);
            this.arrow.setIcon(this.iconArrow[0]);
            this.border = new CollapsableTitledBorder(this.collapsedBorderLine, this.titleComponent);
        } else {
            this.add((Component)this.panel, "North");
            this.arrow.setIcon(this.iconArrow[1]);
            this.border = new CollapsableTitledBorder(this.expandedBorderLine, this.titleComponent);
        }
        this.setBorder(this.border);
        this.collapsed = collapse;
        this.updateUI();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private ImageIcon[] createExpandAndCollapseIcon() {
        ImageIcon[] iconArrow = new ImageIcon[2];
        URL iconURL = SemanticSummaryPlugin.class.getResource("arrow_collapsed.gif");
        if (iconURL != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        if ((iconURL = SemanticSummaryPlugin.class.getResource("arrow_expanded.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    private JButton createArrowButton() {
        JButton button = new JButton("arrow", this.iconArrow[0]);
        button.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(2);
        button.setMargin(new Insets(0, 0, 3, 0));
        Font font = BorderFactory.createTitledBorder("Sample").getTitleFont();
        Color color = BorderFactory.createTitledBorder("Sample").getTitleColor();
        button.setFont(font);
        button.setForeground(color);
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        button.addActionListener(new ExpandAndCollapseAction());
        return button;
    }

    public AbstractButton getTitleComponent() {
        return this.titleComponent;
    }

    private class CollapsableTitledBorder
    extends TitledBorder {
        JComponent component;

        public CollapsableTitledBorder(JComponent component) {
            this(null, component, 1, 2);
        }

        public CollapsableTitledBorder(Border border) {
            this(border, null, 1, 2);
        }

        public CollapsableTitledBorder(Border border, JComponent component) {
            this(border, component, 1, 2);
        }

        public CollapsableTitledBorder(Border border, JComponent component, int titleJustification, int titlePosition) {
            super(border, null, titleJustification, titlePosition, null, null);
            this.component = component;
            if (border == null) {
                this.border = super.getBorder();
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderR = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            Rectangle rect = new Rectangle(x, y, width, height);
            Insets insets = this.getBorderInsets(c);
            Rectangle compR = this.getComponentRect(rect, insets);
            switch (this.titlePosition) {
                case 1: {
                    int diff = compR.height + 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 0: 
                case 2: {
                    int diff = insets.top / 2 - borderInsets.top - 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                    borderR.height -= diff;
                    break;
                }
                case 6: {
                    int diff = compR.height + 2;
                    borderR.height -= diff;
                }
            }
            this.border.paintBorder(c, g, borderR.x, borderR.y, borderR.width, borderR.height);
            Color col = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(compR.x, compR.y, compR.width, compR.height);
            g.setColor(col);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            insets.top = 4 + borderInsets.top;
            insets.right = 4 + borderInsets.right;
            insets.bottom = 4 + borderInsets.bottom;
            insets.left = 4 + borderInsets.left;
            if (c == null || this.component == null) {
                return insets;
            }
            int compHeight = this.component.getPreferredSize().height;
            switch (this.titlePosition) {
                case 1: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 0: 
                case 2: {
                    insets.top += Math.max(compHeight, borderInsets.top) - borderInsets.top;
                    break;
                }
                case 3: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 4: {
                    insets.bottom += compHeight + 2;
                    break;
                }
                case 5: {
                    insets.bottom += Math.max(compHeight, borderInsets.bottom) - borderInsets.bottom;
                    break;
                }
                case 6: {
                    insets.bottom += compHeight + 2;
                }
            }
            return insets;
        }

        public JComponent getTitleComponent() {
            return this.component;
        }

        public void setTitleComponent(JComponent component) {
            this.component = component;
        }

        public Rectangle getComponentRect(Rectangle rect, Insets borderInsets) {
            Dimension compD = this.component.getPreferredSize();
            Rectangle compR = new Rectangle(0, 0, compD.width, compD.height);
            switch (this.titlePosition) {
                case 1: {
                    compR.y = 2;
                    break;
                }
                case 0: 
                case 2: {
                    if (CollapsiblePanel.this.titleComponent instanceof JButton) {
                        compR.y = 2 + (borderInsets.top - 2 - 2 - compD.height) / 2;
                        break;
                    }
                    if (!(CollapsiblePanel.this.titleComponent instanceof JRadioButton)) break;
                    compR.y = (borderInsets.top - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 3: {
                    compR.y = borderInsets.top - compD.height - 2;
                    break;
                }
                case 4: {
                    compR.y = rect.height - borderInsets.bottom + 2;
                    break;
                }
                case 5: {
                    compR.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 6: {
                    compR.y = rect.height - compD.height - 2;
                }
            }
            switch (this.titleJustification) {
                case 0: 
                case 1: {
                    compR.x = 5 + borderInsets.left - 2;
                    break;
                }
                case 3: {
                    compR.x = rect.width - borderInsets.right - 5 - compR.width;
                    break;
                }
                case 2: {
                    compR.x = (rect.width - compR.width) / 2;
                }
            }
            return compR;
        }
    }

    private class ExpandAndCollapseAction
    extends AbstractAction
    implements ActionListener,
    ItemListener {
        private ExpandAndCollapseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CollapsiblePanel.this.setCollapsed(!CollapsiblePanel.this.isCollapsed());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CollapsiblePanel.this.setCollapsed(!CollapsiblePanel.this.isCollapsed());
        }
    }
}

