/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JOptionPane;
import org.baderlab.wordcloud.internal.AbstractSemanticSummaryAction;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryParametersFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CreateCloudAction
extends AbstractSemanticSummaryAction {
    private static final long serialVersionUID = 1103296239269358444L;
    private CyApplicationManager applicationManager;
    private CySwingApplication application;
    private SemanticSummaryManager cloudManager;
    private SemanticSummaryParametersFactory parametersFactory;

    public CreateCloudAction(CyApplicationManager applicationManager, CySwingApplication application, SemanticSummaryManager cloudManager, SemanticSummaryParametersFactory parametersFactory) {
        super("Create Cloud");
        this.applicationManager = applicationManager;
        this.application = application;
        this.cloudManager = cloudManager;
        this.parametersFactory = parametersFactory;
    }

    public void actionPerformed(ActionEvent ae) {
        SemanticSummaryParameters params;
        this.pluginAction.actionPerformed(ae);
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        if (!SelectionUtils.hasSelectedNodes(network)) {
            JOptionPane.showMessageDialog(this.application.getJFrame(), "Please select one or more nodes.");
            return;
        }
        if (this.cloudManager.isSemanticSummary(network)) {
            params = this.cloudManager.getParameters(network);
            if (params.networkHasChanged(network)) {
                // empty if block
            }
            params.updateParameters(network);
        } else {
            params = this.parametersFactory.createSemanticSummaryParameters();
            params.updateParameters(network);
            this.cloudManager.registerNetwork(network, params);
        }
        CloudParameters cloudParams = new CloudParameters(params);
        cloudParams.setCloudNum(params.getCloudCount());
        cloudParams.setCloudName(params.getNextCloudName());
        Set<CyNode> nodes = SelectionUtils.getSelectedNodes(network);
        cloudParams.setSelectedNodes(nodes);
        params.addCloud(cloudParams.getCloudName(), cloudParams);
        SemanticSummaryInputPanel inputPanel = this.cloudManager.getInputWindow();
        inputPanel.setAttributeNames(this.cloudManager.getColumnNames(network, CyNode.class));
        cloudParams.retrieveInputVals(inputPanel);
        cloudParams.updateRatios();
        cloudParams.calculateFontSizes();
        CloudDisplayPanel cloudPanel = this.cloudManager.getCloudWindow();
        cloudPanel.updateCloudDisplay(cloudParams);
        inputPanel.addNewCloud(cloudParams);
        inputPanel.getCreateNetworkButton().setEnabled(true);
        inputPanel.getSaveCloudButton().setEnabled(true);
        inputPanel.refreshNetworkSettings();
        inputPanel.getAddWordTextField().setEditable(true);
        inputPanel.getAddWordButton().setEnabled(true);
    }
}

