/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.baderlab.wordcloud.internal.AbstractSemanticSummaryAction;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.CloudWordInfo;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryParametersFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class CreateCloudCommandAction
extends AbstractSemanticSummaryAction {
    private static final long serialVersionUID = -5065616290485908393L;
    private CyApplicationManager applicationManager;
    private SemanticSummaryManager cloudManager;
    private SemanticSummaryParametersFactory parametersFactory;
    private String nameColumnName;
    private List<CloudWordInfo> wordInfo;
    private String cloudName;
    private CyTable clusterTable;
    private Set<CyNode> nodes;

    public CreateCloudCommandAction(CyApplicationManager applicationManager, CySwingApplication application, SemanticSummaryManager cloudManager, SemanticSummaryParametersFactory parametersFactory) {
        super("Create Cloud");
        this.applicationManager = applicationManager;
        this.cloudManager = cloudManager;
        this.parametersFactory = parametersFactory;
    }

    public void setAttributeColumn(String columnName) {
        this.nameColumnName = columnName;
    }

    public void setCloudName(String cloudName) {
        this.cloudName = cloudName;
    }

    public void setClusterTable(CyTable clusterTable) {
        this.clusterTable = clusterTable;
    }

    public List<CloudWordInfo> getWordInfo() {
        return this.wordInfo;
    }

    public void setNodes(Set<CyNode> nodes) {
        this.nodes = nodes;
    }

    public void actionPerformed(ActionEvent ae) {
        SemanticSummaryParameters params;
        this.pluginAction.actionPerformed(ae);
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        if (this.cloudManager.isSemanticSummary(network)) {
            params = this.cloudManager.getParameters(network);
            if (params.networkHasChanged(network)) {
                params.updateParameters(network);
            }
        } else {
            params = this.parametersFactory.createSemanticSummaryParameters();
            params.updateParameters(network);
            this.cloudManager.registerNetwork(network, params);
        }
        CloudParameters cloudParams = new CloudParameters(params);
        cloudParams.setCloudNum(params.getCloudCount());
        cloudParams.setClusterTable(this.clusterTable);
        cloudParams.setCloudName(this.cloudName);
        cloudParams.setSelectedNodes(this.nodes);
        params.addCloud(cloudParams.getCloudName(), cloudParams);
        SemanticSummaryInputPanel inputPanel = this.cloudManager.getInputWindow();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.nameColumnName);
        inputPanel.setAttributeNames(attributes);
        cloudParams.retrieveInputVals(inputPanel);
        cloudParams.updateRatios();
        cloudParams.calculateFontSizes();
        CloudDisplayPanel cloudPanel = this.cloudManager.getCloudWindow();
        cloudPanel.updateCloudDisplay(cloudParams);
        inputPanel.addNewCloud(cloudParams);
        inputPanel.getCreateNetworkButton().setEnabled(true);
        inputPanel.getSaveCloudButton().setEnabled(true);
        inputPanel.refreshNetworkSettings();
        inputPanel.getAddWordTextField().setEditable(true);
        inputPanel.getAddWordButton().setEnabled(true);
        this.wordInfo = cloudParams.getCloudWordInfoList();
        ArrayList<String> WC_Word = new ArrayList<String>();
        ArrayList<String> WC_FontSize = new ArrayList<String>();
        ArrayList<String> WC_Cluster = new ArrayList<String>();
        ArrayList<String> WC_Number = new ArrayList<String>();
        for (CloudWordInfo cloudWord : this.wordInfo) {
            String[] wordInfo = cloudWord.toSplitString();
            WC_Word.add(wordInfo[0]);
            WC_FontSize.add(wordInfo[1]);
            WC_Cluster.add(wordInfo[2]);
            WC_Number.add(wordInfo[3]);
        }
        CyRow clusterRow = this.clusterTable.getRow((Object)this.cloudName);
        clusterRow.set("WC_Word", WC_Word);
        clusterRow.set("WC_FontSize", WC_FontSize);
        clusterRow.set("WC_Cluster", WC_Cluster);
        clusterRow.set("WC_Number", WC_Number);
    }
}

