/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.ModelManager;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.WordPair;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;

public class CreateCloudNetworkAction
extends AbstractCyAction {
    private static final long serialVersionUID = 2683655996962050569L;
    public static String WORD_VAL = "Word_Prob";
    public static String CO_VAL = "CO_Prob";
    public static String INTERACTION_TYPE = "CO";
    private static final char controlChar = '\u001f';
    private final ModelManager modelManager;
    private SemanticSummaryManager cloudManager;

    public CreateCloudNetworkAction(ModelManager modelManager, SemanticSummaryManager cloudManager) {
        super("Create Cloud Network");
        this.modelManager = modelManager;
        this.cloudManager = cloudManager;
    }

    public void actionPerformed(ActionEvent ae) {
        CloudParameters curCloud = this.cloudManager.getCurCloud();
        Map<String, Double> ratios = curCloud.getRatios();
        Map<WordPair, Double> pairRatios = curCloud.getPairRatios();
        String newNetworkName = curCloud.getNextNetworkName();
        CyNetwork network = this.modelManager.createNetwork(newNetworkName);
        CyTable nodeTable = network.getDefaultNodeTable();
        nodeTable.createColumn(WORD_VAL, Double.class, false);
        CyTable edgeTable = network.getDefaultEdgeTable();
        edgeTable.createColumn(CO_VAL, Double.class, false);
        HashMap<String, CyNode> wordNodes = new HashMap<String, CyNode>();
        for (Map.Entry<String, Double> entry : ratios.entrySet()) {
            String curWord = entry.getKey();
            CyNode node = network.addNode();
            CyRow row = network.getRow((CyIdentifiable)node);
            row.set("name", (Object)curWord);
            Double nodeRatio = entry.getValue();
            row.set(WORD_VAL, (Object)nodeRatio);
            wordNodes.put(curWord, node);
        }
        for (Map.Entry<Object, Double> entry : pairRatios.entrySet()) {
            WordPair pair = (WordPair)entry.getKey();
            Double edgeRatio = entry.getValue();
            String nodeName1 = pair.getFirstWord();
            String nodeName2 = pair.getSecondWord();
            CyNode node1 = (CyNode)wordNodes.get(nodeName1);
            CyNode node2 = (CyNode)wordNodes.get(nodeName2);
            Double node1Ratio = ratios.get(nodeName1);
            Double node2Ratio = ratios.get(nodeName2);
            Double conditionalRatio = edgeRatio / (node1Ratio * node2Ratio);
            if (!(conditionalRatio > 1.0)) continue;
            CyEdge edge = network.addEdge(node1, node2, false);
            CyRow row = network.getRow((CyIdentifiable)edge);
            row.set(CO_VAL, (Object)conditionalRatio);
        }
        CyNetworkView view = this.modelManager.createNetworkView(network);
        this.modelManager.registerNetwork(network);
        this.modelManager.registerNetworkView(view);
        this.modelManager.applyVisualStyle(view, curCloud);
        view.updateView();
        this.modelManager.applyPreferredLayout(view);
    }
}

