/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.baderlab.wordcloud.internal.AbstractSemanticSummaryAction;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.util.swing.FileUtil;

public class SaveCloudAction
extends AbstractSemanticSummaryAction {
    public static String SESSION_EXT = ".png";
    private CySwingApplication application;
    private FileUtil fileUtil;
    private SemanticSummaryManager cloudManager;

    public SaveCloudAction(CySwingApplication application, FileUtil fileUtil, SemanticSummaryManager cloudManager) {
        super("Save Cloud Image");
        this.application = application;
        this.fileUtil = fileUtil;
        this.cloudManager = cloudManager;
    }

    public void actionPerformed(ActionEvent ae) {
        String name;
        try {
            List filters = Collections.emptyList();
            name = this.fileUtil.getFile((Component)this.application.getJFrame(), "Save Current Cloud as PNG File", 1, filters).toString();
        }
        catch (Exception exp) {
            return;
        }
        if (!name.endsWith(SESSION_EXT)) {
            name = name + SESSION_EXT;
        }
        this.saveFile(name);
    }

    private void saveFile(String name) {
        CloudDisplayPanel panel = this.cloudManager.getCloudWindow();
        String cloudName = this.cloudManager.getCurCloud().getCloudName();
        CytoPanel cytoPanel = this.application.getCytoPanel(CytoPanelName.SOUTH);
        Dimension curSize = cytoPanel.getSelectedComponent().getSize();
        JScrollPane scroll = panel.cloudScroll;
        JFrame frame = new JFrame(cloudName);
        int scrollHeight = scroll.getSize().height;
        JPanel flowPanel = panel.getTagCloudFlowPanel();
        int flowHeight = flowPanel.getSize().height;
        int width = curSize.width;
        Dimension fullSize = new Dimension(width, flowHeight += 5);
        scroll.setPreferredSize(fullSize);
        frame.getContentPane().add(scroll);
        scroll.revalidate();
        frame.pack();
        frame.setLocation(-100, -100);
        frame.setVisible(true);
        Dimension imageSize = frame.getSize();
        BufferedImage b = new BufferedImage(imageSize.width, imageSize.height, 1);
        Graphics2D g = b.createGraphics();
        frame.printAll(g);
        try {
            ImageIO.write((RenderedImage)b, "png", new File(name));
        }
        catch (Exception e) {
            // empty catch block
        }
        frame.dispose();
        panel.add((Component)scroll, "Center");
        this.pluginAction.loadCloudPanel();
    }
}

