/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class SelectionUtils {
    public static void setColumns(CyTable table, String columnName, Object value) {
        for (CyRow row : table.getAllRows()) {
            row.set(columnName, value);
        }
    }

    public static void setColumns(CyNetwork network, Collection<? extends CyIdentifiable> entities, String columnName, Object value) {
        for (CyIdentifiable cyIdentifiable : entities) {
            CyRow row = network.getRow(cyIdentifiable);
            if (row == null) continue;
            row.set(columnName, value);
        }
    }

    public static boolean hasSelectedNodes(CyNetwork network) {
        for (CyRow row : network.getDefaultNodeTable().getAllRows()) {
            Boolean selected = (Boolean)row.get("selected", Boolean.class);
            Long suid = (Long)row.get("SUID", Long.class);
            if (selected == null || !selected.booleanValue() || network.getNode(suid.longValue()) == null) continue;
            return true;
        }
        return false;
    }

    public static Set<CyNode> getSelectedNodes(CyNetwork network) {
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyRow row : network.getDefaultNodeTable().getAllRows()) {
            Boolean selected = (Boolean)row.get("selected", Boolean.class);
            Long suid = (Long)row.get("SUID", Long.class);
            CyNode node = network.getNode(suid.longValue());
            if (selected == null || !selected.booleanValue() || node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

