/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.IoUtil;
import org.baderlab.wordcloud.internal.ModelManager;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryParametersFactory;
import org.baderlab.wordcloud.internal.SemanticSummaryPluginAction;
import org.baderlab.wordcloud.internal.WordDelimiters;
import org.baderlab.wordcloud.internal.WordFilter;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSummaryPlugin
implements SessionAboutToBeSavedListener,
SessionLoadedListener,
SessionAboutToBeLoadedListener {
    private static final String netNameSep = "SemanticSummaryNetworkSeparator";
    private static final String cloudNameSep = "SemanticSummaryCloudSeparator";
    private final Logger logger = LoggerFactory.getLogger(SemanticSummaryPlugin.class);
    private SemanticSummaryPluginAction pluginAction;
    private SemanticSummaryManager cloudManager;
    private SemanticSummaryParametersFactory parametersFactory;
    private ModelManager modelManager;
    private IoUtil ioUtil;
    private CyApplicationManager applicationManager;
    private CySwingApplication application;

    public SemanticSummaryPlugin(SemanticSummaryPluginAction pluginAction, SemanticSummaryManager cloudManager, SemanticSummaryParametersFactory parametersFactory, ModelManager modelManager, IoUtil ioUtil, CyApplicationManager applicationManager, CySwingApplication application) {
        this.pluginAction = pluginAction;
        this.cloudManager = cloudManager;
        this.parametersFactory = parametersFactory;
        this.modelManager = modelManager;
        this.ioUtil = ioUtil;
        this.applicationManager = applicationManager;
        this.application = application;
    }

    public String describe() {
        StringBuffer sb = new StringBuffer();
        sb.append("For every node in the current network, this plugin ");
        sb.append("displays a word cloud of the selected ");
        sb.append("cyNode attribute.  The node ID is the defuault ");
        sb.append("attribute.");
        return sb.toString();
    }

    public void handleEvent(SessionAboutToBeLoadedEvent event) {
        this.cloudManager.reset();
        this.cloudManager.setupCurrentNetwork(null);
    }

    public void handleEvent(SessionAboutToBeSavedEvent event) {
        ArrayList<File> files = new ArrayList<File>();
        this.saveSessionStateFiles(files);
        try {
            event.addAppFiles("ca.baderlab.WordCloud", files);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while loading WordCloud app state", (Throwable)e);
        }
    }

    public void handleEvent(SessionLoadedEvent event) {
        List files = (List)event.getLoadedSession().getAppFileListMap().get("ca.baderlab.WordCloud");
        if (files == null) {
            return;
        }
        this.restoreSessionState(files);
        this.cloudManager.setupCurrentNetwork(this.applicationManager.getCurrentNetwork());
    }

    public void saveSessionStateFiles(List<File> pFileList) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        Map<CyNetwork, SemanticSummaryParameters> networks = this.cloudManager.getCyNetworkList();
        for (Map.Entry<CyNetwork, SemanticSummaryParameters> entry : networks.entrySet()) {
            CyNetwork network;
            SemanticSummaryParameters params = entry.getValue();
            if (params.networkHasChanged(network = entry.getKey())) {
                // empty if block
            }
            params.updateParameters(network);
            try {
                int uid = (Integer)network.getRow((CyIdentifiable)network).get("Cloud Network UID", Integer.class);
                File current_filter = new File(tmpDir, netNameSep + uid + netNameSep + ".FILTER.txt");
                BufferedWriter filterWriter = new BufferedWriter(new FileWriter(current_filter));
                filterWriter.write(params.getFilter().toString());
                filterWriter.close();
                pFileList.add(current_filter);
                File current_delimiter = new File(tmpDir, netNameSep + uid + netNameSep + ".DELIMITER.txt");
                BufferedWriter delimiterWriter = new BufferedWriter(new FileWriter(current_delimiter));
                delimiterWriter.write(params.getDelimiter().toString());
                delimiterWriter.close();
                pFileList.add(current_delimiter);
                if (params.getClouds().isEmpty()) continue;
                Map<String, CloudParameters> all_clouds = params.getClouds();
                Iterator<String> j = all_clouds.keySet().iterator();
                while (j.hasNext()) {
                    String cloud_name = j.next().toString();
                    CloudParameters cloud = all_clouds.get(cloud_name);
                    File current_cloud = new File(tmpDir, netNameSep + uid + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".CLOUDS.txt");
                    BufferedWriter subCloud1Writer = new BufferedWriter(new FileWriter(current_cloud));
                    subCloud1Writer.write(cloud.toString());
                    subCloud1Writer.close();
                    pFileList.add(current_cloud);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void restoreSessionState(List<File> pStateFileList) {
        if (pStateFileList == null || pStateFileList.size() == 0) {
            return;
        }
        this.pluginAction.loadInputPanel();
        this.pluginAction.loadCloudPanel();
        try {
            for (CyNetwork network : this.modelManager.getSemanticSummaryNetworks()) {
                SemanticSummaryParameters params = this.parametersFactory.createSemanticSummaryParameters(network);
                this.cloudManager.registerNetwork(network, params);
            }
            for (int i = 0; i < pStateFileList.size(); ++i) {
                SemanticSummaryParameters networkParams;
                CyNetwork network;
                int uid;
                String net_name;
                String[] fullname;
                String fullText;
                File prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains(".CLOUDS.txt")) {
                    fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                    fullname = prop_file.getName().split(netNameSep);
                    net_name = fullname[1];
                    uid = Integer.parseInt(net_name);
                    String[] fullname2 = prop_file.getName().split(cloudNameSep);
                    String cloud_name = fullname2[1];
                    CyNetwork network2 = this.modelManager.getNetwork(uid);
                    SemanticSummaryParameters networkParams2 = this.cloudManager.getCyNetworkList().get(network2);
                    CloudParameters params = new CloudParameters(networkParams2, fullText);
                    networkParams2.addCloud(cloud_name, params);
                }
                if (prop_file.getName().contains(".FILTER.txt")) {
                    fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                    fullname = prop_file.getName().split(netNameSep);
                    net_name = fullname[1];
                    uid = Integer.parseInt(net_name);
                    network = this.modelManager.getNetwork(uid);
                    networkParams = this.cloudManager.getCyNetworkList().get(network);
                    WordFilter curFilter = new WordFilter(fullText);
                    networkParams.setFilter(curFilter);
                }
                if (!prop_file.getName().contains(".DELIMITER.txt")) continue;
                fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                fullname = prop_file.getName().split(netNameSep);
                net_name = fullname[1];
                uid = Integer.parseInt(net_name);
                network = this.modelManager.getNetwork(uid);
                networkParams = this.cloudManager.getCyNetworkList().get(network);
                WordDelimiters curDelimiter = new WordDelimiters(this.application, fullText);
                networkParams.setDelimiter(curDelimiter);
            }
            this.cloudManager.setupCurrentNetwork(this.applicationManager.getCurrentNetwork());
            for (SemanticSummaryParameters parameters : this.cloudManager.getCyNetworkList().values()) {
                for (CloudParameters cloud : parameters.getClouds().values()) {
                    cloud.updateSelectedCounts();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties getPropertiesFromClasspath(String propFileName) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }
}

