/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.Icon;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanelFactory;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.service.util.CyServiceRegistrar;

public class SemanticSummaryPluginAction
extends AbstractCyAction {
    private static final long serialVersionUID = -5407980202304156167L;
    private SemanticSummaryManager cloudManager;
    private CyApplicationManager applicationManager;
    private SemanticSummaryInputPanelFactory inputPanelFactory;
    private CySwingApplication application;
    private CyServiceRegistrar registrar;

    public SemanticSummaryPluginAction(SemanticSummaryManager cloudManager, CyApplicationManager applicationManager, SemanticSummaryInputPanelFactory inputPanelFactory, CySwingApplication application, CyServiceRegistrar registrar) {
        super("Settings");
        this.cloudManager = cloudManager;
        this.applicationManager = applicationManager;
        this.inputPanelFactory = inputPanelFactory;
        this.application = application;
        this.registrar = registrar;
    }

    public void actionPerformed(ActionEvent ae) {
        this.doRealAction();
    }

    public void doRealAction() {
        CloudParameters nullCloud = this.cloudManager.getNullCloudParameters();
        if (nullCloud == null) {
            this.cloudManager.setupNullCloudParams();
        }
        boolean loaded = this.loadInputPanel();
        this.loadCloudPanel();
        if (!loaded) {
            this.cloudManager.setupCurrentNetwork(this.applicationManager.getCurrentNetwork());
        }
    }

    public boolean loadInputPanel() {
        boolean loaded = false;
        CytoPanel cytoPanel = this.application.getCytoPanel(CytoPanelName.WEST);
        SemanticSummaryInputPanel inputWindow = this.cloudManager.getInputWindow();
        if (inputWindow == null) {
            inputWindow = this.inputPanelFactory.createPanel();
            inputWindow.setPreferredSize(new Dimension(450, 300));
            this.cloudManager.setInputWindow(inputWindow);
            CytoPanelComponent panelComponent = this.createCytoPanelComponent("WordCloud", null, CytoPanelName.WEST, inputWindow);
            this.registrar.registerService((Object)panelComponent, CytoPanelComponent.class, new Properties());
            int index = cytoPanel.indexOfComponent((Component)inputWindow);
            cytoPanel.setSelectedIndex(index);
        } else {
            int index = cytoPanel.indexOfComponent((Component)inputWindow);
            cytoPanel.setSelectedIndex(index);
            loaded = true;
        }
        return loaded;
    }

    public void loadCloudPanel() {
        CytoPanel cytoPanel = this.application.getCytoPanel(CytoPanelName.SOUTH);
        CloudDisplayPanel cloudWindow = this.cloudManager.getCloudWindow();
        if (cloudWindow == null) {
            cloudWindow = new CloudDisplayPanel(this.applicationManager, this.cloudManager, this);
            this.cloudManager.setCloudDisplayWindow(cloudWindow);
            CytoPanelComponent panelComponent = this.createCytoPanelComponent("WordCloud Display", null, CytoPanelName.SOUTH, cloudWindow);
            this.registrar.registerService((Object)panelComponent, CytoPanelComponent.class, new Properties());
            int index = cytoPanel.indexOfComponent((Component)cloudWindow);
            cytoPanel.setSelectedIndex(index);
        } else {
            int index = cytoPanel.indexOfComponent((Component)cloudWindow);
            cytoPanel.setSelectedIndex(index);
        }
    }

    CytoPanelComponent createCytoPanelComponent(final String title, final Icon icon, final CytoPanelName position, final Component component) {
        return new CytoPanelComponent(){

            public String getTitle() {
                return title;
            }

            public Icon getIcon() {
                return icon;
            }

            public CytoPanelName getCytoPanelName() {
                return position;
            }

            public Component getComponent() {
                return component;
            }
        };
    }
}

