/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SliderBarPanel;
import org.baderlab.wordcloud.internal.UpdateCloudAction;

public class SliderBarActionListener
implements ChangeListener {
    private SliderBarPanel panel;
    private String attribute;
    private SemanticSummaryManager cloudManager;
    private UpdateCloudAction updateCloudAction;

    public SliderBarActionListener(SliderBarPanel panel, String attrib, SemanticSummaryManager cloudManager, UpdateCloudAction updateCloudAction) {
        this.panel = panel;
        this.cloudManager = cloudManager;
        this.updateCloudAction = updateCloudAction;
        this.attribute = attrib;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        Double value = (double)source.getValue() / this.panel.getPrecision();
        this.panel.setLabel(source.getValue());
        CloudParameters curCloud = this.cloudManager.getCurCloud();
        if (curCloud != this.cloudManager.getNullCloudParameters() && curCloud != null) {
            curCloud.setNetWeightFactor(value);
        }
        this.updateCloudAction.doRealAction();
    }
}

