/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.command;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.baderlab.wordcloud.internal.CreateCloudCommandAction;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParametersFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class CreateWordCloudCommandHandlerTask
implements Task {
    private CyApplicationManager applicationManager;
    private CreateCloudCommandAction createCloudCommandAction;
    private CyTableManager tableManager;
    private CyTableFactory tableFactory;
    @Tunable(description="Column with words")
    public String wordColumnName;
    @Tunable(description="Nodes to use")
    public ListSingleSelection nodesToUse = new ListSingleSelection(new Object[]{"selected", "all"});
    @Tunable(description="Cloud name")
    public String cloudName = "";
    @Tunable(description="Cloud group table name")
    public String cloudGroupTableName = "WordCloud Results Table";

    public CreateWordCloudCommandHandlerTask(CyApplicationManager applicationManager, CySwingApplication application, SemanticSummaryManager cloudManager, CreateCloudCommandAction createCloudCommandAction, SemanticSummaryParametersFactory parametersFactory, CyTableManager tableManager, CyTableFactory tableFactory) {
        this.applicationManager = applicationManager;
        this.createCloudCommandAction = createCloudCommandAction;
        this.tableManager = tableManager;
        this.tableFactory = tableFactory;
    }

    public void cancel() {
    }

    public void run(TaskMonitor arg0) throws Exception {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        Set<CyNode> nodes = null;
        if (this.nodesToUse.getSelectedValue().equals("selected")) {
            nodes = SelectionUtils.getSelectedNodes(network);
        } else if (this.nodesToUse.getSelectedValue().equals("all")) {
            nodes = new HashSet<CyNode>(network.getNodeList());
        }
        CyTable cloudGroupTable = null;
        if (network.getDefaultNetworkTable().getColumn(this.cloudGroupTableName) != null) {
            cloudGroupTable = this.tableManager.getTable(((Long)network.getRow((CyIdentifiable)network).get(this.cloudGroupTableName, Long.class)).longValue());
        } else {
            cloudGroupTable = this.tableFactory.createTable(this.cloudGroupTableName, "Cloud", String.class, true, true);
            this.createColumn(cloudGroupTable, "WC_Word");
            this.createColumn(cloudGroupTable, "WC_FontSize");
            this.createColumn(cloudGroupTable, "WC_Cluster");
            this.createColumn(cloudGroupTable, "WC_Number");
            this.tableManager.addTable(cloudGroupTable);
            network.getDefaultNetworkTable().createColumn(this.cloudGroupTableName, Long.class, false);
            network.getRow((CyIdentifiable)network).set(this.cloudGroupTableName, (Object)cloudGroupTable.getSUID());
        }
        this.createCloudCommandAction.setAttributeColumn(this.wordColumnName);
        this.createCloudCommandAction.setCloudName(this.cloudName);
        this.createCloudCommandAction.setClusterTable(cloudGroupTable);
        this.createCloudCommandAction.setNodes(nodes);
        this.createCloudCommandAction.actionPerformed(new ActionEvent("", 0, ""));
    }

    private void createColumn(CyTable nodeTable, String columnName) {
        CyColumn column = nodeTable.getColumn(columnName);
        if (column != null) {
            nodeTable.deleteColumn(columnName);
        }
        nodeTable.createListColumn(columnName, String.class, false);
    }
}

