/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfo;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.session.CySession;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Comparable<Cluster> {
    private int clusterNumber;
    private String cloudName;
    private CyGroup group;
    private HashMap<CyNode, double[]> nodesToCoordinates;
    private int size;
    private String label;
    private TextAnnotation textAnnotation;
    private ShapeAnnotation ellipse;
    private AnnotationSet parent;
    private boolean selected;
    private ArrayList<WordInfo> wordInfos;
    private HashMap<CyNode, Double> nodesToRadii;
    private HashMap<CyNode, Double> nodesToCentralities;
    private String mostCentralNodeLabel;

    public Cluster() {
        this.wordInfos = new ArrayList();
        this.nodesToCoordinates = new HashMap();
        this.nodesToRadii = new HashMap();
        this.nodesToCentralities = new HashMap();
        this.size = 0;
    }

    public Cluster(int clusterNumber, AnnotationSet parent, CyGroup group) {
        this(clusterNumber, parent);
        this.group = group;
    }

    public Cluster(int clusterNumber, AnnotationSet parent) {
        this.clusterNumber = clusterNumber;
        this.parent = parent;
        this.cloudName = parent.getName() + " Cloud " + clusterNumber;
        this.wordInfos = new ArrayList();
        this.nodesToCoordinates = new HashMap();
        this.nodesToRadii = new HashMap();
        this.nodesToCentralities = new HashMap();
        this.size = 0;
        this.selected = false;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public CyGroup getGroup() {
        return this.group;
    }

    public AnnotationSet getParent() {
        return this.parent;
    }

    public void setParent(AnnotationSet annotationSet) {
        this.parent = annotationSet;
    }

    public boolean isCollapsed() {
        if (this.group != null) {
            return this.group.isCollapsed((CyNetwork)this.parent.getView().getModel());
        }
        return false;
    }

    public CyNode getGroupNode() {
        if (this.group != null) {
            return this.group.getGroupNode();
        }
        return null;
    }

    public HashMap<CyNode, double[]> getNodesToCoordinates() {
        return this.nodesToCoordinates;
    }

    public HashMap<CyNode, Double> getNodesToRadii() {
        return this.nodesToRadii;
    }

    public void addNodeCoordinates(CyNode node, double[] coordinates) {
        if (!this.nodesToCoordinates.containsKey(node)) {
            ++this.size;
            if (this.group != null && this.group.getGroupNode() != node) {
                ArrayList<CyNode> nodeToAdd = new ArrayList<CyNode>();
                nodeToAdd.add(node);
                this.group.addNodes(nodeToAdd);
            }
        }
        this.nodesToCoordinates.put(node, coordinates);
    }

    public void addNodeRadius(CyNode node, double radius) {
        this.nodesToRadii.put(node, radius);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setGroup(CyGroup group) {
        this.group = group;
    }

    public int getSize() {
        return this.size;
    }

    public ShapeAnnotation getEllipse() {
        return this.ellipse;
    }

    public void setEllipse(ShapeAnnotation ellipse) {
        this.ellipse = ellipse;
    }

    public TextAnnotation getTextAnnotation() {
        return this.textAnnotation;
    }

    public void setTextAnnotation(TextAnnotation textAnnotation) {
        this.textAnnotation = textAnnotation;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void erase() {
        this.eraseText();
        this.eraseEllipse();
    }

    public void eraseText() {
        this.textAnnotation.removeAnnotation();
    }

    public void eraseEllipse() {
        this.ellipse.removeAnnotation();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public ArrayList<WordInfo> getWordInfos() {
        return this.wordInfos;
    }

    public void setWordInfos(ArrayList<WordInfo> wordInfos) {
        this.wordInfos = wordInfos;
    }

    public void setNodesToCentralities(HashMap<CyNode, Double> nodesToCentralities) {
        this.nodesToCentralities = nodesToCentralities;
    }

    public HashMap<CyNode, Double> getNodesToCentralities() {
        return this.nodesToCentralities;
    }

    public String getMostCentralNodeLabel() {
        if (this.mostCentralNodeLabel == null) {
            CyNode maxNode = this.nodesToCoordinates.keySet().iterator().next();
            double maxCentrality = -1.0;
            for (CyNode node : this.nodesToCentralities.keySet()) {
                double centrality = this.nodesToCentralities.get(node);
                if (!(centrality > maxCentrality)) continue;
                maxNode = node;
                maxCentrality = centrality;
            }
            this.mostCentralNodeLabel = (String)((CyNetwork)this.parent.getView().getModel()).getRow((CyIdentifiable)maxNode).get(this.parent.getNameColumnName(), String.class);
        }
        return this.mostCentralNodeLabel;
    }

    public void removeGroup() {
        this.group = null;
    }

    @Override
    public int compareTo(Cluster cluster2) {
        return this.label.compareTo(cluster2.getLabel());
    }

    public Set<CyNode> getNodes() {
        return this.nodesToCoordinates.keySet();
    }

    public void removeNode(CyNode nodeToRemove) {
        if (this.nodesToCoordinates.containsKey(nodeToRemove)) {
            this.nodesToCoordinates.remove(nodeToRemove);
            this.nodesToRadii.remove(nodeToRemove);
            ArrayList<CyNode> node = new ArrayList<CyNode>();
            node.add(nodeToRemove);
            if (this.group != null) {
                this.group.removeNodes(node);
            }
            --this.size;
        }
    }

    public void swallow(Cluster cluster2) {
        HashMap<CyNode, double[]> cluster2NodesToCoordinates = cluster2.getNodesToCoordinates();
        HashMap<CyNode, Double> cluster2NodesToRadii = cluster2.getNodesToRadii();
        for (CyNode cyNode : cluster2NodesToCoordinates.keySet()) {
            this.addNodeCoordinates(cyNode, cluster2NodesToCoordinates.get(cyNode));
            this.addNodeRadius(cyNode, cluster2NodesToRadii.get(cyNode));
        }
        for (Map.Entry entry : cluster2.getNodesToCoordinates().entrySet()) {
            this.addNodeCoordinates((CyNode)entry.getKey(), (double[])entry.getValue());
        }
        cluster2.getParent().getClusterMap().remove(cluster2.getClusterNumber());
    }

    public String toSessionString() {
        String sessionString = "";
        sessionString = sessionString + this.clusterNumber + "\n";
        sessionString = sessionString + this.label + "\n";
        sessionString = sessionString + this.selected + "\n";
        Map ellipseArgs = this.ellipse.getArgMap();
        for (String property : ellipseArgs.keySet()) {
            sessionString = sessionString + property + "\t" + (String)ellipseArgs.get(property) + "\n";
        }
        sessionString = sessionString + "Text Annotations\n";
        Map textArgs = this.textAnnotation.getArgMap();
        for (String property : textArgs.keySet()) {
            sessionString = sessionString + property + "\t" + (String)textArgs.get(property) + "\n";
        }
        sessionString = sessionString + "End of annotations\n";
        for (CyNode node : this.nodesToCoordinates.keySet()) {
            long nodeID = node.getSUID();
            double[] coordinates = this.nodesToCoordinates.get(node);
            double nodeX = coordinates[0];
            double nodeY = coordinates[1];
            double nodeRadius = this.nodesToRadii.get(node);
            double nodeCentrality = this.nodesToCentralities.get(node);
            sessionString = sessionString + nodeID + "\t" + nodeX + "\t" + nodeY + "\t" + nodeRadius + "\t" + nodeCentrality + "\n";
        }
        sessionString = sessionString + "End of nodes\n";
        sessionString = sessionString + "End of cluster\n";
        if (this.group != null) {
            if (this.group.isCollapsed((CyNetwork)this.parent.getView().getModel())) {
                this.group.expand((CyNetwork)this.parent.getView().getModel());
            }
            this.group.removeGroupFromNetwork((CyNetwork)this.parent.getView().getModel());
            AutoAnnotationManager.getInstance().getGroupManager().destroyGroup(this.group);
        }
        return sessionString;
    }

    public void load(ArrayList<String> text, CySession session) {
        String[] splitLine;
        this.clusterNumber = Integer.valueOf(text.get(0));
        this.cloudName = this.parent.getName() + " Cloud " + this.clusterNumber;
        this.label = text.get(1);
        this.selected = Boolean.valueOf(text.get(2));
        int lineNumber = 3;
        String line = text.get(lineNumber);
        HashMap<String, String> ellipseMap = new HashMap<String, String>();
        while (!line.equals("Text Annotations")) {
            String[] splitLine2 = line.split("\t");
            ellipseMap.put(splitLine2[0], splitLine2[1]);
            line = text.get(++lineNumber);
        }
        this.ellipse = (ShapeAnnotation)AutoAnnotationManager.getInstance().getShapeFactory().createAnnotation(ShapeAnnotation.class, this.parent.getView(), ellipseMap);
        line = text.get(++lineNumber);
        HashMap<String, String> textMap = new HashMap<String, String>();
        while (!line.equals("End of annotations")) {
            splitLine = line.split("\t");
            textMap.put(splitLine[0], splitLine[1]);
            line = text.get(++lineNumber);
        }
        this.textAnnotation = (TextAnnotation)AutoAnnotationManager.getInstance().getTextFactory().createAnnotation(TextAnnotation.class, this.parent.getView(), textMap);
        line = text.get(++lineNumber);
        while (!line.equals("End of nodes")) {
            splitLine = line.split("\t");
            CyNode node = (CyNode)session.getObject(Long.valueOf(splitLine[0]), CyNode.class);
            double[] nodeCoordinates = new double[]{Double.valueOf(splitLine[1]), Double.valueOf(splitLine[2])};
            this.addNodeCoordinates(node, nodeCoordinates);
            double nodeRadius = Double.valueOf(splitLine[3]);
            this.addNodeRadius(node, nodeRadius);
            double nodeCentrality = Double.valueOf(splitLine[4]);
            this.nodesToCentralities.put(node, nodeCentrality);
            line = text.get(++lineNumber);
        }
    }

    public String toString() {
        return this.label;
    }
}

