/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.AutoAnnotationPanel;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAnnotationTask
extends AbstractTask {
    private CyNetwork network;
    private CyNetworkView view;
    private String clusterColumnName;
    private String nameColumnName;
    private String algorithm;
    private boolean layout;
    private CyLayoutAlgorithmManager layoutManager;
    private boolean groups;
    private String annotationSetName;
    private CyTableManager tableManager;
    private AutoAnnotationPanel annotationPanel;
    private DialogTaskManager dialogTaskManager;
    private SynchronousTaskManager<?> syncTaskManager;
    private CommandExecutorTaskFactory executor;
    private CytoPanel westPanel;

    public AutoAnnotationTask(CyNetworkView selectedView, String clusterColumnName, String nameColumnName, String algorithm, boolean layout, boolean groups, String annotationSetName) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        this.annotationPanel = autoAnnotationManager.getAnnotationPanel();
        this.view = selectedView;
        this.network = (CyNetwork)this.view.getModel();
        this.clusterColumnName = clusterColumnName;
        this.nameColumnName = nameColumnName;
        this.algorithm = algorithm;
        this.layout = layout;
        this.layoutManager = autoAnnotationManager.getLayoutManager();
        this.groups = groups;
        this.annotationSetName = annotationSetName;
        this.dialogTaskManager = autoAnnotationManager.getDialogTaskManager();
        this.syncTaskManager = autoAnnotationManager.getSyncTaskManager();
        this.tableManager = autoAnnotationManager.getTableManager();
        this.executor = autoAnnotationManager.getCommandExecutor();
        this.westPanel = autoAnnotationManager.getWestPanel();
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.annotationPanel.setAnnotating(true);
        taskMonitor.setTitle("Annotating Enrichment Map");
        if (this.algorithm != null) {
            taskMonitor.setProgress(0.1);
            taskMonitor.setStatusMessage("Clustering nodes...");
            this.runClusterMaker();
        }
        taskMonitor.setProgress(0.3);
        taskMonitor.setStatusMessage("Creating clusters...");
        if (this.cancelled) {
            return;
        }
        EnrichmentMapUtils.setOverrideHeatmapRevalidation(true);
        AnnotationSet annotationSet = this.makeClusters(this.network, this.view, this.annotationSetName);
        if (this.layout && this.network.getDefaultNodeTable().getColumn(this.clusterColumnName).getType() != List.class) {
            taskMonitor.setProgress(0.4);
            taskMonitor.setStatusMessage("Laying out nodes...");
            this.layoutNodes(annotationSet);
        }
        taskMonitor.setProgress(0.5);
        taskMonitor.setStatusMessage("Running WordCloud...");
        if (this.cancelled) {
            return;
        }
        this.runWordCloud(annotationSet, this.network);
        taskMonitor.setProgress(0.7);
        taskMonitor.setStatusMessage("Annotating Clusters...");
        if (this.cancelled) {
            return;
        }
        Long clusterTableSUID = (Long)this.network.getDefaultNetworkTable().getRow((Object)this.network.getSUID()).get(this.annotationSetName, Long.class);
        CyTable clusterSetTable = this.tableManager.getTable(clusterTableSUID.longValue());
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            AutoAnnotationUtils.updateClusterLabel(cluster, clusterSetTable);
        }
        this.annotationPanel.addClusters(annotationSet);
        this.annotationPanel.updateSelectedView(this.view);
        this.westPanel.setSelectedIndex(this.westPanel.indexOfComponent((Component)this.annotationPanel));
        EnrichmentMapUtils.setOverrideHeatmapRevalidation(false);
        this.annotationPanel.setAnnotating(false);
        taskMonitor.setProgress(1.0);
        taskMonitor.setStatusMessage("Done!");
    }

    private void layoutNodes(AnnotationSet clusters) {
        CyLayoutAlgorithm attributeCircle = this.layoutManager.getLayout("attributes-layout");
        TaskIterator iterator = attributeCircle.createTaskIterator(this.view, attributeCircle.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, this.clusterColumnName);
        this.syncTaskManager.execute(iterator);
        CyLayoutAlgorithm force_directed = this.layoutManager.getLayout("force-directed");
        for (Cluster cluster : clusters.getClusterMap().values()) {
            HashSet<View> nodeViewSet = new HashSet<View>();
            for (CyNode node : cluster.getNodesToCoordinates().keySet()) {
                nodeViewSet.add(this.view.getNodeView(node));
            }
            if (nodeViewSet.size() <= 4) continue;
            iterator = force_directed.createTaskIterator(this.view, force_directed.createLayoutContext(), nodeViewSet, null);
            this.syncTaskManager.execute(iterator);
        }
    }

    private void runClusterMaker() {
        String edgeAttribute;
        if (this.network.getDefaultNodeTable().getColumn(this.clusterColumnName) != null) {
            this.network.getDefaultNodeTable().deleteColumn(this.clusterColumnName);
        }
        try {
            edgeAttribute = EnrichmentMapManager.getInstance().getCyNetworkList().get(((CyNetwork)this.view.getModel()).getSUID()).getParams().getAttributePrefix() + EnrichmentMapVisualStyle.SIMILARITY_COEFFICIENT;
        }
        catch (NullPointerException e) {
            edgeAttribute = "--None--";
        }
        for (View nodeView : this.view.getNodeViews()) {
            if (!((Boolean)nodeView.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
            this.network.getRow((CyIdentifiable)nodeView.getModel()).set("selected", (Object)true);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getCommand(this.algorithm, edgeAttribute, this.network.toString()));
        Observer observer = new Observer();
        TaskIterator taskIterator = this.executor.createTaskIterator(commands, null);
        this.dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
        while (!observer.isFinished()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private AnnotationSet makeClusters(CyNetwork network, CyNetworkView networkView, String name) {
        AnnotationSet annotationSet = new AnnotationSet(name, networkView, this.clusterColumnName, this.nameColumnName);
        List nodes = network.getNodeList();
        Class columnType = network.getDefaultNodeTable().getColumn(this.clusterColumnName).getType();
        for (CyNode node : nodes) {
            TreeMap<Integer, Cluster> clusterMap = annotationSet.getClusterMap();
            View nodeView = networkView.getNodeView(node);
            double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double[] coordinates = new double[]{x, y};
            double nodeRadius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
            if (columnType == Integer.class) {
                Integer clusterNumber = (Integer)network.getRow((CyIdentifiable)node).get(this.clusterColumnName, Integer.class);
                if (clusterNumber == null) continue;
                this.addNodeToCluster(clusterNumber, node, coordinates, nodeRadius, clusterMap, annotationSet);
                continue;
            }
            if (columnType != List.class) continue;
            List clusterNumbers = new ArrayList();
            clusterNumbers = (List)network.getRow((CyIdentifiable)node).get(this.clusterColumnName, List.class);
            for (int i = 0; i < clusterNumbers.size(); ++i) {
                int clusterNumber = (Integer)clusterNumbers.get(i);
                this.addNodeToCluster(clusterNumber, node, coordinates, nodeRadius, clusterMap, annotationSet);
            }
        }
        annotationSet.setUseGroups(this.groups);
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            AutoAnnotationUtils.updateNodeCentralities(cluster);
        }
        return annotationSet;
    }

    private void addNodeToCluster(Integer clusterNumber, CyNode node, double[] coordinates, double nodeRadius, TreeMap<Integer, Cluster> clusterMap, AnnotationSet annotationSet) {
        Cluster cluster;
        if (!clusterMap.keySet().contains(clusterNumber)) {
            cluster = new Cluster(clusterNumber, annotationSet);
            annotationSet.addCluster(cluster);
        } else {
            cluster = clusterMap.get(clusterNumber);
        }
        cluster.addNodeCoordinates(node, coordinates);
        cluster.addNodeRadius(node, nodeRadius);
    }

    private void runWordCloud(AnnotationSet annotationSet, CyNetwork network) {
        TreeMap<Integer, Cluster> clusterMap = annotationSet.getClusterMap();
        for (int clusterNumber : clusterMap.keySet()) {
            Cluster cluster = clusterMap.get(clusterNumber);
            this.setClusterSelected(cluster, network, true);
            ArrayList<String> commands = new ArrayList<String>();
            String command = "wordcloud create wordColumnName=\"" + this.nameColumnName + "\"" + " nodesToUse=\"selected\" cloudName=\"" + this.annotationSetName + " Cloud " + clusterNumber + "\"" + " cloudGroupTableName=\"" + this.annotationSetName + "\"";
            commands.add(command);
            Observer observer = new Observer();
            TaskIterator taskIterator = this.executor.createTaskIterator(commands, null);
            this.dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.setClusterSelected(cluster, network, false);
        }
    }

    private void setClusterSelected(Cluster cluster, CyNetwork network, boolean b) {
        for (CyNode node : network.getNodeList()) {
            network.getRow((CyIdentifiable)node).set("selected", (Object)false);
        }
        for (CyNode node : cluster.getNodesToCoordinates().keySet()) {
            network.getRow((CyIdentifiable)node).set("selected", (Object)b);
        }
    }

    private String getCommand(String algorithm, String edgeAttribute, String networkName) {
        String command = "";
        if (algorithm == "Affinity Propagation Cluster") {
            command = "cluster ap attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Cluster Fuzzifier") {
            command = "cluster fuzzifier attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Community cluster (GLay)") {
            command = "cluster glay clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "ConnectedComponents Cluster") {
            command = "cluster connectedcomponents attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Fuzzy C-Means Cluster") {
            command = "cluster fcml attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "MCL Cluster") {
            command = "cluster mcl attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "SCPS Cluster") {
            command = "cluster scps attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        }
        return command;
    }
}

