/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.action.AutoAnnotationActions;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.DisplayOptionsPanel;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.SynchronousTaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAnnotationPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 7901088595186775935L;
    private static final String defaultButtonString = "Use clusterMaker defaults";
    private static final String specifyColumnButtonString = "Select cluster column";
    private JComboBox<String> nameColumnDropdown;
    private JComboBox<String> clusterColumnDropdown;
    private JComboBox<String> clusterAlgorithmDropdown;
    private ButtonGroup clusterButtonGroup;
    private JRadioButton defaultButton;
    private JRadioButton specifyColumnButton;
    private JLabel networkLabel;
    private HashMap<CyNetworkView, JComboBox<AnnotationSet>> networkViewToClusterSetDropdown;
    private HashMap<AnnotationSet, JTable> clustersToTables = new HashMap();
    private JPanel outputPanel;
    private JPanel bottomButtonPanel;
    private CyNetworkView selectedView;
    private CyNetwork selectedNetwork;
    private EnrichmentMapManager emManager;
    private AutoAnnotationManager autoAnnotationManager;
    private AutoAnnotationParameters params;
    private JCheckBox layoutCheckBox;
    private JCheckBox groupsCheckBox;
    private DisplayOptionsPanel displayOptionsPanel;
    private boolean selecting = false;
    private boolean annotating = false;

    public AutoAnnotationPanel(CySwingApplication application, DisplayOptionsPanel displayOptionsPanel) {
        this.networkViewToClusterSetDropdown = new HashMap();
        this.displayOptionsPanel = displayOptionsPanel;
        this.emManager = EnrichmentMapManager.getInstance();
        this.autoAnnotationManager = AutoAnnotationManager.getInstance();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 500));
        JPanel inputPanel = this.createInputPanel();
        this.bottomButtonPanel = this.createBottomButtonPanel();
        this.bottomButtonPanel.setAlignmentX(0.0f);
        this.outputPanel = this.createOutputPanel();
        JScrollPane clusterTableScrollPane = new JScrollPane(this.outputPanel);
        this.add((Component)inputPanel, "North");
        this.add((Component)clusterTableScrollPane, "Center");
        this.add((Component)this.bottomButtonPanel, "South");
    }

    private JPanel createInputPanel() {
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        this.networkLabel = new JLabel("No network selected");
        Font font = this.networkLabel.getFont();
        this.networkLabel.setFont(new Font(font.getFamily(), font.getStyle(), 18));
        JLabel nameColumnDropdownLabel = new JLabel("   Select the column with the gene set descriptions:");
        this.nameColumnDropdown = new JComboBox();
        final BasicCollapsiblePanel advancedOptionsPanel = this.createAdvancedOptionsPanel();
        JButton annotateButton = new JButton("Annotate!");
        ActionListener annotateAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean clusterMakerDefault = AutoAnnotationPanel.this.defaultButton.isSelected();
                String nameColumnName = (String)AutoAnnotationPanel.this.nameColumnDropdown.getSelectedItem();
                boolean layoutNodes = AutoAnnotationPanel.this.layoutCheckBox.isSelected();
                boolean useGroups = AutoAnnotationPanel.this.groupsCheckBox.isSelected();
                AutoAnnotationActions.annotateAction(AutoAnnotationPanel.this.selectedView, clusterMakerDefault, nameColumnName, layoutNodes, useGroups, AutoAnnotationPanel.this.clusterAlgorithmDropdown, AutoAnnotationPanel.this.clusterColumnDropdown);
                advancedOptionsPanel.setCollapsed(true);
                AutoAnnotationPanel.this.params = AutoAnnotationPanel.this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(AutoAnnotationPanel.this.selectedView);
            }
        };
        annotateButton.addActionListener(annotateAction);
        annotateButton.setToolTipText("Create a new annotation set");
        inputPanel.add(this.networkLabel);
        inputPanel.add(nameColumnDropdownLabel);
        inputPanel.add(this.nameColumnDropdown);
        inputPanel.add((Component)advancedOptionsPanel);
        inputPanel.add(annotateButton);
        this.networkLabel.setAlignmentX(0.5f);
        nameColumnDropdownLabel.setAlignmentX(0.5f);
        this.nameColumnDropdown.setAlignmentX(0.5f);
        advancedOptionsPanel.setAlignmentX(0.5f);
        annotateButton.setAlignmentX(0.5f);
        return inputPanel;
    }

    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel(new BorderLayout());
        JButton extractButton = new JButton("Extract");
        ActionListener extractActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                JTable clusterTable = (JTable)AutoAnnotationPanel.this.clustersToTables.get(annotationSet);
                AutoAnnotationActions.extractAction(annotationSet, clusterTable);
            }
        };
        extractButton.addActionListener(extractActionListener);
        extractButton.setToolTipText("Create a new cluster");
        JButton mergeButton = new JButton("Merge");
        ActionListener mergeActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                JTable clusterTable = (JTable)AutoAnnotationPanel.this.clustersToTables.get(annotationSet);
                AutoAnnotationActions.mergeAction(annotationSet, clusterTable);
            }
        };
        mergeButton.addActionListener(mergeActionListener);
        mergeButton.setToolTipText("Merge clusters into one");
        JButton deleteButton = new JButton("Delete");
        ActionListener deleteActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                JTable clusterTable = (JTable)AutoAnnotationPanel.this.clustersToTables.get(annotationSet);
                AutoAnnotationActions.deleteAction(annotationSet, clusterTable);
            }
        };
        deleteButton.addActionListener(deleteActionListener);
        deleteButton.setToolTipText("Delete selected cluster(s)");
        JPanel outputButtonPanel = new JPanel();
        outputButtonPanel.add(new JLabel("Clusters:"));
        outputButtonPanel.add(extractButton);
        outputButtonPanel.add(mergeButton);
        outputButtonPanel.add(deleteButton);
        JPanel outputBottomPanel = new JPanel();
        outputBottomPanel.setLayout(new BoxLayout(outputBottomPanel, 3));
        outputBottomPanel.add(outputButtonPanel);
        outputPanel.add((Component)outputBottomPanel, "South");
        return outputPanel;
    }

    private JPanel createBottomButtonPanel() {
        JPanel bottomButtonPanel = new JPanel();
        JButton removeButton = new JButton("Remove");
        ActionListener clearActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox clusterSetDropdown = (JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView);
                AnnotationSet annotationSet = (AnnotationSet)clusterSetDropdown.getSelectedItem();
                AutoAnnotationPanel.this.remove(((JTable)AutoAnnotationPanel.this.clustersToTables.get(annotationSet)).getParent());
                AutoAnnotationActions.removeAction(AutoAnnotationPanel.this.selectedNetwork, annotationSet, clusterSetDropdown, AutoAnnotationPanel.this.clustersToTables, AutoAnnotationPanel.this.params);
            }
        };
        removeButton.addActionListener(clearActionListener);
        removeButton.setToolTipText("Remove Annotation Set");
        JButton updateButton = new JButton("Update");
        ActionListener updateActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                AutoAnnotationActions.updateAction(annotationSet);
            }
        };
        updateButton.addActionListener(updateActionListener);
        updateButton.setToolTipText("Update Annotation Set");
        bottomButtonPanel = new JPanel();
        bottomButtonPanel.add(new JLabel("Annotation Sets:"));
        bottomButtonPanel.add(removeButton);
        bottomButtonPanel.add(updateButton);
        return bottomButtonPanel;
    }

    private BasicCollapsiblePanel createAdvancedOptionsPanel() {
        BasicCollapsiblePanel optionsPanel = new BasicCollapsiblePanel("Advanced Options");
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.defaultButton = new JRadioButton(defaultButtonString);
        this.specifyColumnButton = new JRadioButton(specifyColumnButtonString);
        this.defaultButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AutoAnnotationPanel.this.clusterAlgorithmDropdown.setVisible(true);
                    AutoAnnotationPanel.this.clusterColumnDropdown.setVisible(false);
                } else if (e.getStateChange() == 2) {
                    AutoAnnotationPanel.this.clusterAlgorithmDropdown.setVisible(false);
                    AutoAnnotationPanel.this.clusterColumnDropdown.setVisible(true);
                }
            }
        });
        this.clusterButtonGroup = new ButtonGroup();
        this.clusterButtonGroup.add(this.defaultButton);
        this.clusterButtonGroup.add(this.specifyColumnButton);
        JPanel clusterButtonPanel = new JPanel();
        clusterButtonPanel.setLayout(new BoxLayout(clusterButtonPanel, 3));
        clusterButtonPanel.add(this.defaultButton);
        clusterButtonPanel.add(this.specifyColumnButton);
        DefaultComboBoxModel<String> clusterDropdownModel = new DefaultComboBoxModel<String>();
        for (String algorithm : this.autoAnnotationManager.getAlgorithmToColumnName().keySet()) {
            clusterDropdownModel.addElement(algorithm);
        }
        this.clusterAlgorithmDropdown = new JComboBox(clusterDropdownModel);
        this.clusterAlgorithmDropdown.setPreferredSize(new Dimension(135, 30));
        this.clusterColumnDropdown = new JComboBox();
        this.clusterColumnDropdown.setPreferredSize(new Dimension(135, 30));
        this.clusterAlgorithmDropdown.setVisible(true);
        this.clusterColumnDropdown.setVisible(false);
        this.clusterAlgorithmDropdown.setSelectedItem("MCL Cluster");
        JPanel dropdownPanel = new JPanel();
        dropdownPanel.add(this.clusterAlgorithmDropdown);
        dropdownPanel.add(this.clusterColumnDropdown);
        this.defaultButton.setSelected(true);
        this.layoutCheckBox = new JCheckBox("Layout nodes by cluster");
        this.layoutCheckBox.setSelected(false);
        this.groupsCheckBox = new JCheckBox("Create Groups for clusters");
        this.groupsCheckBox.setSelected(false);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 1));
        checkBoxPanel.add(this.layoutCheckBox);
        checkBoxPanel.add(this.groupsCheckBox);
        JPanel nonClusterOptionPanel = new JPanel();
        nonClusterOptionPanel.add(checkBoxPanel);
        JPanel clusterOptionPanel = new JPanel(new BorderLayout());
        clusterOptionPanel.setBorder(BorderFactory.createTitledBorder("ClusterMaker Options"));
        clusterOptionPanel.add((Component)clusterButtonPanel, "West");
        clusterOptionPanel.add((Component)dropdownPanel, "East");
        innerPanel.add((Component)clusterOptionPanel, "North");
        innerPanel.add((Component)nonClusterOptionPanel, "South");
        optionsPanel.add((Component)innerPanel);
        return optionsPanel;
    }

    private JTable createClusterTable(final AnnotationSet annotationSet) {
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = -1277709187563893042L;
            Class<?>[] types = new Class[]{Object.class, Integer.class};

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        model.addColumn("Cluster");
        model.addColumn("Number of nodes");
        final JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(320, 250));
        table.getColumnModel().getColumn(0).setPreferredWidth(210);
        table.getColumnModel().getColumn(1).setPreferredWidth(100);
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getColumn() == 0) {
                    int editedRowIndex = table.getSelectedRow();
                    Iterator<Cluster> clusters = annotationSet.getClusterMap().values().iterator();
                    ArrayList<Cluster> clustersNotInTable = new ArrayList<Cluster>();
                    while (clusters.hasNext()) {
                        clustersNotInTable.add(clusters.next());
                    }
                    for (int index = 0; index < table.getModel().getRowCount(); ++index) {
                        if (index == editedRowIndex) continue;
                        clustersNotInTable.remove((Cluster)table.getValueAt(index, 0));
                    }
                    if (clustersNotInTable.size() == 1) {
                        Cluster editedCluster = (Cluster)clustersNotInTable.get(0);
                        if (table.getValueAt(editedRowIndex, 0).getClass() == String.class) {
                            editedCluster.setLabel((String)table.getValueAt(editedRowIndex, 0));
                            table.setValueAt(editedCluster, editedRowIndex, 0);
                            editedCluster.eraseText();
                            AutoAnnotationUtils.drawTextLabel(editedCluster);
                        }
                    }
                }
            }
        });
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            Object[] rowData = new Object[]{cluster, cluster.getSize()};
            model.addRow(rowData);
        }
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CytoPanel southPanel;
                    int index;
                    AutoAnnotationPanel.this.selecting = true;
                    int[] selectedRows = table.getSelectedRows();
                    ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
                    for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
                        boolean deselect = true;
                        Cluster cluster = (Cluster)table.getModel().getValueAt(table.convertRowIndexToModel(rowIndex), 0);
                        for (int selectedRow : selectedRows) {
                            if (rowIndex != selectedRow) continue;
                            selectedClusters.add(cluster);
                            deselect = false;
                            break;
                        }
                        if (!deselect) continue;
                        AutoAnnotationUtils.deselectCluster(cluster);
                    }
                    AutoAnnotationPanel.this.setDisableHeatMapAutoFocus(true);
                    SynchronousTaskManager<?> syncTaskManager = AutoAnnotationPanel.this.autoAnnotationManager.getSyncTaskManager();
                    CommandExecutorTaskFactory executor = AutoAnnotationPanel.this.autoAnnotationManager.getCommandExecutor();
                    for (Cluster cluster : selectedClusters) {
                        AutoAnnotationUtils.selectCluster(cluster, executor, syncTaskManager);
                    }
                    for (CyRow row : AutoAnnotationPanel.this.selectedNetwork.getDefaultNodeTable().getAllRows()) {
                        row.set("selected", (Object)false);
                    }
                    AutoAnnotationPanel.this.autoAnnotationManager.flushPayloadEvents();
                    for (Cluster cluster : selectedClusters) {
                        for (CyNode node : cluster.getNodes()) {
                            AutoAnnotationPanel.this.selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
                        }
                    }
                    if (AutoAnnotationPanel.this.displayOptionsPanel.isHeatmapButtonSelected() && (index = (southPanel = AutoAnnotationPanel.this.autoAnnotationManager.getSouthPanel()).indexOfComponent((Component)AutoAnnotationPanel.this.autoAnnotationManager.getHeatmapPanel())) != -1) {
                        southPanel.setSelectedIndex(southPanel.indexOfComponent((Component)AutoAnnotationPanel.this.autoAnnotationManager.getHeatmapPanel()));
                    }
                    AutoAnnotationPanel.this.selecting = false;
                }
            }
        });
        table.setAutoCreateRowSorter(true);
        return table;
    }

    public void addClusters(AnnotationSet annotationSet) {
        this.params.addAnnotationSet(annotationSet);
        CyNetworkView clusterView = this.params.getNetworkView();
        if (!this.networkViewToClusterSetDropdown.containsKey(clusterView)) {
            this.addNetworkView(clusterView);
        }
        JTable clusterTable = this.createClusterTable(annotationSet);
        JScrollPane clusterTableScroll = new JScrollPane(clusterTable);
        clusterTableScroll.setHorizontalScrollBarPolicy(30);
        this.outputPanel.add((Component)clusterTableScroll, "Center");
        this.clustersToTables.put(annotationSet, clusterTable);
        JComboBox<AnnotationSet> clusterSetDropdown = this.networkViewToClusterSetDropdown.get(clusterView);
        clusterSetDropdown.addItem(annotationSet);
        clusterSetDropdown.setSelectedIndex(clusterSetDropdown.getItemCount() - 1);
    }

    private void addNetworkView(CyNetworkView view) {
        JComboBox annotationSetDropdown = new JComboBox();
        annotationSetDropdown.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CyGroupManager groupManager = AutoAnnotationPanel.this.autoAnnotationManager.getGroupManager();
                CyGroupFactory groupFactory = AutoAnnotationPanel.this.autoAnnotationManager.getGroupFactory();
                if (itemEvent.getStateChange() == 1) {
                    AnnotationSet annotationSet = (AnnotationSet)itemEvent.getItem();
                    AutoAnnotationPanel.this.displayOptionsPanel.setSelectedAnnotationSet(annotationSet);
                    AutoAnnotationPanel.this.params.setSelectedAnnotationSet(annotationSet);
                    annotationSet.updateCoordinates();
                    String annotationSetName = annotationSet.getName();
                    Long clusterTableSUID = (Long)AutoAnnotationPanel.this.selectedNetwork.getDefaultNetworkTable().getRow((Object)AutoAnnotationPanel.this.selectedNetwork.getSUID()).get(annotationSetName, Long.class);
                    CyTable clusterSetTable = AutoAnnotationPanel.this.autoAnnotationManager.getTableManager().getTable(clusterTableSUID.longValue());
                    for (Cluster cluster : annotationSet.getClusterMap().values()) {
                        if (cluster.getEllipse() == null && cluster.getTextAnnotation() == null) {
                            AutoAnnotationUtils.updateClusterLabel(cluster, clusterSetTable);
                        }
                        AutoAnnotationUtils.drawCluster(cluster);
                        if (!annotationSet.usingGroups()) continue;
                        CyGroup group = groupFactory.createGroup(AutoAnnotationPanel.this.selectedNetwork, cluster.getNodesToCoordinates().keySet().iterator().next(), true);
                        ArrayList<CyNode> nodesWithoutGroupNode = new ArrayList<CyNode>(cluster.getNodesToCoordinates().keySet());
                        nodesWithoutGroupNode.remove(0);
                        group.addNodes(nodesWithoutGroupNode);
                        cluster.setGroup(group);
                    }
                    AutoAnnotationPanel.this.setOutputVisibility(true);
                    ((JTable)AutoAnnotationPanel.this.clustersToTables.get(annotationSet)).getParent().getParent().setVisible(true);
                    AutoAnnotationPanel.this.updateUI();
                } else if (itemEvent.getStateChange() == 2) {
                    AnnotationSet clusters = (AnnotationSet)itemEvent.getItem();
                    for (Cluster cluster : clusters.getClusterMap().values()) {
                        cluster.erase();
                        CyGroup group = cluster.getGroup();
                        if (group == null) continue;
                        if (cluster.isCollapsed()) {
                            cluster.getGroup().expand(AutoAnnotationPanel.this.selectedNetwork);
                        }
                        group.removeGroupFromNetwork(AutoAnnotationPanel.this.selectedNetwork);
                        groupManager.destroyGroup(group);
                        cluster.removeGroup();
                    }
                    if (AutoAnnotationPanel.this.clustersToTables.containsKey(clusters)) {
                        ((JTable)AutoAnnotationPanel.this.clustersToTables.get(clusters)).getParent().getParent().setVisible(false);
                    }
                    AutoAnnotationPanel.this.setOutputVisibility(false);
                    AutoAnnotationPanel.this.updateUI();
                }
            }
        });
        this.outputPanel.add(annotationSetDropdown, "North");
        this.networkViewToClusterSetDropdown.put(view, annotationSetDropdown);
        this.selectedView = view;
        this.selectedNetwork = (CyNetwork)view.getModel();
        this.params = this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(view);
        this.networkLabel.setText(this.selectedNetwork.toString());
        this.updateUI();
    }

    public void setOutputVisibility(boolean b) {
        this.outputPanel.getParent().getParent().setVisible(b);
        this.bottomButtonPanel.setVisible(b);
        if (b) {
            this.autoAnnotationManager.getDisplayOptionsPanelAction().actionPerformed(new ActionEvent("", 0, ""));
        } else {
            this.displayOptionsPanel.setVisible(b);
        }
    }

    public void updateSelectedView(CyNetworkView view) {
        this.selectedView = view;
        this.selectedNetwork = (CyNetwork)view.getModel();
        if (this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().containsKey(this.selectedView)) {
            this.params = this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(this.selectedView);
            if (!this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
                for (AnnotationSet annotationSet : this.params.getAnnotationSets().values()) {
                    this.addClusters(annotationSet);
                }
                if (this.params.getSelectedAnnotationSet() != null) {
                    this.networkViewToClusterSetDropdown.get(this.selectedView).setSelectedItem(this.params.getSelectedAnnotationSet());
                }
            }
            this.setOutputVisibility(true);
        } else {
            this.setOutputVisibility(false);
        }
        this.nameColumnDropdown.removeAllItems();
        this.clusterColumnDropdown.removeAllItems();
        for (CyColumn column : ((CyNetwork)view.getModel()).getDefaultNodeTable().getColumns()) {
            if (column.getType() == String.class) {
                this.nameColumnDropdown.addItem(column.getName());
                continue;
            }
            if (column.getType() != Integer.class && (column.getType() != List.class || column.getListElementType() != Integer.class)) continue;
            this.clusterColumnDropdown.addItem(column.getName());
        }
        for (int i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
            if (this.nameColumnDropdown.getItemAt(i).getClass() != String.class || !this.nameColumnDropdown.getItemAt(i).contains("GS_DESCR")) continue;
            this.nameColumnDropdown.setSelectedIndex(i);
        }
        this.networkLabel.setText("  " + this.selectedNetwork.toString());
        this.updateUI();
        if (this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
            JComboBox<AnnotationSet> currentDropdown = this.networkViewToClusterSetDropdown.get(this.selectedView);
            currentDropdown.setVisible(false);
            this.clustersToTables.get(currentDropdown.getSelectedItem()).getParent().getParent().setVisible(false);
        }
        if (this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
            this.networkViewToClusterSetDropdown.get(this.selectedView).setVisible(true);
            this.clustersToTables.get(this.networkViewToClusterSetDropdown.get(this.selectedView).getSelectedItem()).getParent().getParent().setVisible(true);
        }
    }

    public JTable getClusterTable(AnnotationSet annotationSet) {
        return this.clustersToTables.get(annotationSet);
    }

    public void updateColumnName(CyTable source, String oldColumnName, String newColumnName) {
        if (source == this.selectedNetwork.getDefaultNodeTable()) {
            int i;
            for (i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
                if (this.nameColumnDropdown.getModel().getElementAt(i) != oldColumnName) continue;
                this.nameColumnDropdown.removeItem(oldColumnName);
                this.nameColumnDropdown.insertItemAt(newColumnName, i);
            }
            for (i = 0; i < this.clusterColumnDropdown.getItemCount(); ++i) {
                if (this.clusterColumnDropdown.getModel().getElementAt(i) != oldColumnName) continue;
                this.clusterColumnDropdown.removeItem(oldColumnName);
                this.clusterColumnDropdown.insertItemAt(newColumnName, i);
            }
        }
    }

    public void removeNetworkView(CyNetworkView view) {
        if (this.networkViewToClusterSetDropdown.size() == 1 && this.networkViewToClusterSetDropdown.containsKey(view)) {
            this.networkLabel.setText("No network selected");
            this.nameColumnDropdown.removeAllItems();
            this.clusterColumnDropdown.removeAllItems();
            this.updateUI();
            if (this.networkViewToClusterSetDropdown.containsKey(view)) {
                JComboBox<AnnotationSet> clusterSetDropdown = this.networkViewToClusterSetDropdown.get(view);
                Container clusterTable = this.clustersToTables.get(this.networkViewToClusterSetDropdown.get(view).getSelectedItem()).getParent().getParent();
                clusterSetDropdown.getParent().remove(clusterSetDropdown);
                clusterTable.getParent().remove(clusterTable);
                this.networkViewToClusterSetDropdown.remove(view);
            }
            this.selectedView = null;
            this.selectedNetwork = null;
            this.params = null;
        }
    }

    public void columnDeleted(CyTable source, String columnName) {
        if (source == this.selectedNetwork.getDefaultNodeTable()) {
            int i;
            for (i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
                if (this.nameColumnDropdown.getModel().getElementAt(i) != columnName) continue;
                this.nameColumnDropdown.removeItem(columnName);
            }
            for (i = 0; i < this.clusterColumnDropdown.getItemCount(); ++i) {
                if (this.clusterColumnDropdown.getModel().getElementAt(i) != columnName) continue;
                this.clusterColumnDropdown.removeItem(columnName);
            }
        }
    }

    public void columnCreated(CyTable source, String columnName) {
        CyTable nodeTable = this.selectedNetwork.getDefaultNodeTable();
        if (source == nodeTable) {
            CyColumn column = nodeTable.getColumn(columnName);
            if (column.getType() == String.class) {
                if (((DefaultComboBoxModel)this.nameColumnDropdown.getModel()).getIndexOf(column) == -1) {
                    this.nameColumnDropdown.addItem(column.getName());
                }
            } else if ((column.getType() == Integer.class || column.getType() == List.class && column.getListElementType() == Integer.class) && ((DefaultComboBoxModel)this.clusterColumnDropdown.getModel()).getIndexOf(column) == -1) {
                this.clusterColumnDropdown.addItem(column.getName());
            }
        }
    }

    public void updateNodeSelection(CyTable source, Collection<RowSetRecord> columnRecords) {
        CyTable nodeTable = this.selectedNetwork.getDefaultNodeTable();
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.selectedNetwork, (String)"selected", (boolean)true);
        if (source.equals(nodeTable) && this.params != null && !this.selecting && !this.annotating) {
            AnnotationSet annotationSet = this.params.getSelectedAnnotationSet();
            block0: for (Cluster cluster : annotationSet.getClusterMap().values()) {
                if (cluster.isSelected()) {
                    boolean deselected = false;
                    for (CyNode node : cluster.getNodes()) {
                        CyRow nodeRow = this.selectedNetwork.getRow((CyIdentifiable)node);
                        for (RowSetRecord row : columnRecords) {
                            if (nodeRow != row.getRow() || ((Boolean)row.getValue()).booleanValue()) continue;
                            TableModel clusterTableModel = this.clustersToTables.get(annotationSet).getModel();
                            ListSelectionModel clusterListSelectionModel = this.clustersToTables.get(annotationSet).getSelectionModel();
                            for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                                if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                                clusterListSelectionModel.removeSelectionInterval(rowIndex, rowIndex);
                                this.autoAnnotationManager.flushPayloadEvents();
                                break;
                            }
                            deselected = true;
                            break;
                        }
                        if (!deselected) continue;
                        continue block0;
                    }
                    continue;
                }
                boolean select = true;
                for (CyNode node : cluster.getNodes()) {
                    if (selectedNodes.contains(node)) continue;
                    select = false;
                    break;
                }
                if (!select) continue;
                TableModel clusterTableModel = this.clustersToTables.get(annotationSet).getModel();
                ListSelectionModel clusterListSelectionModel = this.clustersToTables.get(annotationSet).getSelectionModel();
                for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                    if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                    clusterListSelectionModel.addSelectionInterval(rowIndex, rowIndex);
                    this.autoAnnotationManager.flushPayloadEvents();
                    continue block0;
                }
            }
        }
    }

    public void setHeatMapNoSort() {
        try {
            HeatMapParameters heatMapParameters = this.emManager.getMap(this.selectedNetwork.getSUID()).getParams().getHmParams();
            if (heatMapParameters != null) {
                heatMapParameters.setSort(HeatMapParameters.Sort.NONE);
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public void setDisableHeatMapAutoFocus(boolean b) {
        try {
            this.emManager.getMap(this.selectedNetwork.getSUID()).getParams().setDisableHeatmapAutofocus(b);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Annotation Panel";
    }

    public AnnotationSet getSelectedAnnotationSet() {
        return this.params.getSelectedAnnotationSet();
    }

    public void setDisplayOptionsPanel(DisplayOptionsPanel displayOptionsPanel) {
        this.displayOptionsPanel = displayOptionsPanel;
    }

    public void setAnnotating(boolean b) {
        this.annotating = b;
    }
}

