/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.baderlab.wordcloud.internal.AbstractSemanticSummaryAction;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryManager;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;

public class DeleteCloudAction
extends AbstractSemanticSummaryAction {
    private static final long serialVersionUID = -321557784440369508L;
    private CySwingApplication application;
    private SemanticSummaryManager cloudManager;

    public DeleteCloudAction(CySwingApplication application, SemanticSummaryManager cloudManager) {
        super("Delete Cloud");
        this.application = application;
        this.cloudManager = cloudManager;
    }

    public void actionPerformed(ActionEvent ae) {
        SemanticSummaryParameters networkParams = this.cloudManager.getCurNetwork();
        CloudParameters cloudParams = this.cloudManager.getCurCloud();
        int selection = ae.getActionCommand() == "No confirmation" ? 0 : this.confirmDelete();
        if (selection == 0 && cloudParams != null && cloudParams != this.cloudManager.getNullCloudParameters()) {
            CyTable clusterTable;
            String cloudName = cloudParams.getCloudName();
            CyNetwork network = networkParams.getNetwork();
            networkParams.getClouds().remove(cloudName);
            if (network.getDefaultNodeTable().getColumn(cloudName) != null) {
                network.getDefaultNodeTable().deleteColumn(cloudName);
            }
            if ((clusterTable = cloudParams.getClusterTable()) != null) {
                ArrayList<String> cloudRow = new ArrayList<String>();
                cloudRow.add(cloudParams.getCloudName());
                clusterTable.deleteRows(cloudRow);
                if (clusterTable.getRowCount() == 0) {
                    network.getDefaultNetworkTable().deleteColumn(cloudParams.getClusterTable().getTitle());
                    networkParams.getModelManager().getTableManager().deleteTable(cloudParams.getClusterTable().getSUID().longValue());
                }
            }
            this.cloudManager.setupCurrentNetwork(networkParams.getNetwork());
            this.pluginAction.loadCloudPanel();
            this.pluginAction.loadInputPanel();
        }
    }

    private int confirmDelete() {
        JFrame parent = this.application.getJFrame();
        int value = 1;
        value = JOptionPane.showConfirmDialog(parent, "Are you sure you want to permanently delete the selected cloud?", "Delete Cloud", 0);
        return value;
    }
}

