/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.baderlab.wordcloud.internal.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.CloudListSelectionHandler;
import org.baderlab.wordcloud.internal.CloudParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryInputPanel;
import org.baderlab.wordcloud.internal.SemanticSummaryParameters;
import org.baderlab.wordcloud.internal.SemanticSummaryParametersFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.AddedNodesEvent;
import org.cytoscape.model.events.AddedNodesListener;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.events.RemovedNodesListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.CyNetworkView;

public class SemanticSummaryManager
implements SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
NetworkAboutToBeDestroyedListener,
RowsSetListener,
ColumnCreatedListener,
ColumnDeletedListener,
AddedNodesListener,
RemovedNodesListener,
NetworkAddedListener {
    private Map<CyNetwork, SemanticSummaryParameters> cyNetworkList;
    private SemanticSummaryInputPanel inputWindow;
    private CloudDisplayPanel cloudWindow;
    private SemanticSummaryParameters curNetwork;
    private CloudParameters curCloud;
    private SemanticSummaryParameters nullSemanticSummary;
    private CloudParameters nullCloudParameters;
    private CyApplicationManager applicationManager;
    private SemanticSummaryParametersFactory parametersFactory;

    public SemanticSummaryManager(CyApplicationManager applicationManager, SemanticSummaryParametersFactory parametersFactory) {
        this.applicationManager = applicationManager;
        this.parametersFactory = parametersFactory;
        this.cyNetworkList = new IdentityHashMap<CyNetwork, SemanticSummaryParameters>();
        this.nullSemanticSummary = parametersFactory.createSemanticSummaryParameters();
        this.nullCloudParameters = new CloudParameters(this.nullSemanticSummary);
        this.nullCloudParameters.setCloudName("Null Cloud");
        this.curNetwork = this.nullSemanticSummary;
        this.curCloud = this.nullCloudParameters;
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        this.networkDestroyed(event.getNetwork());
    }

    public void handleEvent(SetCurrentNetworkEvent event) {
        CyNetwork network = event.getNetwork();
        this.setupCurrentNetwork(network);
    }

    public void handleEvent(SetCurrentNetworkViewEvent event) {
        CyNetworkView view = event.getNetworkView();
        CyNetwork network = view == null ? null : (CyNetwork)view.getModel();
        this.setupCurrentNetwork(network);
    }

    public void handleEvent(ColumnCreatedEvent event) {
        if (this.inputWindow == null) {
            return;
        }
        this.inputWindow.refreshAttributeCMB();
    }

    public void handleEvent(ColumnDeletedEvent event) {
        if (this.inputWindow == null) {
            return;
        }
        this.inputWindow.refreshAttributeCMB();
    }

    public void handleEvent(AddedNodesEvent event) {
        this.networkModified((CyNetwork)event.getSource());
    }

    public void handleEvent(RemovedNodesEvent event) {
        this.networkModified((CyNetwork)event.getSource());
    }

    public void handleEvent(RowsSetEvent event) {
        TableMatch match = this.findMatch((CyTable)event.getSource());
        if (match == null) {
            return;
        }
        String newTitle = null;
        for (RowSetRecord record : event.getPayloadCollection()) {
            if (!record.getColumn().equals("name")) continue;
            newTitle = (String)record.getValue();
            break;
        }
        if (match.tableType.equals(CyNetwork.class) && newTitle != null && this.isSemanticSummary(match.network)) {
            this.getInputWindow().getNetworkLabel().setText(newTitle);
        }
    }

    public void handleEvent(NetworkAddedEvent e) {
        CyNetwork network = e.getNetwork();
        if (!this.isSemanticSummary(network)) {
            return;
        }
        this.refreshCurrentNetworkList(network);
    }

    private TableMatch findMatch(CyTable table) {
        if (table == null) {
            return null;
        }
        for (Map.Entry<CyNetwork, SemanticSummaryParameters> entry : this.cyNetworkList.entrySet()) {
            CyNetwork network = entry.getKey();
            Class<CyNetwork> type = null;
            if (network.getDefaultNetworkTable() == table) {
                type = CyNetwork.class;
            } else if (network.getDefaultNodeTable() == table) {
                type = CyNode.class;
            } else if (network.getDefaultEdgeTable() == table) {
                type = CyEdge.class;
            }
            if (type == null) continue;
            return new TableMatch(network, type);
        }
        return null;
    }

    private void networkDestroyed(CyNetwork network) {
        if (this.isSemanticSummary(network)) {
            this.cyNetworkList.remove(network);
        }
    }

    public void reset() {
        this.cyNetworkList.clear();
    }

    private void networkModified(CyNetwork network) {
        if (this.isSemanticSummary(network)) {
            SemanticSummaryParameters params = this.getParameters(network);
            params.updateParameters(network);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, SemanticSummaryParameters params) {
        this.cyNetworkList.put(cyNetwork, params);
    }

    public boolean isSemanticSummary(CyNetwork network) {
        return this.cyNetworkList.containsKey(network);
    }

    public void setupCurrentNetwork(CyNetwork network) {
        if (network == null) {
            this.curNetwork = this.nullSemanticSummary;
            this.curCloud = this.nullCloudParameters;
        } else if (this.isSemanticSummary(network)) {
            this.curNetwork = this.getParameters(network);
        } else {
            SemanticSummaryParameters params = this.parametersFactory.createSemanticSummaryParameters(network);
            params.updateParameters(network);
            this.registerNetwork(network, params);
            this.curNetwork = params;
        }
        this.getInputWindow().setNetworkList(this.curNetwork);
        this.getCloudWindow().clearCloud();
        this.getInputWindow().setUserDefaults();
        this.getInputWindow().refreshAttributeCMB();
        this.getInputWindow().refreshNetworkSettings();
        this.getInputWindow().loadCurrentCloud(this.curCloud);
    }

    public void refreshCurrentNetworkList(CyNetwork network) {
        String newNetworkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        if (network == null) {
            this.curNetwork = this.nullSemanticSummary;
            this.curCloud = this.nullCloudParameters;
        } else if (this.isSemanticSummary(network)) {
            this.curNetwork = this.getParameters(network);
        } else {
            SemanticSummaryParameters params = this.parametersFactory.createSemanticSummaryParameters(network);
            params.updateParameters(network);
            this.registerNetwork(network, params);
            this.curNetwork = params;
        }
        String oldNetworkName = this.curNetwork.getNetworkName();
        JList cloudList = this.getInputWindow().getCloudList();
        Object selected = cloudList.getSelectedValue();
        String CloudName = this.curCloud.getCloudName();
        this.getInputWindow().setNetworkList(this.curNetwork);
        if (newNetworkName.equals(oldNetworkName) && selected != null) {
            ListSelectionModel listSelectionModel = cloudList.getSelectionModel();
            CloudListSelectionHandler handler = this.getInputWindow().getCloudListSelectionHandler();
            listSelectionModel.removeListSelectionListener(handler);
            String selectedValue = (String)selected;
            this.getInputWindow().getCloudList().setSelectedValue(selectedValue, true);
            listSelectionModel.addListSelectionListener(handler);
            if (this.curNetwork.containsCloud(CloudName)) {
                this.curCloud = this.curNetwork.getCloud(CloudName);
            }
        } else if (!newNetworkName.equals(oldNetworkName)) {
            this.getInputWindow().setUserDefaults();
            this.getInputWindow().refreshAttributeCMB();
            this.getCloudWindow().clearCloud();
        }
    }

    public SemanticSummaryParameters getParameters(CyNetwork network) {
        return this.cyNetworkList.get(network);
    }

    public void setupNullCloudParams() {
        this.nullCloudParameters = new CloudParameters(null);
        this.nullCloudParameters.setCloudName("Null Cloud");
    }

    public Map<CyNetwork, SemanticSummaryParameters> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public SemanticSummaryInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(SemanticSummaryInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public CloudDisplayPanel getCloudWindow() {
        return this.cloudWindow;
    }

    public void setCloudDisplayWindow(CloudDisplayPanel cloudWindow) {
        this.cloudWindow = cloudWindow;
    }

    public SemanticSummaryParameters getCurNetwork() {
        return this.curNetwork;
    }

    public void setCurNetwork(SemanticSummaryParameters params) {
        this.curNetwork = params;
    }

    public CloudParameters getCurCloud() {
        return this.curCloud;
    }

    public void setCurCloud(CloudParameters params) {
        this.curCloud = params;
    }

    public SemanticSummaryParameters getNullSemanticSummary() {
        return this.nullSemanticSummary;
    }

    public CloudParameters getNullCloudParameters() {
        return this.nullCloudParameters;
    }

    public void allAttributeValuesRemoved(String objectKey, String attributeName) {
    }

    public void attributeValueAssigned(CyNetwork network, CyNode curNode, String attributeName, Object[] keyIntoValue, Object oldAttributeValue, Object newAttributeValue) {
        if (curNode != null) {
            for (Map.Entry<CyNetwork, SemanticSummaryParameters> entry : this.getCyNetworkList().entrySet()) {
                SemanticSummaryParameters params = entry.getValue();
                CyNetwork cyNetwork = entry.getKey();
                if (!cyNetwork.containsNode(curNode)) continue;
                params.networkChanged();
            }
        }
    }

    public void attributeValueRemoved(String objectKey, String attributeName, Object[] keyIntoValue, Object attributeValue) {
    }

    public List<String> getColumnNames(CyNetwork network, Class<? extends CyIdentifiable> tableType) {
        if (network == null) {
            return Collections.emptyList();
        }
        ArrayList<String> attributeList = new ArrayList<String>();
        CyTable table = null;
        if (tableType.equals(CyNode.class)) {
            table = network.getDefaultNodeTable();
        } else if (tableType.equals(CyEdge.class)) {
            table = network.getDefaultEdgeTable();
        }
        if (table != null) {
            for (CyColumn column : table.getColumns()) {
                Class type = column.getType();
                if (type.equals(String.class)) {
                    attributeList.add(column.getName());
                    continue;
                }
                if (!type.equals(List.class) || !column.getListElementType().equals(String.class)) continue;
                attributeList.add(column.getName());
            }
            Collections.sort(attributeList);
        }
        return attributeList;
    }

    static class TableMatch {
        final CyNetwork network;
        final Class<? extends CyIdentifiable> tableType;

        public TableMatch(CyNetwork network, Class<? extends CyIdentifiable> tableType) {
            this.network = network;
            this.tableType = tableType;
        }
    }
}

