/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.ArrayList;
import org.baderlab.wordcloud.internal.CloudParameters;

public class SingleWordCluster
implements Comparable<SingleWordCluster> {
    private ArrayList<String> wordList = new ArrayList();
    private int totalSum = 0;
    private int numItems = 0;
    private CloudParameters params = new CloudParameters(null);
    private boolean initialized = false;

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        this.initialized = true;
    }

    public void add(String aWord) {
        if (!this.initialized) {
            return;
        }
        double ratio = this.params.getRatios().get(aWord);
        int fontSize = this.params.calculateFontSize(aWord, ratio);
        this.totalSum += fontSize;
        ++this.numItems;
        this.wordList.add(aWord);
    }

    public String remove(String aWord) {
        if (!this.wordList.contains(aWord)) {
            return null;
        }
        double ratio = this.params.getRatios().get(aWord);
        int fontSize = this.params.calculateFontSize(aWord, ratio);
        this.totalSum -= fontSize;
        --this.numItems;
        this.wordList.remove(aWord);
        return aWord;
    }

    public double computeRootMean() {
        if (this.totalSum == 0 || this.numItems == 0) {
            return 0.0;
        }
        return (double)this.totalSum / Math.pow(this.numItems, 0.5);
    }

    public int getLargestFont() {
        int largest = 0;
        for (String curWord : this.wordList) {
            double ratio;
            int curSize = this.params.calculateFontSize(curWord, ratio = this.params.getRatios().get(curWord).doubleValue());
            if (largest >= curSize) continue;
            largest = curSize;
        }
        return largest;
    }

    public double calculateWeightedSum() {
        double sum = 0.0;
        double k = 2.0;
        for (String curWord : this.wordList) {
            double ratio = this.params.getRatios().get(curWord);
            int curSize = this.params.calculateFontSize(curWord, ratio);
            sum += Math.pow(curSize, k);
        }
        sum = Math.pow(sum, 1.0 / k);
        return sum;
    }

    @Override
    public int compareTo(SingleWordCluster o) {
        double compareCount;
        double thisCount = this.calculateWeightedSum();
        if (thisCount < (compareCount = o.calculateWeightedSum())) {
            return -1;
        }
        if (thisCount > compareCount) {
            return 1;
        }
        String thisWord = this.getWordList().get(0);
        String compareWord = this.getWordList().get(0);
        return thisWord.compareTo(compareWord);
    }

    public ArrayList<String> getWordList() {
        return this.wordList;
    }

    public Integer getTotalSum() {
        return this.totalSum;
    }

    public Integer getNumItems() {
        return this.numItems;
    }
}

