/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;

public class InitializeGenesetsOfInterestTask
implements Task {
    private EnrichmentMap map;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public InitializeGenesetsOfInterestTask(EnrichmentMap map, TaskMonitor taskMonitor) {
        this(map);
        this.taskMonitor = taskMonitor;
    }

    public InitializeGenesetsOfInterestTask(EnrichmentMap map) {
        this.map = map;
    }

    public boolean initializeSets() {
        HashMap<String, DataSet> datasets = this.map.getDatasets();
        for (String current_dataset_name : datasets.keySet()) {
            DataSet current_dataset = datasets.get(current_dataset_name);
            HashMap<String, EnrichmentResult> enrichmentResults = current_dataset.getEnrichments().getEnrichments();
            HashMap<String, GeneSet> genesets = current_dataset.getSetofgenesets().getGenesets();
            HashMap<String, GeneSet> genesetsOfInterest = current_dataset.getGenesetsOfInterest().getGenesets();
            Ranking ranks = current_dataset.getExpressionSets().getRanksByName(current_dataset_name);
            HashMap<Integer, Integer> rank2gene = null;
            HashMap<Integer, Rank> gene2rank = null;
            if (ranks != null) {
                rank2gene = ranks.getRank2gene();
                gene2rank = ranks.getRanking();
            }
            int currentProgress = 0;
            int maxValue = enrichmentResults.size();
            if (enrichmentResults == null || enrichmentResults.isEmpty()) {
                return false;
            }
            Iterator<String> i = enrichmentResults.keySet().iterator();
            while (i.hasNext()) {
                GeneSet current_set;
                EnrichmentResult current_result;
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                String current_name = i.next().toString();
                if (this.map.getParams().getMethod().equalsIgnoreCase("GSEA")) {
                    current_result = (GSEAResult)enrichmentResults.get(current_name);
                    if (gene2rank != null && rank2gene != null) {
                        Set<Integer> allranks = rank2gene.keySet();
                        Integer largestRank = Collections.max(allranks);
                        int currentRankAtMax = ((GSEAResult)current_result).getRankAtMax();
                        if (currentRankAtMax != -1) {
                            double NES = ((GSEAResult)current_result).getNES();
                            int genekey = -1;
                            if (NES < 0.0) {
                                currentRankAtMax = largestRank - currentRankAtMax;
                                ((GSEAResult)current_result).setRankAtMax(currentRankAtMax);
                            }
                            if (rank2gene.containsKey(currentRankAtMax)) {
                                genekey = rank2gene.get(currentRankAtMax);
                            } else {
                                while (genekey == -1 && currentRankAtMax <= largestRank && currentRankAtMax > 0) {
                                    currentRankAtMax = NES < 0.0 ? ++currentRankAtMax : --currentRankAtMax;
                                    if (!rank2gene.containsKey(currentRankAtMax)) continue;
                                    genekey = rank2gene.get(currentRankAtMax);
                                }
                            }
                            if (genekey > -1) {
                                double scoreAtMax = gene2rank.get(genekey).getScore();
                                ((GSEAResult)current_result).setScoreAtMax(scoreAtMax);
                            }
                        }
                    }
                    if (((GSEAResult)current_result).geneSetOfInterest(this.map.getParams().getPvalue(), this.map.getParams().getQvalue())) {
                        if (genesets.containsKey(current_name)) {
                            current_set = genesets.get(current_name);
                            ((GSEAResult)current_result).setGsSize(current_set.getGenes().size());
                            genesetsOfInterest.put(current_name, current_set);
                            continue;
                        }
                        if (genesetsOfInterest.containsKey(current_name)) continue;
                        throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
                    }
                    if (!genesets.containsKey(current_name)) continue;
                    current_set = genesets.get(current_name);
                    ((GSEAResult)current_result).setGsSize(current_set.getGenes().size());
                    continue;
                }
                current_result = (GenericResult)enrichmentResults.get(current_name);
                if (((GenericResult)current_result).geneSetOfInterest(this.map.getParams().getPvalue(), this.map.getParams().getQvalue(), this.map.getParams().isFDR())) {
                    if (genesets.containsKey(current_name)) {
                        current_set = genesets.get(current_name);
                        ((GenericResult)current_result).setGsSize(current_set.getGenes().size());
                        GeneSet returned = genesetsOfInterest.put(current_name, current_set);
                        continue;
                    }
                    if (genesetsOfInterest.containsKey(current_name)) continue;
                    throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
                }
                if (!genesets.containsKey(current_name)) continue;
                current_set = genesets.get(current_name);
                ((GenericResult)current_result).setGsSize(current_set.getGenes().size());
            }
        }
        return true;
    }

    public void run() {
        this.initializeSets();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Initializing subset of genesets and GSEA results of interest");
    }
}

