/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResultFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.InitializeGenesetsOfInterestTask;
import org.baderlab.csplugins.enrichmentmap.RanksFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.VisualizeEnrichmentMapTask;

public class BuildEnrichmentMapTask
implements Task {
    private EnrichmentMapParameters params = new EnrichmentMapParameters();
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public BuildEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params.copyInputParameters(params);
    }

    public void buildEnrichmentMap() {
        block24: {
            try {
                GMTFileReaderTask gmtFile = new GMTFileReaderTask(this.params, this.taskMonitor);
                gmtFile.run();
            }
            catch (OutOfMemoryError e) {
                this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
                return;
            }
            catch (Exception e) {
                this.taskMonitor.setException((Throwable)e, "unable to load GMT file");
                return;
            }
            if (this.params.isData()) {
                try {
                    ExpressionFileReaderTask expressionFile1 = new ExpressionFileReaderTask(this.params, this.params.getExpressionFileName1(), 1, this.taskMonitor);
                    expressionFile1.run();
                    this.params.getExpression().rowNormalizeMatrix();
                    if (this.params.isData2()) {
                        ExpressionFileReaderTask expressionFile2 = new ExpressionFileReaderTask(this.params, this.params.getExpressionFileName2(), 2, this.taskMonitor);
                        expressionFile2.run();
                        this.params.getExpression2().rowNormalizeMatrix();
                    }
                    this.params.filterGenesets();
                    if (!this.params.checkGenesets()) {
                        throw new IllegalThreadStateException("No genes in the expression file are found in the GMT file ");
                    }
                    break block24;
                }
                catch (IllegalThreadStateException e) {
                    this.taskMonitor.setException((Throwable)e, "Either no genes in the expression file are found in the GMT file \n OR the identifiers in the Expression and GMT do not match up.", "Expression and GMT file do not match");
                    return;
                }
                catch (OutOfMemoryError e) {
                    this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
                    return;
                }
                catch (Exception e) {
                    this.taskMonitor.setException((Throwable)e, "unable to load GSEA DATA (.GCT) file");
                    return;
                }
            }
            this.params.noFilter();
        }
        try {
            EnrichmentResultFileReaderTask enrichmentResultsFilesDataset1File1 = new EnrichmentResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset1FileName1(), 1);
            enrichmentResultsFilesDataset1File1.run();
            if (this.params.isGSEA()) {
                EnrichmentResultFileReaderTask enrichmentResultsFilesDataset1File2 = new EnrichmentResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset1FileName2(), 1);
                enrichmentResultsFilesDataset1File2.run();
            }
            if (this.params.getDataset1RankedFile() != null) {
                RanksFileReaderTask ranking1 = new RanksFileReaderTask(this.params, this.params.getDataset1RankedFile(), 1, this.taskMonitor);
                ranking1.run();
            }
            if (this.params.isTwoDatasets()) {
                EnrichmentResultFileReaderTask enrichmentResultsFilesDataset2File1 = new EnrichmentResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset2FileName1(), 2);
                enrichmentResultsFilesDataset2File1.run();
                if (this.params.isGSEA()) {
                    EnrichmentResultFileReaderTask enrichmentResultsFilesDataset2File2 = new EnrichmentResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset2FileName2(), 2);
                    enrichmentResultsFilesDataset2File2.run();
                }
                if (this.params.getDataset2RankedFile() != null) {
                    RanksFileReaderTask ranking2 = new RanksFileReaderTask(this.params, this.params.getDataset2RankedFile(), 2, this.taskMonitor);
                    ranking2.run();
                }
            }
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to load enrichment results files");
            return;
        }
        try {
            InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(this.params, this.taskMonitor);
            genesets_init.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Genesets defined in the results \nfile are not found in  gene set file (GMT).\n  Please make sure you are using the correct GMT file.");
            return;
        }
        try {
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.params, this.taskMonitor);
            similarities.run();
            HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
            this.params.setGenesetSimilarity(similarity_results);
            VisualizeEnrichmentMapTask map = new VisualizeEnrichmentMapTask(this.params, this.taskMonitor);
            map.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to build/visualize map");
        }
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GSEA results");
    }
}

