/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;

public class ExpressionFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String expressionFileName;
    private int dataset;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public ExpressionFileReaderTask(EnrichmentMapParameters params, String fileName, int dataset, TaskMonitor taskMonitor) {
        this(params, fileName, dataset);
        this.taskMonitor = taskMonitor;
    }

    public ExpressionFileReaderTask(EnrichmentMapParameters params, String fileName, int dataset) {
        this.params = params;
        this.expressionFileName = fileName;
        this.dataset = dataset;
    }

    public void parse() {
        boolean twoColumns = false;
        HashSet<Integer> datasetGenes = this.params.getDatasetGenes();
        HashMap<String, Integer> genes = this.params.getGenes();
        TextFileReader reader = new TextFileReader(this.expressionFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        GeneExpressionMatrix expressionMatrix = new GeneExpressionMatrix(lines[0].split("\t"));
        HashMap<Integer, GeneExpression> expression = new HashMap<Integer, GeneExpression>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            String Name = tokens[0];
            if (i == 0) {
                if (Name.equalsIgnoreCase("#1.2")) {
                    line = lines[2];
                    i = 2;
                } else {
                    line = lines[0];
                }
                tokens = line.split("\t");
                if (tokens.length == 2) {
                    twoColumns = true;
                }
                expressionMatrix = new GeneExpressionMatrix(tokens);
                expressionMatrix.setExpressionMatrix(expression);
                continue;
            }
            if (genes.containsKey(Name)) {
                double newMin;
                Integer genekey = genes.get(Name);
                datasetGenes.add(genes.get(Name));
                String description = "";
                if (twoColumns) {
                    try {
                        Double.parseDouble(tokens[1]);
                    }
                    catch (NumberFormatException e) {
                        description = tokens[1];
                    }
                } else {
                    description = tokens[1];
                }
                GeneExpression expres = new GeneExpression(Name, description);
                expres.setExpression(tokens);
                double newMax = expres.newMax(expressionMatrix.getMaxExpression());
                if (newMax != -100.0) {
                    expressionMatrix.setMaxExpression(newMax);
                }
                if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                    expressionMatrix.setMinExpression(newMin);
                }
                expression.put(genekey, expres);
            }
            int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
            long timeRemaining = this.maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GCT file " + currentProgress + " of " + this.maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
        }
        if (this.dataset == 1) {
            if (this.params.getTemp_class1() != null) {
                expressionMatrix.setPhenotypes(this.params.getTemp_class1());
            }
            if (this.params.getClassFile1() != null) {
                expressionMatrix.setPhenotypes(this.setClasses(this.params.getClassFile1()));
            }
            this.params.setExpression(expressionMatrix);
        } else {
            if (this.params.getTemp_class2() != null) {
                expressionMatrix.setPhenotypes(this.params.getTemp_class2());
            } else if (this.params.getClassFile2() != null) {
                expressionMatrix.setPhenotypes(this.setClasses(this.params.getClassFile2()));
            }
            this.params.setExpression2(expressionMatrix);
        }
    }

    private String[] setClasses(String classFile) {
        File f = new File(classFile);
        if (!f.exists()) {
            return null;
        }
        if (!classFile.equalsIgnoreCase(null)) {
            TextFileReader reader2 = new TextFileReader(classFile);
            reader2.read();
            String fullText2 = reader2.getText();
            String[] lines2 = fullText2.split("\n");
            return lines2[2].split(" ");
        }
        String[] def_pheno = new String[]{"Na_pos", "NA_neg"};
        return def_pheno;
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GCT file");
    }
}

