/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.util.FileUtil;
import giny.model.Edge;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.baderlab.csplugins.brainlib.AvgLinkHierarchicalClustering;
import org.baderlab.csplugins.brainlib.DistanceMatrix;
import org.baderlab.csplugins.enrichmentmap.AlignExpressionDataDistance;
import org.baderlab.csplugins.enrichmentmap.ColorRenderer;
import org.baderlab.csplugins.enrichmentmap.ColumnHeaderVerticalRenderer;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.HeatMapTableModel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.RowNumberTable;
import org.baderlab.csplugins.enrichmentmap.TableHeader;
import org.baderlab.csplugins.enrichmentmap.TableSort;
import org.mskcc.colorgradient.ColorGradientMapper;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;
import org.mskcc.colorgradient.ColorGradientWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatMapPanel
extends JPanel {
    private Object[] columnNames;
    private Object[] columnNames2;
    private String[] phenotypes;
    private String[] phenotypes2;
    private Object[][] expValue;
    private int numConditions = 0;
    private int numConditions2 = 0;
    private String[] hRow1;
    private String[] hRow2;
    private String[] rowGeneName;
    private int[] rowLength;
    private ColorGradientTheme[] rowTheme;
    private ColorGradientRange[] rowRange;
    private int[] halfRow1Length;
    private int[] halfRow2Length;
    private ColorGradientTheme[] themeHalfRow1;
    private ColorGradientTheme[] themeHalfRow2;
    private ColorGradientRange[] rangeHalfRow1;
    private ColorGradientRange[] rangeHalfRow2;
    private boolean[] isHalfRow1;
    private boolean[] isHalfRow2;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private HashMap currentExpressionSet;
    private HashMap currentExpressionSet2;
    private boolean node = true;
    private String Dataset1phenotype1;
    private String Dataset1phenotype2;
    private String Dataset2phenotype1;
    private String Dataset2phenotype2;
    private HeatMapParameters hmParams;
    private EnrichmentMapParameters params;
    private boolean[] column1_ascending;
    private boolean[] column2_ascending;

    public HeatMapPanel(boolean node) {
        this.node = node;
        this.setLayout(new BorderLayout());
    }

    public void resetVariables(EnrichmentMapParameters params) {
        this.params = params;
        GeneExpressionMatrix expression = params.getExpression();
        this.numConditions = expression.getNumConditions();
        this.columnNames = expression.getColumnNames();
        this.column1_ascending = new boolean[this.columnNames.length];
        this.phenotypes = expression.getPhenotypes();
        this.Dataset1phenotype1 = params.getDataset1Phenotype1();
        this.Dataset1phenotype2 = params.getDataset1Phenotype2();
        this.hmParams = params.getHmParams();
        this.currentExpressionSet = this.node ? this.getNodeExpressionSet(params, expression) : this.getEdgeExpressionSet(params, expression);
        if (params.isData2()) {
            GeneExpressionMatrix expression2 = params.getExpression2();
            this.numConditions2 = expression2.getNumConditions();
            this.columnNames2 = expression2.getColumnNames();
            this.column2_ascending = new boolean[this.columnNames2.length - 2];
            this.phenotypes2 = expression2.getPhenotypes();
            this.Dataset2phenotype1 = params.getDataset2Phenotype1();
            this.Dataset2phenotype2 = params.getDataset2Phenotype2();
            this.currentExpressionSet2 = this.node ? this.getNodeExpressionSet(params, expression2) : this.getEdgeExpressionSet(params, expression2);
        }
    }

    public void updatePanel(EnrichmentMapParameters params) {
        this.resetVariables(params);
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.currentExpressionSet != null) {
            int i;
            HeatMapTableModel OGT;
            Object[][] data;
            Object[] mergedcolumnNames = null;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            if (this.params.isData2()) {
                this.expValue = this.createSortedMergedTableData();
                data = this.createSortedMergedTableData(this.getExpValue());
                mergedcolumnNames = new String[this.columnNames.length + this.columnNames2.length - 2];
                System.arraycopy(this.columnNames, 0, mergedcolumnNames, 0, this.columnNames.length);
                System.arraycopy(this.columnNames2, 2, mergedcolumnNames, this.columnNames.length, this.columnNames2.length - 2);
                OGT = new HeatMapTableModel(mergedcolumnNames, data, this.expValue);
            } else {
                this.expValue = this.createSortedTableData();
                data = this.createSortedTableData(this.getExpValue());
                OGT = new HeatMapTableModel(this.columnNames, data, this.expValue);
            }
            TableSort sort = new TableSort(OGT);
            JTable jTable1 = new JTable(sort);
            TableHeader header = new TableHeader(sort, jTable1, this.hmParams);
            JTableHeader tableHdr = jTable1.getTableHeader();
            tableHdr.addMouseListener(header);
            if (this.hmParams.isSortbycolumn()) {
                boolean ascending;
                if (this.hmParams.getSortIndex() >= this.columnNames.length) {
                    ascending = this.column2_ascending[this.hmParams.getSortIndex() - this.columnNames.length];
                    this.hmParams.setSortbycolumnName((String)this.columnNames2[this.hmParams.getSortIndex() - this.columnNames.length + 2]);
                } else {
                    ascending = this.column1_ascending[this.hmParams.getSortIndex()];
                    this.hmParams.setSortbycolumnName((String)this.columnNames[this.hmParams.getSortIndex()]);
                }
                if (this.hmParams.isSortbycolumn_event_triggered()) {
                    this.hmParams.setSortbycolumn_event_triggered(false);
                    if (this.hmParams.getSortIndex() >= this.columnNames.length) {
                        this.column2_ascending[this.hmParams.getSortIndex() - this.columnNames.length] = !this.column2_ascending[this.hmParams.getSortIndex() - this.columnNames.length];
                        ascending = this.column2_ascending[this.hmParams.getSortIndex() - this.columnNames.length];
                    } else {
                        this.column1_ascending[this.hmParams.getSortIndex()] = !this.column1_ascending[this.hmParams.getSortIndex()];
                        ascending = this.column1_ascending[this.hmParams.getSortIndex()];
                    }
                }
                header.sortByColumn(this.hmParams.getSortIndex(), ascending);
            }
            jTable1.setDefaultRenderer(Color.class, new ColorRenderer());
            TableColumnModel tcModel = jTable1.getColumnModel();
            jTable1.setDragEnabled(false);
            jTable1.setCellSelectionEnabled(true);
            ColumnHeaderVerticalRenderer pheno1_renderer = new ColumnHeaderVerticalRenderer();
            pheno1_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype1);
            ColumnHeaderVerticalRenderer pheno2_renderer = new ColumnHeaderVerticalRenderer();
            pheno2_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype2);
            ColumnHeaderVerticalRenderer default_renderer = new ColumnHeaderVerticalRenderer();
            default_renderer.setBackground(Color.white);
            if (this.params.isData2()) {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
                for (i = this.columnNames.length; i < this.columnNames.length + this.columnNames2.length - 2; ++i) {
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes2 != null) {
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            } else {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            }
            jTable1.setColumnModel(tcModel);
            JScrollPane jScrollPane = new JScrollPane(jTable1);
            RowNumberTable rowTable = new RowNumberTable(jTable1);
            jScrollPane.setRowHeaderView(rowTable);
            if (this.columnNames.length > 20) {
                jTable1.setAutoResizeMode(0);
            }
            mainPanel.add(jScrollPane);
            mainPanel.revalidate();
            this.add((Component)this.createNorthPanel(), "North");
            this.add((Component)jScrollPane, "Center");
        }
        this.revalidate();
    }

    private Object[][] createSortedTableData(Object[][] expValue2) {
        this.expValue = expValue2;
        int[] HRow = this.getRowLength();
        ColorGradientTheme[] RowCRT = this.getRowTheme();
        ColorGradientRange[] RowCRR = this.getRowRange();
        String[] RowGene = this.getRowGeneName();
        int kValue = this.currentExpressionSet.size();
        Object[][] data = new Object[this.currentExpressionSet.size()][this.numConditions];
        for (int k = 0; k < kValue; ++k) {
            data[k][0] = this.expValue[k][0];
            data[k][1] = this.expValue[k][1];
            for (int j = 0; j < HRow[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(RowCRT[k], RowCRR[k], RowGene[k], (Double)this.expValue[k][j + 2]);
            }
        }
        return data;
    }

    private Object[][] createSortedMergedTableData(Object[][] expValue) {
        this.expValue = expValue;
        int[] HRow1 = this.getHalfRow1Length();
        int[] HRow2 = this.getHalfRow2Length();
        ColorGradientTheme[] Row1CRT = this.getThemeHalfRow1();
        ColorGradientTheme[] Row2CRT = this.getThemeHalfRow2();
        ColorGradientRange[] Row1CRR = this.getRangeHalfRow1();
        ColorGradientRange[] Row2CRR = this.getRangeHalfRow2();
        String[] Row1gene = this.gethRow1();
        String[] Row2gene = this.gethRow2();
        int kValue = Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        Object[][] data = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        for (int k = 0; k < kValue; ++k) {
            int j;
            data[k][0] = expValue[k][0];
            data[k][1] = expValue[k][1];
            for (j = 0; j < HRow1[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(Row1CRT[k], Row1CRR[k], Row1gene[k], (Double)expValue[k][j + 2]);
            }
            for (j = HRow1[k]; j < HRow2[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(Row2CRT[k], Row2CRR[k], Row2gene[k], (Double)expValue[k][j + 2]);
            }
        }
        return data;
    }

    private Object[][] createSortedTableData() {
        this.expValue = new Object[this.currentExpressionSet.size()][this.numConditions];
        this.rowLength = new int[this.currentExpressionSet.size()];
        this.rowTheme = new ColorGradientTheme[this.currentExpressionSet.size()];
        this.rowGeneName = new String[this.currentExpressionSet.size()];
        this.rowRange = new ColorGradientRange[this.currentExpressionSet.size()];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap rank2keys = new HashMap();
        HashMap<Integer, Ranking> ranks = this.getRanks();
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ranks.containsKey(key) ? ranks.get(key).getRank() : Integer.valueOf(-1);
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        Arrays.sort(ranks_subset);
        int k = 0;
        int previous = -1;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer key : keys) {
                GeneExpression row = (GeneExpression)this.currentExpressionSet.get(key);
                Double[] expression_values = this.hmParams.isRowNorm() ? row.rowNormalize() : (this.hmParams.isLogtransform() ? row.rowLogTransform() : row.getExpression());
                try {
                    this.expValue[k][0] = Integer.parseInt(row.getName());
                }
                catch (NumberFormatException v) {
                    this.expValue[k][0] = row.getName();
                }
                this.expValue[k][1] = row.getDescription();
                this.rowLength[k] = row.getExpression().length;
                this.rowTheme[k] = this.hmParams.getTheme();
                this.rowRange[k] = this.hmParams.getRange();
                this.rowGeneName[k] = row.getName();
                for (int j = 0; j < row.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values[j];
                }
                ++k;
            }
        }
        this.setRowTheme(this.rowTheme);
        this.setRowGeneName(this.rowGeneName);
        this.setRowRange(this.rowRange);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private Object[][] createSortedMergedTableData() {
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        int kValue = Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        this.expValue = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        this.hRow1 = new String[kValue];
        this.hRow2 = new String[kValue];
        this.halfRow1Length = new int[kValue];
        this.halfRow2Length = new int[kValue];
        this.isHalfRow1 = new boolean[kValue];
        this.isHalfRow2 = new boolean[kValue];
        this.rangeHalfRow1 = new ColorGradientRange[kValue];
        this.rangeHalfRow2 = new ColorGradientRange[kValue];
        this.themeHalfRow1 = new ColorGradientTheme[kValue];
        this.themeHalfRow2 = new ColorGradientTheme[kValue];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap rank2keys = new HashMap();
        HashMap<Integer, Ranking> ranks = this.getRanks();
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ranks.containsKey(key) ? ranks.get(key).getRank() : Integer.valueOf(-1);
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        Arrays.sort(ranks_subset);
        int k = 0;
        int previous = -1;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer currentKey : keys) {
                int j;
                GeneExpression halfRow1 = (GeneExpression)this.currentExpressionSet.get(currentKey);
                GeneExpression halfRow2 = (GeneExpression)this.currentExpressionSet2.get(currentKey);
                Double[] expression_values1 = null;
                Double[] expression_values2 = null;
                if (this.hmParams.isRowNorm()) {
                    if (halfRow1 != null) {
                        this.isHalfRow1[k] = true;
                    }
                    expression_values1 = halfRow1.rowNormalize();
                    if (halfRow2 != null) {
                        this.isHalfRow2[k] = true;
                    }
                    expression_values2 = halfRow2.rowNormalize();
                } else if (this.hmParams.isLogtransform()) {
                    if (halfRow1 != null) {
                        expression_values1 = halfRow1.rowLogTransform();
                    }
                    if (halfRow2 != null) {
                        expression_values2 = halfRow2.rowLogTransform();
                    }
                } else {
                    if (halfRow1 != null) {
                        expression_values1 = halfRow1.getExpression();
                    }
                    if (halfRow2 != null) {
                        expression_values2 = halfRow2.getExpression();
                    }
                }
                if (halfRow1 != null) {
                    try {
                        this.expValue[k][0] = Integer.parseInt(halfRow1.getName());
                    }
                    catch (NumberFormatException e) {
                        this.expValue[k][0] = halfRow1.getName();
                    }
                    this.expValue[k][1] = halfRow1.getDescription();
                } else if (halfRow2 != null) {
                    try {
                        this.expValue[k][0] = Integer.parseInt(halfRow2.getName());
                    }
                    catch (NumberFormatException e) {
                        this.expValue[k][0] = halfRow2.getName();
                    }
                    this.expValue[k][1] = halfRow2.getDescription();
                }
                if (expression_values1 == null) {
                    expression_values1 = new Double[this.columnNames.length - 2];
                    int q = 0;
                    while (m < expression_values1.length) {
                        expression_values1[q] = null;
                        ++q;
                    }
                }
                if (expression_values2 == null) {
                    expression_values2 = new Double[this.columnNames2.length - 2];
                    int q = 0;
                    while (m < expression_values2.length) {
                        expression_values2[q] = null;
                        ++q;
                    }
                }
                this.halfRow1Length[k] = halfRow1.getExpression().length;
                this.themeHalfRow1[k] = this.hmParams.getTheme();
                this.rangeHalfRow1[k] = this.hmParams.getRange();
                this.hRow1[k] = halfRow1.getName();
                for (j = 0; j < halfRow1.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values1[j];
                }
                this.halfRow2Length[k] = halfRow1.getExpression().length + halfRow2.getExpression().length;
                this.themeHalfRow2[k] = this.hmParams.getTheme();
                this.rangeHalfRow2[k] = this.hmParams.getRange();
                this.hRow2[k] = halfRow1.getName();
                for (j = halfRow1.getExpression().length; j < halfRow1.getExpression().length + halfRow2.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values2[j - halfRow1.getExpression().length];
                }
                ++k;
            }
        }
        this.setThemeHalfRow1(this.themeHalfRow1);
        this.setRangeHalfRow1(this.rangeHalfRow1);
        this.setHalfRow1Length(this.halfRow1Length);
        this.sethRow1(this.hRow1);
        this.setIsHalfRow1(this.isHalfRow1);
        this.setThemeHalfRow2(this.themeHalfRow2);
        this.setRangeHalfRow2(this.rangeHalfRow2);
        this.setHalfRow2Length(this.halfRow2Length);
        this.sethRow2(this.hRow2);
        this.setIsHalfRow2(this.isHalfRow2);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private JPanel emptyPanel() {
        JPanel empty = new JPanel();
        empty.setMaximumSize(new Dimension(50, 50));
        empty.setMinimumSize(new Dimension(50, 50));
        return empty;
    }

    private JPanel expressionLegendPanel() {
        JPanel expLegendPanel = new JPanel();
        TitledBorder expBorder = BorderFactory.createTitledBorder("Expression legend");
        expBorder.setTitleJustification(1);
        expLegendPanel.setBorder(expBorder);
        ColorGradientWidget new_legend = ColorGradientWidget.getInstance("", 200, 30, 5, 5, this.hmParams.getTheme(), this.hmParams.getRange(), true, ColorGradientWidget.LEGEND_POSITION.LEFT);
        expLegendPanel.add(new_legend);
        expLegendPanel.revalidate();
        return expLegendPanel;
    }

    private JPanel createNorthPanel() {
        JPanel northPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        northPanel.setLayout(new GridBagLayout());
        JButton SaveExpressionSet = new JButton("Save Expression Set");
        SaveExpressionSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatMapPanel.this.saveExpressionSetActionPerformed(evt);
            }
        });
        buttonPanel.add(SaveExpressionSet);
        this.addComponent(northPanel, this.expressionLegendPanel(), 0, 0, 1, 1, 17, 0);
        this.addComponent(northPanel, this.emptyPanel(), 1, 0, 1, 1, 17, 0);
        this.addComponent(northPanel, this.hmParams.createDataTransformationOptionsPanel(this.params), 2, 0, 1, 1, 10, 0);
        this.addComponent(northPanel, this.hmParams.createSortOptionsPanel(this.params), 3, 0, 1, 1, 10, 0);
        this.addComponent(northPanel, buttonPanel, 4, 0, 1, 1, 10, 0);
        northPanel.revalidate();
        return northPanel;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, this.insets, 0, 0);
        container.add(component, gbc);
    }

    private void saveExpressionSetActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"Export Heatmap as txt File", (int)FileUtil.SAVE);
        if (file != null && file.toString() != null) {
            String fileName = file.toString();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
                file = new File(fileName);
            }
            int response = 0;
            if (file.exists()) {
                response = JOptionPane.showConfirmDialog(this, "The file already exists.  Would you like to overwrite it?");
            }
            if (response != 1 && response != 2 && (response == 0 || response == 0)) {
                try {
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    for (int j = 0; j < this.columnNames.length; ++j) {
                        if (j == this.columnNames.length - 1) {
                            output.write(this.columnNames[j] + "\n");
                            continue;
                        }
                        output.write(this.columnNames[j] + "\t");
                    }
                    Iterator i = this.currentExpressionSet.keySet().iterator();
                    while (i.hasNext()) {
                        GeneExpression row = (GeneExpression)this.currentExpressionSet.get(i.next());
                        output.write(row.toString());
                    }
                    output.flush();
                    output.close();
                    JOptionPane.showMessageDialog(this, "File " + fileName + " saved.");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "unable to write to file " + fileName);
                }
            }
        }
    }

    private HashMap getNodeExpressionSet(EnrichmentMapParameters params, GeneExpressionMatrix expressionSet) {
        Object[] nodes = params.getSelectedNodes().toArray();
        if (nodes.length > 0) {
            HashSet<Integer> union = null;
            for (int i = 0; i < nodes.length; ++i) {
                Node current_node = (Node)nodes[i];
                String nodename = current_node.getIdentifier();
                GeneSet current_geneset = params.getGenesetsOfInterest().get(nodename);
                if (current_geneset == null) continue;
                HashSet<Integer> current_set = current_geneset.getGenes();
                if (union == null) {
                    union = new HashSet<Integer>(current_set);
                    continue;
                }
                union.addAll(current_set);
            }
            return expressionSet.getExpressionMatrix(union);
        }
        return null;
    }

    private HashMap getEdgeExpressionSet(EnrichmentMapParameters params, GeneExpressionMatrix expressionSet) {
        Object[] edges = params.getSelectedEdges().toArray();
        if (edges.length > 0) {
            HashSet<Integer> intersect = null;
            HashSet<Integer> union = null;
            for (int i = 0; i < edges.length; ++i) {
                Edge current_edge = (Edge)edges[i];
                String edgename = current_edge.getIdentifier();
                GenesetSimilarity similarity = params.getGenesetSimilarity().get(edgename);
                if (similarity == null) continue;
                HashSet<Integer> current_set = similarity.getOverlapping_genes();
                if (intersect == null && union == null) {
                    intersect = new HashSet<Integer>(current_set);
                    union = new HashSet<Integer>(current_set);
                    continue;
                }
                intersect.retainAll(current_set);
                union.addAll(current_set);
            }
            return expressionSet.getExpressionMatrix(intersect);
        }
        return null;
    }

    private HashMap<Integer, Ranking> getRanks() {
        HashMap<Integer, Ranking> ranks = null;
        HashMap<String, HashMap<Integer, Ranking>> all_ranks = this.params.getRanks();
        if (this.hmParams.isSortbyrank()) {
            Iterator<String> j = all_ranks.keySet().iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (!ranks_name.equalsIgnoreCase(this.hmParams.getRankFileIndex())) continue;
                ranks = all_ranks.get(ranks_name);
            }
            if (ranks == null) {
                throw new IllegalThreadStateException("invalid sort index for rank files.");
            }
        } else {
            ranks = this.getRanksByClustering();
        }
        return ranks;
    }

    private HashMap<Integer, Ranking> getRanksByClustering() {
        HashMap<Integer, Ranking> ranks;
        block8: {
            int numdatacolumns2;
            int numdatacolumns;
            block7: {
                ranks = null;
                numdatacolumns = 0;
                numdatacolumns2 = 0;
                if (this.numConditions > 0) {
                    numdatacolumns = this.numConditions - 2;
                }
                if (this.numConditions2 > 0) {
                    numdatacolumns2 = this.numConditions2 - 2;
                }
                if (this.currentExpressionSet.keySet().size() <= 1 || numdatacolumns + numdatacolumns2 <= 1) break block7;
                ArrayList<Double[]> clustering_expressionset = new ArrayList<Double[]>();
                ArrayList<Integer> labels = new ArrayList<Integer>();
                int j = 0;
                for (Integer key : this.currentExpressionSet.keySet()) {
                    Double[] z;
                    Double[] x = ((GeneExpression)this.currentExpressionSet.get(key)).getExpression();
                    if (this.params.isData2()) {
                        Double[] y = ((GeneExpression)this.currentExpressionSet2.get(key)).getExpression();
                        z = new Double[x.length + y.length];
                        System.arraycopy(x, 0, z, 0, x.length);
                        System.arraycopy(y, 0, z, x.length, y.length);
                    } else {
                        z = x;
                    }
                    clustering_expressionset.add(j, z);
                    labels.add(j, key);
                    ++j;
                }
                DistanceMatrix distanceMatrix = new DistanceMatrix(this.currentExpressionSet.keySet().size());
                distanceMatrix.calcDistances(clustering_expressionset, new AlignExpressionDataDistance());
                distanceMatrix.setLabels(labels);
                AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
                cluster.setOptimalLeafOrdering(true);
                cluster.run();
                int[] order = cluster.getLeafOrder();
                ranks = new HashMap();
                for (int i = 0; i < order.length; ++i) {
                    Integer label = (Integer)labels.get(order[i]);
                    Ranking temp = new Ranking(((GeneExpression)this.currentExpressionSet.get(label)).getName(), 0.0, i);
                    ranks.put(label, temp);
                }
                break block8;
            }
            if (this.currentExpressionSet.keySet().size() != 1 && numdatacolumns + numdatacolumns2 > 1) break block8;
            ranks = new HashMap<Integer, Ranking>();
            for (Integer key : this.currentExpressionSet.keySet()) {
                Ranking temp = new Ranking(((GeneExpression)this.currentExpressionSet.get(key)).getName(), 0.0, 0);
                ranks.put(key, temp);
            }
        }
        return ranks;
    }

    Object[][] getExpValue() {
        return this.expValue;
    }

    private Object getExpValue(int row, int col) {
        return this.expValue[row][col];
    }

    private String[] gethRow1() {
        return this.hRow1;
    }

    private void sethRow1(String[] hRow1) {
        this.hRow1 = hRow1;
    }

    private String[] gethRow2() {
        return this.hRow2;
    }

    private void sethRow2(String[] hRow2) {
        this.hRow2 = hRow2;
    }

    private void setExpValue(int i, int j, Object expressionValues2) {
        this.expValue[i][j] = expressionValues2;
    }

    void setExpValue(Object[][] expValue) {
        this.expValue = expValue;
    }

    public void clearPanel() {
        this.removeAll();
        this.revalidate();
    }

    public void setHalfRow1Length(int[] halfRow1Length) {
        this.halfRow1Length = halfRow1Length;
    }

    public int[] getHalfRow1Length() {
        return this.halfRow1Length;
    }

    public void setHalfRow2Length(int[] hRow2Length) {
        this.halfRow2Length = hRow2Length;
    }

    public int[] getHalfRow2Length() {
        return this.halfRow2Length;
    }

    public void setThemeHalfRow1(ColorGradientTheme[] themeHalfRow1) {
        this.themeHalfRow1 = themeHalfRow1;
    }

    public ColorGradientTheme[] getThemeHalfRow1() {
        return this.themeHalfRow1;
    }

    public void setThemeHalfRow2(ColorGradientTheme[] themeHalfRow2) {
        this.themeHalfRow2 = themeHalfRow2;
    }

    public ColorGradientTheme[] getThemeHalfRow2() {
        return this.themeHalfRow2;
    }

    public void setRangeHalfRow1(ColorGradientRange[] rangeHalfRow1) {
        this.rangeHalfRow1 = rangeHalfRow1;
    }

    public ColorGradientRange[] getRangeHalfRow1() {
        return this.rangeHalfRow1;
    }

    public void setRangeHalfRow2(ColorGradientRange[] rangeHalfRow2) {
        this.rangeHalfRow2 = rangeHalfRow2;
    }

    public ColorGradientRange[] getRangeHalfRow2() {
        return this.rangeHalfRow2;
    }

    public void setIsHalfRow1(boolean[] isHalfRow1) {
        this.isHalfRow1 = isHalfRow1;
    }

    public boolean[] getIsHalfRow1() {
        return this.isHalfRow1;
    }

    public void setIsHalfRow2(boolean[] isHalfRow2) {
        this.isHalfRow2 = isHalfRow2;
    }

    public boolean[] getIsHalfRow2() {
        return this.isHalfRow2;
    }

    public void setRowGeneName(String[] rowGeneName) {
        this.rowGeneName = rowGeneName;
    }

    public String[] getRowGeneName() {
        return this.rowGeneName;
    }

    public void setRowLength(int[] rowLength) {
        this.rowLength = rowLength;
    }

    public int[] getRowLength() {
        return this.rowLength;
    }

    private ColorGradientRange[] getRowRange() {
        return this.rowRange;
    }

    private void setRowRange(ColorGradientRange[] rowRange) {
        this.rowRange = rowRange;
    }

    public void setRowTheme(ColorGradientTheme[] rowTheme) {
        this.rowTheme = rowTheme;
    }

    public ColorGradientTheme[] getRowTheme() {
        return this.rowTheme;
    }
}

