/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;

public class GSEAResult
extends EnrichmentResult {
    private String Name;
    private int gsSize;
    private double ES;
    private double NES;
    private double pvalue;
    private double fdrqvalue;
    private double fwerqvalue;

    public GSEAResult(String name, int size, double ES, double NES, double pvalue, double fdrqvalue, double fwerqvalue) {
        this.Name = name;
        this.gsSize = size;
        this.ES = ES;
        this.NES = NES;
        this.pvalue = pvalue;
        this.fdrqvalue = fdrqvalue;
        this.fwerqvalue = fwerqvalue;
    }

    public GSEAResult(String[] tokens) {
        if (tokens.length != 8) {
            return;
        }
        this.Name = tokens[1];
        this.gsSize = Integer.parseInt(tokens[2]);
        this.ES = Double.parseDouble(tokens[3]);
        this.NES = Double.parseDouble(tokens[4]);
        this.pvalue = Double.parseDouble(tokens[5]);
        this.fdrqvalue = Double.parseDouble(tokens[6]);
        this.fwerqvalue = Double.parseDouble(tokens[7]);
    }

    public boolean geneSetOfInterest(double pvalue, double fdrqvalue) {
        return this.pvalue <= pvalue && this.fdrqvalue <= fdrqvalue;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getGsSize() {
        return this.gsSize;
    }

    public void setGsSize(int gsSize) {
        this.gsSize = gsSize;
    }

    public double getES() {
        return this.ES;
    }

    public void setES(double ES) {
        this.ES = ES;
    }

    public double getNES() {
        return this.NES;
    }

    public void setNES(double NES) {
        this.NES = NES;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getFdrqvalue() {
        return this.fdrqvalue;
    }

    public void setFdrqvalue(double fdrqvalue) {
        this.fdrqvalue = fdrqvalue;
    }

    public double getFwerqvalue() {
        return this.fwerqvalue;
    }

    public void setFwerqvalue(double fwerqvalue) {
        this.fwerqvalue = fwerqvalue;
    }

    public String toString() {
        return this.Name + "\t" + this.gsSize + "\t" + this.ES + "\t" + this.NES + "\t" + this.pvalue + "\t" + this.fdrqvalue + "\t" + this.fwerqvalue;
    }
}

