/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.util.OpenBrowser;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.BuildPostAnalysisActionListener;
import org.baderlab.csplugins.enrichmentmap.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.Enrichment_Map_Plugin;
import org.baderlab.csplugins.enrichmentmap.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.ShowAboutPanelAction;

public class PostAnalysisInputPanel
extends JPanel {
    private static final long serialVersionUID = 5472169142720323583L;
    static final int RIGHT = 0;
    static final int DOWN = 1;
    static final int UP = 2;
    static final int LEFT = 3;
    CollapsiblePanel Parameters;
    CollapsiblePanel signature_genesets;
    CollapsiblePanel dataset1;
    CollapsiblePanel dataset2;
    JPanel signaturePanel;
    DecimalFormat decFormat = new DecimalFormat();
    private PostAnalysisParameters paParams;
    private JRadioButton signatureHub;
    private JFormattedTextField GMTFileNameTextField;
    private JFormattedTextField signatureGMTFileNameTextField;
    private JList avail_sig_sets_field;
    private JList selected_sig_sets_field;
    private DefaultListModel avail_sig_sets;
    private DefaultListModel selected_sig_sets;
    private JComboBox sigCutoffCombo;
    private JFormattedTextField sigCutoffTextField;
    private int defaultColumns = 15;
    public static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    public static String siggmt_instruction = "Please select the Signature Gene Set file (.gmt)...";
    private static String gmtTip = "File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...";

    public PostAnalysisInputPanel() {
        this.decFormat.setParseIntegerOnly(false);
        this.setLayout(new BorderLayout());
        EnrichmentMapParameters emParams = EnrichmentMapManager.getInstance().getParameters(Cytoscape.getCurrentNetwork().getIdentifier());
        if (emParams == null) {
            emParams = new EnrichmentMapParameters();
        }
        this.paParams = emParams.getPaParams();
        JPanel AnalysisTypePanel = this.createAnalysisTypePanel();
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JScrollPane scroll = new JScrollPane(OptionsPanel);
        JPanel bottomPanel = this.createBottomPanel();
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)scroll, "Center");
        this.add((Component)AnalysisTypePanel, "North");
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenBrowser.openURL((String)Enrichment_Map_Plugin.userManualUrl);
            }
        });
        JButton about = new JButton("About");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction()));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Post Analysis Type"));
        this.signatureHub = new JRadioButton("Signature Hubs", this.paParams.isSignatureHub());
        this.signatureHub.setActionCommand("Signature Hubs");
        this.signatureHub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.signatureHub.setSelected(true);
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.signatureHub);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.signatureHub, c);
        panel.add(this.signatureHub);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTPanel = this.createGMTPanel();
        GMTPanel.setCollapsed(false);
        this.signature_genesets = new CollapsiblePanel("Signature Genesets");
        this.signature_genesets.setLayout(new BorderLayout());
        this.signature_genesets.setCollapsed(false);
        this.signaturePanel = new JPanel();
        this.signaturePanel.setLayout(new BoxLayout(this.signaturePanel, 1));
        this.signaturePanel.setPreferredSize(new Dimension(280, 300));
        this.signaturePanel.setAlignmentX(0.0f);
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        JPanel availableLabel = new JPanel();
        availableLabel.add(new JLabel("available Signature-Genesets:"));
        this.signaturePanel.add(availableLabel);
        this.avail_sig_sets_field = new JList(this.avail_sig_sets);
        JScrollPane avail_sig_sets_scroll = new JScrollPane(this.avail_sig_sets_field, 22, 30);
        avail_sig_sets_scroll.setPreferredSize(new Dimension(250, 200));
        avail_sig_sets_scroll.setMinimumSize(new Dimension(250, 150));
        avail_sig_sets_scroll.setMaximumSize(new Dimension(290, 300));
        this.signaturePanel.add(avail_sig_sets_scroll);
        ImageIcon[] icons = this.createArrowIcons();
        JPanel selectButtonPanel = new JPanel();
        selectButtonPanel.add(new JPanel());
        selectButtonPanel.setLayout(new BoxLayout(selectButtonPanel, 0));
        JButton selectButton = new JButton(icons[1]);
        selectButton.getSize().width = 30;
        selectButtonPanel.add(selectButton);
        selectButtonPanel.add(new JPanel());
        JButton unselectButton = new JButton(icons[2]);
        unselectButton.getSize().width = 30;
        selectButtonPanel.add(unselectButton);
        selectButtonPanel.add(new JPanel());
        this.signaturePanel.add(selectButtonPanel);
        JPanel selectedLabel = new JPanel();
        selectedLabel.add(new JLabel("selected Signature-Genesets:"));
        this.signaturePanel.add(selectedLabel);
        this.selected_sig_sets_field = new JList(this.selected_sig_sets);
        JScrollPane selected_sig_sets_scroll = new JScrollPane(this.selected_sig_sets_field, 22, 30);
        selected_sig_sets_scroll.setPreferredSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMinimumSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMaximumSize(new Dimension(290, 200));
        this.signaturePanel.add(selected_sig_sets_scroll);
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisInputPanel.this.avail_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisInputPanel.this.selected_sig_sets.addElement(PostAnalysisInputPanel.this.avail_sig_sets.get(selected[i - 1]));
                    PostAnalysisInputPanel.this.avail_sig_sets.remove(selected[i - 1]);
                }
            }
        });
        unselectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisInputPanel.this.selected_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisInputPanel.this.avail_sig_sets.addElement(PostAnalysisInputPanel.this.selected_sig_sets.get(selected[i - 1]));
                    PostAnalysisInputPanel.this.selected_sig_sets.remove(selected[i - 1]);
                }
                Object[] setNamesArray = PostAnalysisInputPanel.this.avail_sig_sets.toArray();
                Arrays.sort(setNamesArray);
                PostAnalysisInputPanel.this.avail_sig_sets.removeAllElements();
                for (int i = 0; i < setNamesArray.length; ++i) {
                    PostAnalysisInputPanel.this.avail_sig_sets.addElement(setNamesArray[i]);
                }
            }
        });
        this.signature_genesets.getContentPane().add((Component)this.signaturePanel, "North");
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        panel.add(GMTPanel);
        panel.add(this.signature_genesets);
        panel.add(ParametersPanel2);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene-Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("GMT:"){
            private static final long serialVersionUID = 5799024396588991328L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GMTLabel.setToolTipText(gmtTip);
        JButton selectGMTFileButton = new JButton();
        this.GMTFileNameTextField = new JFormattedTextField();
        this.GMTFileNameTextField.setColumns(this.defaultColumns);
        this.GMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.GMTFileNameTextField.setText(this.paParams.getGMTFileName());
        this.GMTFileNameTextField.setValue(this.paParams.getGMTFileName());
        if (!this.GMTFileNameTextField.getText().equals("")) {
            this.GMTFileNameTextField.setToolTipText(this.GMTFileNameTextField.getText());
        }
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel GMTPanel = new JPanel();
        GMTPanel.setLayout(new BorderLayout());
        GMTPanel.add((Component)GMTLabel, "West");
        GMTPanel.add((Component)this.GMTFileNameTextField, "Center");
        GMTPanel.add((Component)selectGMTFileButton, "East");
        panel.add(GMTPanel);
        JLabel SigGMTLabel = new JLabel("SigGMT:"){
            private static final long serialVersionUID = 8826340546360207691L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        SigGMTLabel.setToolTipText(gmtTip);
        JButton selectSigGMTFileButton = new JButton();
        this.signatureGMTFileNameTextField = new JFormattedTextField();
        this.signatureGMTFileNameTextField.setColumns(this.defaultColumns);
        this.signatureGMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.signatureGMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectSigGMTFileButton.setText("...");
        selectSigGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectSigGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectSignatureGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel SigGMTPanel = new JPanel();
        SigGMTPanel.setLayout(new BorderLayout());
        SigGMTPanel.add((Component)SigGMTLabel, "West");
        SigGMTPanel.add((Component)this.signatureGMTFileNameTextField, "Center");
        SigGMTPanel.add((Component)selectSigGMTFileButton, "East");
        panel.add(SigGMTPanel);
        JButton loadButton = new JButton();
        loadButton.setText("Load Gene-Sets");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.loadGenesetsButtonActionPerformed(evt);
            }
        });
        loadButton.setPreferredSize(new Dimension(100, 10));
        panel.add(loadButton);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createParametersPanel() {
        String[] sigCutoffItems = PostAnalysisParameters.sigCutoffItems;
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel cutoffLabel = new JPanel();
        cutoffLabel.add(new JLabel("Select Cutoff:"));
        panel.add(cutoffLabel);
        JPanel cutoffPanel = new JPanel();
        cutoffPanel.setLayout(new BoxLayout(cutoffPanel, 0));
        this.sigCutoffCombo = new JComboBox();
        this.sigCutoffCombo.addItem(sigCutoffItems[0]);
        this.sigCutoffCombo.addItem(sigCutoffItems[1]);
        this.sigCutoffCombo.addItem(sigCutoffItems[4]);
        this.sigCutoffCombo.setSelectedItem(sigCutoffItems[this.paParams.getDefault_signature_CutoffMetric()]);
        this.sigCutoffTextField = new JFormattedTextField(this.decFormat);
        this.sigCutoffTextField.setColumns(3);
        if (this.paParams.getDefault_signature_CutoffMetric() == 0) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 1) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 2) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 3) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 4) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_DirOverlap_Cutoff());
        } else {
            String message = "This Cutoff metric is not supported.";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
        }
        this.sigCutoffCombo.addActionListener(new ActionListener(){
            String[] sigCutoffItems = PostAnalysisParameters.sigCutoffItems;

            public void actionPerformed(ActionEvent e) {
                JComboBox selectedChoice = (JComboBox)e.getSource();
                if (this.sigCutoffItems[0].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(0);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Hypergeom_Cutoff());
                } else if (this.sigCutoffItems[1].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(1);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_absNumber_Cutoff());
                } else if (this.sigCutoffItems[2].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(2);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Jaccard_Cutoff());
                } else if (this.sigCutoffItems[3].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(3);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Overlap_Cutoff());
                } else if (this.sigCutoffItems[4].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(4);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_DirOverlap_Cutoff());
                }
            }
        });
        this.sigCutoffTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        cutoffPanel.add(this.sigCutoffCombo);
        cutoffPanel.add(this.sigCutoffTextField);
        panel.add(cutoffPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private ImageIcon[] createArrowIcons() {
        ImageIcon[] iconArrow = new ImageIcon[4];
        URL iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_up.gif");
        if (iconURL != null) {
            iconArrow[2] = new ImageIcon(iconURL);
        }
        if ((iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_down.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        if ((iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_left.gif")) != null) {
            iconArrow[3] = new ImageIcon(iconURL);
        }
        if ((iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_right.gif")) != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Run");
        importButton.addActionListener(new BuildPostAnalysisActionListener(this));
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setAnalysisWindow(null);
        cytoPanel.remove((Component)this);
    }

    public void close() {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setAnalysisWindow(null);
        cytoPanel.remove((Component)this);
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("Signature Hubs")) {
            this.paParams.setSignatureHub(true);
        } else {
            this.paParams.setSignatureHub(false);
        }
        boolean datasets_collapsed = this.signature_genesets.isCollapsed();
        this.signature_genesets.remove(this.signaturePanel);
        this.signaturePanel.remove(this.dataset1);
        this.signaturePanel.remove(this.dataset2);
        this.signaturePanel.revalidate();
        this.signature_genesets.getContentPane().add((Component)this.signaturePanel, "North");
        this.signature_genesets.setCollapsed(datasets_collapsed);
        this.signature_genesets.revalidate();
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gmt");
        filter.setDescription("All GMT files");
        File file = FileUtil.getFile((String)"Import GMT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.GMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.GMTFileNameTextField.setText(file.getAbsolutePath());
            this.GMTFileNameTextField.setValue(file.getAbsolutePath());
            this.paParams.setGMTFileName(file.getAbsolutePath());
            this.GMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectSignatureGMTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gmt");
        filter.setDescription("All GMT files");
        File file = FileUtil.getFile((String)"Import SigGMT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.signatureGMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.signatureGMTFileNameTextField.setText(file.getAbsolutePath());
            this.signatureGMTFileNameTextField.setValue(file.getAbsolutePath());
            this.paParams.setSignatureGMTFileName(file.getAbsolutePath());
            this.signatureGMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void loadGenesetsButtonActionPerformed(ActionEvent evt) {
        JTaskConfig config = new JTaskConfig();
        config.displayCancelButton(true);
        config.displayCloseButton(true);
        config.displayStatus(true);
        String errors = this.paParams.checkGMTfiles();
        if (errors.equalsIgnoreCase("")) {
            LoadGmtFilesTask load_GMTs = new LoadGmtFilesTask(this.paParams);
            TaskManager.executeTask((Task)load_GMTs, (JTaskConfig)config);
        } else {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), errors, "Invalid Input", 2);
        }
    }

    private void resetPanel() {
        this.paParams = new PostAnalysisParameters();
        this.signatureHub.setSelected(true);
        this.GMTFileNameTextField.setText("");
        this.GMTFileNameTextField.setValue("");
        this.GMTFileNameTextField.setToolTipText(null);
        this.signatureGMTFileNameTextField.setText("");
        this.signatureGMTFileNameTextField.setValue("");
        this.signatureGMTFileNameTextField.setToolTipText(null);
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.avail_sig_sets_field.setModel(this.avail_sig_sets);
        this.avail_sig_sets_field.clearSelection();
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        this.selected_sig_sets_field.setModel(this.selected_sig_sets);
        this.selected_sig_sets_field.clearSelection();
        this.paParams.setSignature_CutoffMetric(this.paParams.getDefault_signature_CutoffMetric());
        this.sigCutoffCombo.setSelectedIndex(this.paParams.getSignature_CutoffMetric());
        switch (this.paParams.getSignature_CutoffMetric()) {
            case 0: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
                break;
            }
            case 1: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
                break;
            }
            case 2: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
                break;
            }
            case 3: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
                break;
            }
            default: {
                String message = "This Cutoff metric is not supported.";
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }

    public void updateContents(EnrichmentMapParameters current_params) {
        this.paParams = current_params.getPaParams();
        this.GMTFileNameTextField.setText(this.paParams.getGMTFileName());
        this.GMTFileNameTextField.setValue(this.paParams.getGMTFileName());
        this.signatureGMTFileNameTextField.setText(this.paParams.getSignatureGMTFileName());
        this.signatureGMTFileNameTextField.setValue(this.paParams.getSignatureGMTFileName());
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.avail_sig_sets_field.setModel(this.avail_sig_sets);
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        this.selected_sig_sets_field.setModel(this.selected_sig_sets);
        this.sigCutoffCombo.setSelectedIndex(this.paParams.getSignature_CutoffMetric());
        switch (this.paParams.getSignature_CutoffMetric()) {
            case 0: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
                break;
            }
            case 1: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
                break;
            }
            case 2: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
                break;
            }
            case 3: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
                break;
            }
            default: {
                String message = "This Cutoff metric is not supported.";
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }

    public PostAnalysisParameters getPaParams() {
        return this.paParams;
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    private class LoadGmtFilesTask
    implements Task {
        private PostAnalysisParameters paParams = null;
        private TaskMonitor taskMonitor = null;
        private boolean interrupted = false;

        public LoadGmtFilesTask(PostAnalysisParameters paParams, TaskMonitor taskMonitor) {
            this(paParams);
            this.taskMonitor = taskMonitor;
        }

        public LoadGmtFilesTask(PostAnalysisParameters paParams) {
            this.paParams = paParams;
        }

        public String getTitle() {
            return new String("Loading Geneset Files...");
        }

        public void halt() {
            this.interrupted = true;
        }

        public void run() {
            try {
                try {
                    GMTFileReaderTask gmtFile_1 = new GMTFileReaderTask(this.paParams, this.taskMonitor, 1);
                    gmtFile_1.run();
                    GMTFileReaderTask gmtFile_2 = new GMTFileReaderTask(this.paParams, this.taskMonitor, 2);
                    gmtFile_2.run();
                }
                catch (OutOfMemoryError e) {
                    this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotment for Cytoscape.");
                    return;
                }
                catch (Exception e) {
                    this.taskMonitor.setException((Throwable)e, "unable to load GMT files");
                    return;
                }
                DefaultListModel signatureSetNames = this.paParams.getSignatureSetNames();
                DefaultListModel selectedSignatureSetNames = this.paParams.getSelectedSignatureSetNames();
                signatureSetNames.clear();
                Object[] setNamesArray = this.paParams.getSignatureGenesets().keySet().toArray();
                Arrays.sort(setNamesArray);
                for (int i = 0; i < setNamesArray.length; ++i) {
                    if (this.interrupted) {
                        throw new InterruptedException();
                    }
                    if (selectedSignatureSetNames.contains(setNamesArray[i])) continue;
                    signatureSetNames.addElement(setNamesArray[i]);
                }
            }
            catch (InterruptedException e) {
                this.taskMonitor.setException((Throwable)e, "loading of GMT files cancelled");
            }
        }

        public void setTaskMonitor(TaskMonitor taskMonitor) {
            if (this.taskMonitor != null) {
                throw new IllegalStateException("Task Monitor is already set.");
            }
            this.taskMonitor = taskMonitor;
        }
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == PostAnalysisInputPanel.this.GMTFileNameTextField) {
                String value = PostAnalysisInputPanel.this.GMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                } else if (!PostAnalysisInputPanel.this.GMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (PostAnalysisInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        PostAnalysisInputPanel.this.GMTFileNameTextField.setForeground(PostAnalysisInputPanel.this.checkFile(value));
                    } else {
                        PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                    }
                }
            } else if (source == PostAnalysisInputPanel.this.signatureGMTFileNameTextField) {
                String value = PostAnalysisInputPanel.this.signatureGMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                } else if (!PostAnalysisInputPanel.this.signatureGMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (PostAnalysisInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        PostAnalysisInputPanel.this.signatureGMTFileNameTextField.setForeground(PostAnalysisInputPanel.this.checkFile(value));
                    } else {
                        PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                    }
                }
            } else if (source == PostAnalysisInputPanel.this.sigCutoffTextField) {
                Number value = (Number)PostAnalysisInputPanel.this.sigCutoffTextField.getValue();
                if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 0) {
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Hypergeom_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Hypergeom_Cutoff());
                        message = message + "The Hypergeometric-pValue cutoff must be greater or equal than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 1) {
                    if (value != null && value.intValue() >= 0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_absNumber_Cutoff(value.intValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_absNumber_Cutoff());
                        message = message + "The \"Number of common genes\" cutoff must be a non-negative Integer (0 or larger).";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 2) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Jaccard_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Jaccard_Cutoff());
                        message = message + "The Jaccard Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 3) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Overlap_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Overlap_Cutoff());
                        message = message + "The Overlap Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 4) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_DirOverlap_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_DirOverlap_Cutoff());
                        message = message + "The Overlap Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else {
                    message = "This Cutoff metric is not supported.";
                    invalid = true;
                }
            }
            if (invalid) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

