/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.GMTFileReaderTask;

public class FileReaderTest
extends TestCase {
    public void setUp() throws Exception {
    }

    public void testGMTFileReader() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/Genesetstestfile.gmt";
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        params.setGMTFileName(testDataFileName);
        GMTFileReaderTask task = new GMTFileReaderTask(params);
        task.run();
        FileReaderTest.assertEquals((int)10, (int)params.getGenesets().size());
        FileReaderTest.assertEquals((int)75, (int)params.getGenes().size());
    }

    public void testExpression1ReaderNormal() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/Expressiontestfile.gct";
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        params.setExpressionFileName1(testDataFileName);
        HashMap<String, Integer> genes = params.getGenes();
        HashMap<Integer, String> hash2genes = params.getHashkey2gene();
        FileReaderTest.assertEquals((int)0, (int)genes.size());
        int value = params.getNumberOfGenes();
        genes.put("GLS", value);
        hash2genes.put(value, "GLS");
        params.setNumberOfGenes(value++);
        genes.put("PSMA1", value);
        hash2genes.put(value, "PSMA1");
        params.setNumberOfGenes(value++);
        genes.put("ZP1", value);
        hash2genes.put(value, "ZP1");
        params.setNumberOfGenes(value++);
        genes.put("ZYX", value);
        hash2genes.put(value, "ZYX");
        params.setNumberOfGenes(value++);
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        ExpressionFileReaderTask task = new ExpressionFileReaderTask(params, 1);
        task.run();
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        FileReaderTest.assertEquals((int)4, (int)params.getExpression().getNumGenes());
        FileReaderTest.assertEquals((int)59, (int)params.getExpression().getNumConditions());
        FileReaderTest.assertEquals((Object)0.008720342, (Object)params.getExpression().getMinExpression());
        FileReaderTest.assertEquals((Object)5.131481026, (Object)params.getExpression().getMaxExpression());
    }

    public void testExpression1ReaderCommentLines() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/Expressiontestfile_comments.gct";
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        params.setExpressionFileName1(testDataFileName);
        HashMap<String, Integer> genes = params.getGenes();
        HashMap<Integer, String> hash2genes = params.getHashkey2gene();
        FileReaderTest.assertEquals((int)0, (int)genes.size());
        int value = params.getNumberOfGenes();
        genes.put("GLS", value);
        hash2genes.put(value, "GLS");
        params.setNumberOfGenes(value++);
        genes.put("PSMA1", value);
        hash2genes.put(value, "PSMA1");
        params.setNumberOfGenes(value++);
        genes.put("ZP1", value);
        hash2genes.put(value, "ZP1");
        params.setNumberOfGenes(value++);
        genes.put("ZYX", value);
        hash2genes.put(value, "ZYX");
        params.setNumberOfGenes(value++);
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        ExpressionFileReaderTask task = new ExpressionFileReaderTask(params, 1);
        task.run();
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        FileReaderTest.assertEquals((Object)5.131481026, (Object)params.getExpression().getMaxExpression());
        FileReaderTest.assertEquals((int)4, (int)params.getExpression().getNumGenes());
        FileReaderTest.assertEquals((int)59, (int)params.getExpression().getNumConditions());
        FileReaderTest.assertEquals((Object)0.008720342, (Object)params.getExpression().getMinExpression());
    }

    public void testExpression1ReaderRnk() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/ExpressionTestFile.rnk";
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        params.setExpressionFileName1(testDataFileName);
        HashMap<String, Integer> genes = params.getGenes();
        HashMap<Integer, String> hash2genes = params.getHashkey2gene();
        FileReaderTest.assertEquals((int)0, (int)genes.size());
        int value = params.getNumberOfGenes();
        genes.put("GLS", value);
        hash2genes.put(value, "GLS");
        params.setNumberOfGenes(value++);
        genes.put("PSMA1", value);
        hash2genes.put(value, "PSMA1");
        params.setNumberOfGenes(value++);
        genes.put("ZP1", value);
        hash2genes.put(value, "ZP1");
        params.setNumberOfGenes(value++);
        genes.put("ZYX", value);
        hash2genes.put(value, "ZYX");
        params.setNumberOfGenes(value++);
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        ExpressionFileReaderTask task = new ExpressionFileReaderTask(params, 1);
        task.run();
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        FileReaderTest.assertEquals((int)4, (int)params.getExpression().getNumGenes());
        FileReaderTest.assertEquals((int)3, (int)params.getExpression().getNumConditions());
        FileReaderTest.assertEquals((Object)0.47536945, (Object)params.getExpression().getMinExpression());
        FileReaderTest.assertEquals((Object)0.5418719, (Object)params.getExpression().getMaxExpression());
    }

    public void testExpression1ReaderEDBRnk() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/ExpressionTestFile_edbrnk.rnk";
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        params.setExpressionFileName1(testDataFileName);
        HashMap<String, Integer> genes = params.getGenes();
        HashMap<Integer, String> hash2genes = params.getHashkey2gene();
        FileReaderTest.assertEquals((int)0, (int)genes.size());
        int value = params.getNumberOfGenes();
        genes.put("GLS", value);
        hash2genes.put(value, "GLS");
        params.setNumberOfGenes(value++);
        genes.put("PSMA1", value);
        hash2genes.put(value, "PSMA1");
        params.setNumberOfGenes(value++);
        genes.put("ZP1", value);
        hash2genes.put(value, "ZP1");
        params.setNumberOfGenes(value++);
        genes.put("ZYX", value);
        hash2genes.put(value, "ZYX");
        params.setNumberOfGenes(value++);
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        ExpressionFileReaderTask task = new ExpressionFileReaderTask(params, 1);
        task.run();
        FileReaderTest.assertEquals((int)4, (int)params.getGenes().size());
        FileReaderTest.assertEquals((int)4, (int)params.getExpression().getNumGenes());
        FileReaderTest.assertEquals((int)3, (int)params.getExpression().getNumConditions());
        FileReaderTest.assertEquals((Object)0.47536945, (Object)params.getExpression().getMinExpression());
        FileReaderTest.assertEquals((Object)0.5418719, (Object)params.getExpression().getMaxExpression());
    }
}

