/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class BuildEnrichmentMapActionListener
implements ActionListener {
    private JTaskConfig config;
    private GenericInputFilesPanel inputPanel;
    private EnrichmentMapParameters params;

    public BuildEnrichmentMapActionListener(GenericInputFilesPanel inputPanel, EnrichmentMapParameters params) {
        this.inputPanel = inputPanel;
        this.params = params;
    }

    public BuildEnrichmentMapActionListener(EnrichmentMapParameters params) {
        this.params = params;
    }

    public void actionPerformed(ActionEvent event) {
        this.config = new JTaskConfig();
        this.config.displayCancelButton(true);
        this.config.displayCloseButton(true);
        this.config.displayStatus(true);
        if (this.inputPanel.checkForChanges()) {
            double pvalue = this.inputPanel.getPvalue();
            if (pvalue > 1.0 || pvalue < 0.0) {
                JOptionPane.showMessageDialog(this.inputPanel, "invalid p-value");
            } else {
                this.params.setPvalue(pvalue);
            }
            double qvalue = this.inputPanel.getQvalue();
            if (qvalue > 100.0 || qvalue < 0.0) {
                JOptionPane.showMessageDialog(this.inputPanel, "invalid q-value");
            } else {
                this.params.setQvalue(qvalue);
            }
            double jaccardCutOff = this.inputPanel.getJaccard();
            if (jaccardCutOff > 1.0 || jaccardCutOff < 0.0) {
                JOptionPane.showMessageDialog(this.inputPanel, "invalid jaccard CutOff");
            } else {
                this.params.setJaccardCutOff(jaccardCutOff);
            }
            if (this.params.isGSEA()) {
                BuildGSEAEnrichmentMapTask new_map = new BuildGSEAEnrichmentMapTask(this.inputPanel, this.params);
                boolean success = TaskManager.executeTask((Task)new_map, (JTaskConfig)this.config);
            } else {
                BuildGenericEnrichmentMapTask new_map = new BuildGenericEnrichmentMapTask(this.inputPanel, this.params);
                boolean success = TaskManager.executeTask((Task)new_map, (JTaskConfig)this.config);
            }
            this.inputPanel.dispose();
            this.inputPanel.close();
        }
    }
}

