/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class BuildGenericEnrichmentMapTask
implements Task {
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private EnrichmentMapParameters params;
    private GenericInputFilesPanel inputPanel;

    public BuildGenericEnrichmentMapTask(GenericInputFilesPanel inputPanel, EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
        this.params = params;
        this.inputPanel = inputPanel;
    }

    public BuildGenericEnrichmentMapTask(GenericInputFilesPanel inputPanel, EnrichmentMapParameters params) {
        this.params = params;
        this.inputPanel = inputPanel;
    }

    public void buildGenericEnrichmentMap() {
        try {
            GMTFileReaderTask gmtFile = new GMTFileReaderTask(this.params, this.taskMonitor);
            gmtFile.run();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.inputPanel, "unable to load GMT file");
        }
        if (this.params.isData()) {
            try {
                GCTFileReaderTask gctFile1 = new GCTFileReaderTask(this.params, this.params.getGCTFileName1(), 1, this.taskMonitor);
                gctFile1.run();
                this.params.getExpression().rowNormalizeMatrix();
                if (this.params.isData2()) {
                    GCTFileReaderTask gctFile2 = new GCTFileReaderTask(this.params, this.params.getGCTFileName2(), 2, this.taskMonitor);
                    gctFile2.run();
                    this.params.getExpression2().rowNormalizeMatrix();
                }
                this.params.filterGenesets();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.inputPanel, "unable to load GSEA DATA (.GCT) file");
            }
        } else {
            this.params.noFilter();
        }
        try {
            GenericResultFileReaderTask genericResultsFilesDataset1 = new GenericResultFileReaderTask(this.taskMonitor, this.params, 1);
            genericResultsFilesDataset1.run();
            if (this.params.isTwoDatasets()) {
                GenericResultFileReaderTask genericResultsFilesDataset2 = new GenericResultFileReaderTask(this.taskMonitor, this.params, 2);
                genericResultsFilesDataset2.run();
            }
            InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(this.params, this.taskMonitor);
            genesets_init.run();
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.params, this.taskMonitor);
            similarities.run();
            HashMap similarity_results = similarities.getGeneset_similarities();
            this.params.setGenesetSimilarity(similarity_results);
            VisualizeEnrichmentMapTask map = new VisualizeEnrichmentMapTask(this.params, this.taskMonitor);
            map.run();
            this.inputPanel.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.inputPanel, "unable to build map");
        }
    }

    public void run() {
        this.buildGenericEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on Generic Enrichment results");
    }
}

