/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRangeSliderExtended
extends JRangeSlider
implements ChangeListener {
    private Dimension preferredSize;
    private Popup popup;
    private JLabel popupLow;
    private JLabel popupHigh;
    private PopupDaemon popupDaemon;

    public JRangeSliderExtended(BoundedRangeModel model, int orientation, int direction) {
        super(model, orientation, direction);
        this.addChangeListener(this);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            return super.getPreferredSize();
        }
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }

    public void resetPopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = null;
    }

    public void stateChanged(ChangeEvent e) {
        NumberRangeModel model = (NumberRangeModel)this.getModel();
        Number low = (Number)model.getLowValue();
        Number high = (Number)model.getHighValue();
        Number min = (Number)model.getMinValue();
        Number max = (Number)model.getMaxValue();
        String lowStr = null;
        String highStr = null;
        if (low instanceof Integer) {
            lowStr = Integer.toString((Integer)low);
            highStr = Integer.toString((Integer)high);
        } else {
            DecimalFormat format = max.doubleValue() - min.doubleValue() < 0.001 ? new DecimalFormat("0.###E0") : (max.doubleValue() - min.doubleValue() > 100000.0 ? new DecimalFormat("0.###E0") : new DecimalFormat("###,###.000"));
            lowStr = format.format(low);
            highStr = format.format(high);
        }
        if (this.isVisible()) {
            if (this.popup == null) {
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                JPanel panel = new JPanel();
                panel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
                panel.setPreferredSize(this.getPreferredSize());
                panel.setLayout(new BoxLayout(panel, 0));
                this.popupLow = new JLabel(lowStr);
                this.popupLow.setBorder(new EmptyBorder(6, 2, 6, 2));
                this.popupHigh = new JLabel(highStr);
                this.popupHigh.setBorder(new EmptyBorder(6, 2, 6, 2));
                panel.add(this.popupLow);
                panel.add(Box.createHorizontalGlue());
                panel.add(this.popupHigh);
                this.popup = popupFactory.getPopup(this, panel, this.getLocationOnScreen().x, this.getLocationOnScreen().y + this.getPreferredSize().height + 2);
                this.popupDaemon = new PopupDaemon(this, 1000);
                this.popup.show();
            } else {
                this.popupLow.setText(lowStr);
                this.popupHigh.setText(highStr);
                this.popupDaemon.restart();
            }
        }
    }
}

