/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayouts;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class VisualizeEnrichmentMapTask
implements Task {
    private EnrichmentMapParameters params;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private String clustername;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public VisualizeEnrichmentMapTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public VisualizeEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params = params;
        this.geneset_similarities = params.getGenesetSimilarity();
        this.clustername = "Enrichment Map";
    }

    public boolean computeMap() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set");
        }
        try {
            String vs_name;
            CyAttributes nodeAttrs;
            GeneSet gs;
            CyNode node;
            String current_name;
            CyNetwork network;
            String prefix;
            Set networks = Cytoscape.getNetworkSet();
            if (networks == null) {
                prefix = "EM1_";
                this.params.setAttributePrefix(prefix);
                this.params.setNetworkName(prefix + this.clustername);
                network = Cytoscape.createNetwork((String)(prefix + this.clustername));
            } else {
                int num_networks = 1;
                for (CyNetwork current_network : networks) {
                    if (!current_network.getTitle().startsWith("EM")) continue;
                    ++num_networks;
                }
                prefix = "EM" + num_networks + "_";
                this.params.setAttributePrefix(prefix);
                this.params.setNetworkName(prefix + this.clustername);
                network = Cytoscape.createNetwork((String)(prefix + this.clustername));
            }
            HashMap enrichmentResults1OfInterest = this.params.getEnrichmentResults1OfInterest();
            HashMap enrichmentResults2OfInterest = this.params.getEnrichmentResults2OfInterest();
            HashMap enrichmentResults1 = this.params.getEnrichmentResults1();
            HashMap enrichmentResults2 = this.params.getEnrichmentResults2();
            HashMap genesetsOfInterest = this.params.getGenesetsOfInterest();
            int currentProgress = 0;
            int maxValue = enrichmentResults1OfInterest.size();
            Iterator i = enrichmentResults1OfInterest.keySet().iterator();
            while (i.hasNext()) {
                Object current_result;
                current_name = i.next().toString();
                node = Cytoscape.getCyNode((String)current_name, (boolean)true);
                network.addNode((Node)node);
                gs = (GeneSet)genesetsOfInterest.get(current_name);
                nodeAttrs = Cytoscape.getNodeAttributes();
                nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_DESCR, gs.getDescription());
                if (this.params.isGSEA()) {
                    current_result = (GSEAResult)enrichmentResults1OfInterest.get(current_name);
                    this.setGSEAResultDataset1Attributes((Node)node, (GSEAResult)current_result, prefix);
                } else {
                    current_result = (GenericResult)enrichmentResults1OfInterest.get(current_name);
                    this.setGenericResultDataset1Attributes((Node)node, (GenericResult)current_result, prefix);
                }
                if (this.params.isTwoDatasets()) {
                    Object second_result;
                    if (this.params.isGSEA()) {
                        if (enrichmentResults2.containsKey(current_name)) {
                            second_result = (GSEAResult)enrichmentResults2.get(current_name);
                            this.setGSEAResultDataset2Attributes((Node)node, (GSEAResult)second_result, prefix);
                        } else {
                            this.setdefaultGSEAResultDataset2Attributes((Node)node, prefix);
                        }
                    } else if (enrichmentResults2.containsKey(current_name)) {
                        second_result = (GenericResult)enrichmentResults2.get(current_name);
                        this.setGenericResultDataset2Attributes((Node)node, (GenericResult)second_result, prefix);
                    } else {
                        this.setdefaultGenericResultDataset2Attributes((Node)node, prefix);
                    }
                }
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Building Enrichment Map " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
            }
            if (this.params.isTwoDatasets()) {
                i = enrichmentResults2OfInterest.keySet().iterator();
                while (i.hasNext()) {
                    Object second_result;
                    Object result;
                    current_name = i.next().toString();
                    if (enrichmentResults1OfInterest.containsKey(current_name)) continue;
                    node = Cytoscape.getCyNode((String)current_name, (boolean)true);
                    network.addNode((Node)node);
                    gs = (GeneSet)genesetsOfInterest.get(current_name);
                    nodeAttrs = Cytoscape.getNodeAttributes();
                    nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_DESCR, gs.getDescription());
                    if (this.params.isGSEA()) {
                        if (enrichmentResults1.containsKey(current_name)) {
                            result = (GSEAResult)enrichmentResults1.get(current_name);
                            this.setGSEAResultDataset1Attributes((Node)node, (GSEAResult)result, prefix);
                        } else {
                            this.setdefaultGSEAResultDataset1Attributes((Node)node, prefix);
                        }
                        second_result = (GSEAResult)enrichmentResults2OfInterest.get(current_name);
                        this.setGSEAResultDataset2Attributes((Node)node, (GSEAResult)second_result, prefix);
                        continue;
                    }
                    if (enrichmentResults1.containsKey(current_name)) {
                        result = (GenericResult)enrichmentResults1.get(current_name);
                        this.setGenericResultDataset1Attributes((Node)node, (GenericResult)result, prefix);
                    } else {
                        this.setdefaultGenericResultDataset1Attributes((Node)node, prefix);
                    }
                    second_result = (GenericResult)enrichmentResults2OfInterest.get(current_name);
                    this.setGenericResultDataset2Attributes((Node)node, (GenericResult)second_result, prefix);
                }
            }
            boolean k = false;
            Iterator<String> j = this.geneset_similarities.keySet().iterator();
            while (j.hasNext()) {
                String current_name2 = j.next().toString();
                GenesetSimilarity current_result = this.geneset_similarities.get(current_name2);
                if (!(current_result.getJaccard_coeffecient() > this.params.getJaccardCutOff())) continue;
                CyNode node1 = Cytoscape.getCyNode((String)current_result.getGeneset1_Name(), (boolean)false);
                CyNode node2 = Cytoscape.getCyNode((String)current_result.getGeneset2_Name(), (boolean)false);
                CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"pp", (boolean)true);
                network.addEdge((Edge)edge);
                CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
                edgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.JACCARD_COEFFECIENT, Double.valueOf(current_result.getJaccard_coeffecient()));
                edgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.OVERLAP_SIZE, Integer.valueOf(current_result.getSizeOfOverlap()));
            }
            CyNetworkView view = Cytoscape.createNetworkView((CyNetwork)network);
            VisualMappingManager manager = Cytoscape.getVisualMappingManager();
            CalculatorCatalog catalog = manager.getCalculatorCatalog();
            VisualStyle vs = catalog.getVisualStyle(vs_name = prefix + "Enrichment_map_style");
            if (vs == null) {
                EnrichmentMapVisualStyle em_vs = new EnrichmentMapVisualStyle(vs_name, this.params);
                vs = em_vs.createVisualStyle(network, prefix);
                catalog.addVisualStyle(vs);
            }
            view.setVisualStyle(vs.getName());
            manager.setVisualStyle(vs);
            view.redrawGraph(true, true);
            view.applyLayout(CyLayouts.getLayout((String)"force-directed"));
            EnrichmentMapManager EMmanager = EnrichmentMapManager.getInstance();
            EMmanager.registerNetwork(network, this.params);
            ParametersPanel parametersPanel = EMmanager.getParameterPanel();
            parametersPanel.updatePanel(this.params);
            CytoscapeDesktop desktop = Cytoscape.getDesktop();
            CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
            cytoSidePanel.setSelectedIndex(cytoSidePanel.indexOfComponent((Component)parametersPanel));
            view.addGraphViewChangeListener((GraphViewChangeListener)new EnrichmentMapActionListener(this.params));
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Unable to compute jaccard coeffecients");
            return false;
        }
        return true;
    }

    private void setGenericResultDataset1Attributes(Node node, GenericResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = this.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(1.0 - result.getPvalue()));
    }

    private void setGenericResultDataset2Attributes(Node node, GenericResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = this.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(1.0 - result.getPvalue()));
    }

    private void setGSEAResultDataset1Attributes(Node node, GSEAResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = this.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET1, Double.valueOf(result.getFwerqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(result.getSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET1, Double.valueOf(result.getES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET1, Double.valueOf(result.getNES()));
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGSEAResultDataset2Attributes(Node node, GSEAResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = this.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET2, Double.valueOf(result.getFwerqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(result.getSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET2, Double.valueOf(result.getES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET2, Double.valueOf(result.getNES()));
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setdefaultGSEAResultDataset1Attributes(Node node, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET1, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET1, Double.valueOf(0.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET1, Double.valueOf(0.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(0.0));
    }

    private void setdefaultGSEAResultDataset2Attributes(Node node, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET2, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET2, Double.valueOf(0.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET2, Double.valueOf(0.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(0.0));
    }

    private void setdefaultGenericResultDataset1Attributes(Node node, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(0.0));
    }

    private void setdefaultGenericResultDataset2Attributes(Node node, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(1.0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(0));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(0.0));
    }

    private String formatLabel(String label) {
        String formattedLabel;
        block7: {
            String[] tokens;
            int k;
            int i;
            block8: {
                block6: {
                    formattedLabel = "";
                    i = 0;
                    k = 1;
                    tokens = label.split(" ");
                    if (tokens.length <= 1) break block6;
                    int current_count = 0;
                    for (int j = 0; j < tokens.length; ++j) {
                        if (current_count + tokens[j].length() <= 15) {
                            formattedLabel = formattedLabel + tokens[j] + " ";
                            current_count += tokens[j].length();
                            continue;
                        }
                        if (current_count + tokens[j].length() <= 15) continue;
                        formattedLabel = formattedLabel + "\n" + tokens[j] + " ";
                        current_count = tokens[j].length();
                    }
                    break block7;
                }
                tokens = label.split("_");
                if (tokens.length <= 1) break block8;
                int current_count = 0;
                for (int j = 0; j < tokens.length; ++j) {
                    if (j != 0) {
                        formattedLabel = formattedLabel + "_";
                    }
                    if (current_count + tokens[j].length() <= 15) {
                        formattedLabel = formattedLabel + tokens[j];
                        current_count += tokens[j].length();
                        continue;
                    }
                    if (current_count + tokens[j].length() <= 15) continue;
                    formattedLabel = formattedLabel + "\n" + tokens[j];
                    current_count = tokens[j].length();
                }
                break block7;
            }
            if (tokens.length != 1) break block7;
            while (i <= label.length()) {
                formattedLabel = i + 15 > label.length() ? formattedLabel + label.substring(i, label.length()) + "\n" : formattedLabel + label.substring(i, k * 15) + "\n";
                i = k * 15;
                ++k;
            }
        }
        return formattedLabel;
    }

    public void run() {
        this.computeMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map");
    }
}

