/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class GSEAInputFilesPanel
extends GenericInputFilesPanel {
    private final int DIM_HEIGHT = 250;
    private final int DIM_WIDTH = 350;
    private boolean status = false;
    private JTextArea Dataset1FileNameTextField;
    private JButton selectDataset1FileButton;
    private JTextArea Dataset2FileNameTextField;
    private JButton selectDataset2FileButton;

    public GSEAInputFilesPanel(Frame parent, boolean modal) {
        super(parent, modal, false);
        this.initComponents();
        this.status = false;
        this.pack();
    }

    public void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 10, 10);
        c.fill = 2;
        int current_row = 0;
        current_row = this.initTitleComponent(gridbag, c, current_row, "Import GSEA Result files used to calculate enrichment maps");
        current_row = this.initGMTComponent(gridbag, c, current_row);
        current_row = this.initEnrichmentFilesComponent(gridbag, c, current_row);
        current_row = this.initCutoffsComponent(gridbag, c, current_row);
        current_row = this.initActionButtonsComponent(gridbag, c, current_row);
    }

    public int initEnrichmentFilesComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.Dataset1FileNameTextField = new JTextArea();
        this.Dataset2FileNameTextField = new JTextArea();
        this.selectDataset1FileButton = new JButton();
        this.selectDataset2FileButton = new JButton();
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset1_title);
        current_row = this.initGCTComponent(gridbag, c, current_row);
        this.Dataset1FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset1FileNameTextField.setText(dataset_instruction);
        this.Dataset1FileNameTextField.setLineWrap(true);
        this.Dataset1FileNameTextField.setRows(4);
        this.Dataset1FileNameTextField.setText("\n\n\n\n");
        this.selectDataset1FileButton.setText("Select");
        this.selectDataset1FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanel.this.selectDataset1FileButtonActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = current_row++;
        gridbag.setConstraints(this.Dataset1FileNameTextField, c);
        this.add(this.Dataset1FileNameTextField);
        c.gridx = 3;
        gridbag.setConstraints(this.selectDataset1FileButton, c);
        this.add(this.selectDataset1FileButton);
        current_row = this.addSeparator(gridbag, c, current_row);
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset2_title);
        current_row = this.initGCT2Component(gridbag, c, current_row);
        this.Dataset2FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset2FileNameTextField.setText(dataset_instruction);
        this.Dataset2FileNameTextField.setLineWrap(true);
        this.Dataset2FileNameTextField.setRows(4);
        this.Dataset2FileNameTextField.setText("\n\n\n\n");
        this.selectDataset2FileButton.setText("Select");
        this.selectDataset2FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanel.this.selectDataset2FileButtonActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = current_row++;
        gridbag.setConstraints(this.Dataset2FileNameTextField, c);
        this.add(this.Dataset2FileNameTextField);
        c.gridx = 3;
        gridbag.setConstraints(this.selectDataset2FileButton, c);
        this.add(this.selectDataset2FileButton);
        current_row = this.addSeparator(gridbag, c, current_row);
        return current_row;
    }

    private void selectDataset1FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA result files");
        File[] files = FileUtil.getFiles((String)"import GSEA dataset 1 result files", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (files != null) {
            if (files.length == 2) {
                this.Dataset1FileNameTextField.setForeground(this.checkFile(files[0].getAbsolutePath()));
                this.Dataset1FileNameTextField.setText(files[0].getAbsolutePath() + "\n" + files[1].getAbsolutePath());
                this.setGSEADataset1FileName1(files[0].getAbsolutePath());
                this.setGSEADataset1FileName2(files[1].getAbsolutePath());
                this.Dataset1FileNameTextField.setToolTipText(files[0].getAbsolutePath() + "," + files[1].getAbsolutePath());
                this.setDataset1FileSelected(true);
                if (this.isGMTFileSelected() && this.isGCTFileSelected()) {
                    this.enableImport();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Expecting two files to be selected.");
            }
        }
    }

    private void selectDataset2FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA results files");
        File[] files = FileUtil.getFiles((String)"Import GSEA Dataset 2 result Files", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (files != null) {
            if (files.length == 2) {
                this.Dataset2FileNameTextField.setForeground(this.checkFile(files[0].getAbsolutePath()));
                this.Dataset2FileNameTextField.setText(files[0].getAbsolutePath() + "\n" + files[1].getAbsolutePath());
                this.setGSEADataset2FileName1(files[0].getAbsolutePath());
                this.setGSEADataset2FileName2(files[1].getAbsolutePath());
                this.setTwoDatasets(true);
                this.Dataset2FileNameTextField.setToolTipText(files[0].getAbsolutePath() + "," + files[1].getAbsolutePath());
                if (this.isDataset1FileSelected() && this.isGMTFileSelected() && this.isGCTFileSelected()) {
                    this.enableImport();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Expecting two files to be selected.");
            }
        }
    }

    protected void setDatasetnames(String file1, String file2, boolean dataset1) {
        if (dataset1) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset1FileNameTextField.setText(file1 + "\n" + file2);
            this.Dataset1FileNameTextField.setToolTipText(file1 + "\n" + file2);
        } else {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset2FileNameTextField.setText(file1 + "\n" + file2);
            this.Dataset2FileNameTextField.setToolTipText(file1 + "\n" + file2);
        }
    }

    public boolean checkResultsFiles() {
        int answer;
        String current_filenames2;
        int answer2;
        String current_filenames1 = this.getGSEADataset1FileName1() + "\n" + this.getGSEADataset1FileName2();
        if (!current_filenames1.equalsIgnoreCase(this.Dataset1FileNameTextField.getText()) && (answer2 = JOptionPane.showConfirmDialog(this, "The Dataset 1 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            String[] tokens = this.Dataset1FileNameTextField.getText().split("\\n");
            String file1 = "";
            String file2 = "";
            if (tokens.length == 2) {
                file1 = tokens[0];
                file2 = tokens[1];
            } else if (tokens.length == 1) {
                file1 = tokens[0];
                file2 = "";
            } else {
                file1 = this.Dataset1FileNameTextField.getText();
                file2 = "";
            }
            if (file1.equalsIgnoreCase("") || file2.equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, "One or both of the Dataset 1 results files has been erased.  To run EM with GSEA results you need two results files. \nCan not run EM without 2 GSEA results files. ");
                return false;
            }
            if (this.checkFile(file1) == Color.RED || this.checkFile(file2) == Color.RED) {
                JOptionPane.showMessageDialog(this, "One of The files specified in the Dataset 1 does not exist.");
                return false;
            }
            this.setGSEADataset1FileName1(file1);
            this.setGSEADataset1FileName2(file2);
        }
        if (this.isTwoDatasets() && !(current_filenames2 = this.getGSEADataset2FileName1() + "\n" + this.getGSEADataset2FileName2()).equalsIgnoreCase(this.Dataset2FileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 2 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            String[] tokens = this.Dataset2FileNameTextField.getText().split("\\n");
            String file1 = "";
            String file2 = "";
            if (tokens.length == 2) {
                file1 = tokens[0];
                file2 = tokens[1];
            } else if (tokens.length == 1) {
                file1 = tokens[0];
                file2 = "";
            } else {
                file1 = this.Dataset1FileNameTextField.getText();
                file2 = "";
            }
            if (file1.equalsIgnoreCase("") || file2.equalsIgnoreCase("")) {
                int answer22 = JOptionPane.showConfirmDialog(this, "One or both of the Dataset 2 results files has been erased.  To run EM with GSEA results you need two results files. Would you like to clear the field?", "File deleted", 0);
                if (answer22 == 0) {
                    this.setGSEADataset2FileName1("");
                    this.setGSEADataset2FileName2("");
                    this.setTwoDatasets(false);
                    this.Dataset2FileNameTextField.setText("");
                }
            } else {
                if (this.checkFile(file1) == Color.RED || this.checkFile(file2) == Color.RED) {
                    JOptionPane.showMessageDialog(this, "One of The files specified in the Dataset 2 does not exist.");
                    return false;
                }
                this.setGSEADataset2FileName1(file1);
                this.setGSEADataset2FileName2(file2);
            }
        }
        return true;
    }
}

