/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;

public class GSEAResultFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String GSEAResultFileName;
    private HashMap results;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public GSEAResultFileReaderTask(EnrichmentMapParameters params, TaskMonitor taskMonitor, String FileName, int dataset) {
        this(params, FileName, dataset);
        this.taskMonitor = taskMonitor;
    }

    public GSEAResultFileReaderTask(EnrichmentMapParameters params, String FileName, int dataset) {
        this.params = params;
        this.GSEAResultFileName = FileName;
        params.setFDR(true);
        if (dataset == 1) {
            this.results = params.getEnrichmentResults1();
        } else if (dataset == 2) {
            this.results = params.getEnrichmentResults2();
        }
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.GSEAResultFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        int maxValue = lines.length;
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            int size = 0;
            double ES = 0.0;
            double NES = 0.0;
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            double FWERqvalue = 1.0;
            String Name = tokens[0].toUpperCase().trim();
            if (!tokens[3].equalsIgnoreCase("")) {
                size = Integer.parseInt(tokens[3]);
            }
            if (!tokens[4].equalsIgnoreCase("")) {
                ES = Double.parseDouble(tokens[4]);
            }
            if (!tokens[5].equalsIgnoreCase("")) {
                NES = Double.parseDouble(tokens[5]);
            }
            if (!tokens[6].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[6]);
            }
            if (!tokens[7].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[7]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                FWERqvalue = Double.parseDouble(tokens[8]);
            }
            GSEAResult result = new GSEAResult(Name, size, ES, NES, pvalue, FDRqvalue, FWERqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GSEA Results file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            this.results.put(Name, result);
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GSEA Result file");
    }
}

