/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;

public class GenericResultFileReaderTask
implements Task {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private EnrichmentMapParameters params;
    private HashMap results;
    private String filename;

    public GenericResultFileReaderTask(TaskMonitor taskMonitor, EnrichmentMapParameters params, int dataset) {
        this(params, dataset);
        this.taskMonitor = taskMonitor;
    }

    public GenericResultFileReaderTask(EnrichmentMapParameters params, int dataset) {
        this.params = params;
        if (dataset == 1) {
            this.results = params.getEnrichmentResults1();
            this.filename = params.getEnrichmentDataset1FileName1();
        } else {
            this.results = params.getEnrichmentResults2();
            this.filename = params.getEnrichmentDataset2FileName1();
        }
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.filename);
        reader.read();
        String fullText = reader.getText();
        HashMap genesets = this.params.getFilteredGenesets();
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = false;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        for (int i = 1; i < lines.length; ++i) {
            GenericResult result;
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            String id = tokens[0].toUpperCase();
            if (genesets.containsKey(id)) {
                GeneSet current_set = (GeneSet)genesets.get(id);
                gs_size = current_set.getGenes().size();
            }
            String Name = tokens[1].toUpperCase();
            if (!tokens[2].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[2]);
            }
            if (length > 3) {
                if (!tokens[3].equalsIgnoreCase("")) {
                    FDRqvalue = Double.parseDouble(tokens[3]);
                    FDR = true;
                }
                result = new GenericResult(id, Name, pvalue, gs_size, FDRqvalue);
            } else {
                result = new GenericResult(id, Name, pvalue, gs_size);
            }
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing Generic Results file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            this.results.put(id, result);
        }
        if (FDR) {
            this.params.setFDR(FDR);
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Generic Enrichment Result file");
    }
}

