/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ParametersPanel
extends JPanel {
    public static int summaryPanelWidth = 150;
    public static int summaryPanelHeight = 1000;

    public void updatePanel(EnrichmentMapParameters params) {
        this.removeAll();
        this.revalidate();
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel legends = this.createLegend(params);
        main.add((Component)legends, "North");
        JTextPane runInfo = new JTextPane();
        runInfo.setEditable(false);
        runInfo.setContentType("text/html");
        runInfo.setText(this.getRunInfo(params));
        runInfo.setPreferredSize(new Dimension(summaryPanelWidth, summaryPanelHeight));
        main.add((Component)runInfo, "South");
        JScrollPane jScrollPane = new JScrollPane(main);
        this.add(jScrollPane);
        this.revalidate();
    }

    private String getRunInfo(EnrichmentMapParameters params) {
        String runInfoText = "<html> <h1>Parameters:</h1>";
        runInfoText = runInfoText + "<b>P-value Cut-off:</b>" + params.getPvalue() + "<br>";
        runInfoText = runInfoText + "<b>FDR Q-value Cut-off:</b>" + params.getQvalue() + "<br>";
        if (params.isJaccard()) {
            runInfoText = runInfoText + "<b>Jaccard Cut-off:</b>" + params.getJaccardCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Jaccard Index<br>";
        } else {
            runInfoText = runInfoText + "<b>Overlap Cut-off:</b>" + params.getJaccardCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Overlap Index<br>";
        }
        runInfoText = runInfoText + "<font size=-1><b>Genesets File:</b>" + this.shortenPathname(params.getGMTFileName()) + "<br>";
        runInfoText = runInfoText + "<b>Dataset 1 Data Files:</b> " + this.shortenPathname(params.getEnrichmentDataset1FileName1()) + ",<br>" + this.shortenPathname(params.getEnrichmentDataset1FileName2()) + "<br>";
        if (params.isTwoDatasets()) {
            runInfoText = runInfoText + "<b>Dataset 2 Data Files:</b> " + this.shortenPathname(params.getEnrichmentDataset2FileName1()) + ",<br>" + this.shortenPathname(params.getEnrichmentDataset2FileName2()) + "<br>";
        }
        if (params.isData()) {
            runInfoText = runInfoText + "<b>Data file:</b>" + this.shortenPathname(params.getGCTFileName1()) + "<br>";
        }
        if (params.isData2()) {
            runInfoText = runInfoText + "<b>Data file 2:</b>" + this.shortenPathname(params.getGCTFileName2()) + "<br>";
        }
        runInfoText = runInfoText + "</font></html>";
        return runInfoText;
    }

    private JPanel createLegend(EnrichmentMapParameters params) {
        JPanel legends = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        legends.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 2;
        ColorGradientRange range = ColorGradientRange.getInstance(-1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 1.0);
        ColorGradientTheme theme = ColorGradientTheme.ENRICHMENTMAP_NODE_THEME;
        ColorGradientWidget node_legend = ColorGradientWidget.getInstance("Node Colour Legend", summaryPanelWidth, 60, 5, 5, theme, range, true, ColorGradientWidget.LEGEND_POSITION.TOP);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        gridbag.setConstraints(node_legend, c);
        legends.add(node_legend);
        JLabel minlabel = new JLabel(params.getDataset1Phenotype2());
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 0;
        gridbag.setConstraints(minlabel, c);
        legends.add(minlabel);
        JLabel maxlabel = new JLabel(params.getDataset1Phenotype1());
        c.gridx = 10;
        c.fill = 0;
        c.anchor = 22;
        c.gridy = 2;
        c.gridwidth = 0;
        gridbag.setConstraints(maxlabel, c);
        legends.add(maxlabel);
        if (params.isTwoDatasets()) {
            ColorGradientWidget node_legend2 = ColorGradientWidget.getInstance("Node Border Colour Legend", summaryPanelWidth, 60, 5, 5, theme, range, true, ColorGradientWidget.LEGEND_POSITION.TOP);
            c.gridx = 0;
            c.gridy = 3;
            c.fill = 2;
            c.gridwidth = 0;
            gridbag.setConstraints(node_legend2, c);
            legends.add(node_legend2);
            JLabel minlabel2 = new JLabel(params.getDataset2Phenotype2());
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 1;
            c.anchor = 21;
            c.fill = 0;
            gridbag.setConstraints(minlabel2, c);
            legends.add(minlabel2);
            JLabel maxlabel2 = new JLabel(params.getDataset2Phenotype1());
            c.gridx = 10;
            c.fill = 0;
            c.anchor = 22;
            c.gridwidth = 0;
            c.gridy = 4;
            gridbag.setConstraints(maxlabel2, c);
            legends.add(maxlabel2);
        }
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(10, 0, 10, 0);
        c.gridwidth = 0;
        c.anchor = 21;
        SliderBarPanel pvalueSlider = params.getPvalueSlider();
        gridbag.setConstraints(pvalueSlider, c);
        legends.add(pvalueSlider);
        if (params.isFDR()) {
            SliderBarPanel qvalueSlider = params.getQvalueSlider();
            c.gridx = 0;
            c.gridy = 6;
            c.insets = new Insets(10, 0, 10, 0);
            c.gridwidth = 0;
            c.anchor = 21;
            gridbag.setConstraints(qvalueSlider, c);
            legends.add(qvalueSlider);
        }
        return legends;
    }

    private String shortenPathname(String pathname) {
        if (pathname != null) {
            String[] tokens = pathname.split("\\" + File.separator);
            int num_tokens = tokens.length;
            String new_pathname = num_tokens >= 2 ? "..." + File.separator + tokens[num_tokens - 2] + File.separator + tokens[num_tokens - 1] : pathname;
            return new_pathname;
        }
        return pathname;
    }
}

