/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.data.readers.TextFileReader;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GenericInputFilesPanel
extends JDialog {
    private boolean status = false;
    private JButton cancelButton;
    private JButton importButton;
    private JTextField GMTFileNameTextField;
    private JTextField GCTFileName1TextField;
    private JTextField GCTFileName2TextField;
    private JTextField Dataset1FileNameTextField;
    private JTextField Dataset1FileName2TextField;
    private JTextField Dataset2FileNameTextField;
    private JTextField Dataset2FileName2TextField;
    private JTextField pvalueTextField;
    private JTextField qvalueTextField;
    private JTextField jaccardTextField;
    private boolean Dataset1FileSelected = false;
    private boolean GMTFileSelected = false;
    private boolean GCTFileSelected = false;
    private EnrichmentMapParameters params;
    public static String title = "Import Generic Enrichment Result files to calculate enrichment maps";
    public static String dataset1_title = "Dataset 1";
    public static String dataset_instruction = "Please select the Generic result file for first dataset...";
    public static String dataset2_title = "Dataset 2 (OPTIONAL)";
    public static String gct_instruction = "Please select the dataset (.gct) or (.rpt) file used for GSEA analysis...";
    public static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    public static String pvalue_instruction = "P-value cut-off (Only genesets with p-value less than this value will be included)";
    public static String qvalue_instruction = "FDR Q-value cut-off (Only genesets with fdr q-value less than this value will be included)";
    public static String pvalue_default = Enrichment_Map_Plugin.cyto_prop.getProperty("EnrichmentMap.default_pvalue", "0.05");
    public static String qvalue_default = Enrichment_Map_Plugin.cyto_prop.getProperty("EnrichmentMap.default_qvalue", "0.25");
    public static String jaccard_default = Enrichment_Map_Plugin.cyto_prop.getProperty("EnrichmentMap.default_jaccard", "0.25");
    public static String overlap_default = Enrichment_Map_Plugin.cyto_prop.getProperty("EnrichmentMap.default_overlap", "0.50");
    public static String overlap_metric_default = Enrichment_Map_Plugin.cyto_prop.getProperty("EnrichmentMap.default_overlap_metric", "jaccard");

    public GenericInputFilesPanel(Frame parent, boolean modal) {
        super(parent, modal);
        this.params = new EnrichmentMapParameters();
        this.params.setGSEA(false);
        this.initComponents();
        this.status = false;
        this.pack();
    }

    public GenericInputFilesPanel(Frame parent, boolean modal, boolean child) {
        super(parent, modal);
        this.status = false;
        this.pack();
        this.params = new EnrichmentMapParameters();
    }

    public void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 10, 10);
        c.fill = 2;
        int current_row = 0;
        current_row = this.initTitleComponent(gridbag, c, current_row, title);
        current_row = this.initGMTComponent(gridbag, c, current_row);
        current_row = this.initEnrichmentFilesComponent(gridbag, c, current_row);
        current_row = this.initCutoffsComponent(gridbag, c, current_row);
        current_row = this.initActionButtonsComponent(gridbag, c, current_row);
    }

    public int initEnrichmentFilesComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.Dataset1FileNameTextField = new JTextField();
        this.Dataset2FileNameTextField = new JTextField();
        JButton selectDataset1FileButton = new JButton();
        JButton selectDataset2FileButton = new JButton();
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset1_title);
        current_row = this.initGCTComponent(gridbag, c, current_row);
        this.Dataset1FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset1FileNameTextField.setText(dataset_instruction);
        selectDataset1FileButton.setText("Select");
        selectDataset1FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectDataset1FileButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset1FileNameTextField, selectDataset1FileButton);
        current_row = this.addSeparator(gridbag, c, current_row);
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset2_title);
        current_row = this.initGCT2Component(gridbag, c, current_row);
        this.Dataset2FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset2FileNameTextField.setText(dataset_instruction);
        selectDataset2FileButton.setText("Select");
        selectDataset2FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectDataset2FileButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset2FileNameTextField, selectDataset2FileButton);
        current_row = this.addSeparator(gridbag, c, current_row);
        return current_row;
    }

    public int initTitleComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row, String title) {
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(new Font("Dialog", 1, 14));
        titleLabel.setText(title);
        c.gridx = 0;
        c.gridy = current_row++;
        c.gridwidth = 3;
        gridbag.setConstraints(titleLabel, c);
        this.add(titleLabel);
        return current_row;
    }

    public int initActionButtonsComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.cancelButton = new JButton();
        this.importButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.importButton.setText("Build Enrichment Map");
        this.importButton.addActionListener(new BuildEnrichmentMapActionListener(this, this.params));
        this.importButton.setEnabled(false);
        c.gridx = 1;
        c.gridy = current_row;
        c.fill = 0;
        gridbag.setConstraints(this.cancelButton, c);
        this.add(this.cancelButton);
        c.gridx = 3;
        gridbag.setConstraints(this.importButton, c);
        this.add(this.importButton);
        return current_row;
    }

    public int initGCTComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.GCTFileName1TextField = new JTextField();
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 12));
        this.GCTFileName1TextField.setText(gct_instruction);
        selectGCTFileButton.setText("Select");
        selectGCTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectGCTFileButtonActionPerformed(evt);
            }
        });
        return this.addTextButtonRow(gridbag, c, current_row, this.GCTFileName1TextField, selectGCTFileButton);
    }

    public int initGCT2Component(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.GCTFileName2TextField = new JTextField();
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName2TextField.setFont(new Font("Dialog", 1, 12));
        this.GCTFileName2TextField.setText("OPTIONAL:" + gct_instruction);
        selectGCTFileButton.setText("Select");
        selectGCTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectGCTFileButton2ActionPerformed(evt);
            }
        });
        return this.addTextButtonRow(gridbag, c, current_row, this.GCTFileName2TextField, selectGCTFileButton);
    }

    public int initGMTComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.GMTFileNameTextField = new JTextField();
        JButton selectGMTFileButton = new JButton();
        this.GMTFileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.GMTFileNameTextField.setText(gmt_instruction);
        selectGMTFileButton.setText("Select");
        selectGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        return this.addTextButtonRow(gridbag, c, current_row, this.GMTFileNameTextField, selectGMTFileButton);
    }

    public int addTextButtonRow(GridBagLayout gridbag, GridBagConstraints c, int current_row, JTextField text, JButton button) {
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = current_row++;
        gridbag.setConstraints(text, c);
        this.add(text);
        c.gridx = 3;
        gridbag.setConstraints(button, c);
        this.add(button);
        return current_row;
    }

    public int addSeparator(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        JSeparator sep = new JSeparator();
        c.gridx = 0;
        c.gridwidth = 4;
        c.gridy = current_row++;
        gridbag.setConstraints(sep, c);
        this.add(sep);
        return current_row;
    }

    public int initCutoffsComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.pvalueTextField = new JTextField();
        this.qvalueTextField = new JTextField();
        this.jaccardTextField = new JTextField();
        JLabel pvalueLabel = new JLabel();
        JLabel qvalueLabel = new JLabel();
        JLabel jaccardLabel = new JLabel();
        JRadioButton jaccard = new JRadioButton("Jaccard Coeffecient");
        jaccard.setActionCommand("jaccard");
        JRadioButton overlap = new JRadioButton("Overlap Coeffecient");
        overlap.setActionCommand("overlap");
        if (overlap_metric_default.equalsIgnoreCase("overlap")) {
            overlap.setSelected(true);
            jaccard.setSelected(false);
            this.params.setJaccard(false);
        } else {
            overlap.setSelected(false);
            jaccard.setSelected(true);
            this.params.setJaccard(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(jaccard);
        jaccardOrOverlap.add(overlap);
        jaccard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        overlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericInputFilesPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = current_row++;
        pvalueLabel.setFont(new Font("Dialog", 1, 10));
        pvalueLabel.setText(pvalue_instruction);
        this.pvalueTextField.setText(pvalue_default);
        gridbag.setConstraints(pvalueLabel, c);
        this.add(pvalueLabel);
        c.gridx = 3;
        gridbag.setConstraints(this.pvalueTextField, c);
        this.add(this.pvalueTextField);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = current_row++;
        qvalueLabel.setFont(new Font("Dialog", 1, 10));
        qvalueLabel.setText(qvalue_instruction);
        this.qvalueTextField.setText(qvalue_default);
        gridbag.setConstraints(qvalueLabel, c);
        this.add(qvalueLabel);
        c.gridx = 3;
        gridbag.setConstraints(this.qvalueTextField, c);
        this.add(this.qvalueTextField);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = current_row;
        jaccardLabel.setFont(new Font("Dialog", 1, 10));
        jaccardLabel.setText("Cut-off");
        if (overlap_metric_default.equalsIgnoreCase("overlap")) {
            this.jaccardTextField.setText(overlap_default);
        } else {
            this.jaccardTextField.setText(jaccard_default);
        }
        gridbag.setConstraints(jaccard, c);
        this.add(jaccard);
        c.gridx = 1;
        gridbag.setConstraints(overlap, c);
        this.add(overlap);
        c.gridx = 2;
        gridbag.setConstraints(jaccardLabel, c);
        this.add(jaccardLabel);
        c.gridx = 3;
        gridbag.setConstraints(this.jaccardTextField, c);
        this.add(this.jaccardTextField);
        return ++current_row;
    }

    public double getPvalue() {
        try {
            return Double.parseDouble(this.pvalueTextField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }

    public double getQvalue() {
        try {
            return Double.parseDouble(this.qvalueTextField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }

    public double getJaccard() {
        try {
            return Double.parseDouble(this.jaccardTextField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.status = false;
        this.dispose();
    }

    public void close() {
        this.status = false;
        this.dispose();
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.params.setJaccard(true);
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.params.setJaccard(false);
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gmt");
        filter.setDescription("All GMT files");
        File file = FileUtil.getFile((String)"Import GMT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.GMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.GMTFileNameTextField.setText(file.getAbsolutePath());
            this.params.setGMTFileName(file.getAbsolutePath());
            this.GMTFileNameTextField.setToolTipText(file.getAbsolutePath());
            this.GMTFileSelected = true;
            if (this.Dataset1FileSelected && this.GCTFileSelected) {
                this.importButton.setEnabled(true);
            }
        }
    }

    private void selectGCTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gct");
        filter.addExtension("rpt");
        filter.addExtension("rnk");
        filter.addExtension("txt");
        filter.setDescription("All GCT files");
        File file = FileUtil.getFile((String)"Import GCT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
                this.Dataset1FileSelected = true;
                this.GMTFileSelected = true;
            } else {
                this.GCTFileName1TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName1TextField.setText(file.getAbsolutePath());
                this.params.setGCTFileName1(file.getAbsolutePath());
                this.GCTFileName1TextField.setToolTipText(file.getAbsolutePath());
            }
            this.GCTFileSelected = true;
            this.params.setData(true);
            if (this.Dataset1FileSelected && this.GMTFileSelected) {
                this.importButton.setEnabled(true);
            }
        }
    }

    private void selectGCTFileButton2ActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gct");
        filter.addExtension("txt");
        filter.addExtension("rnk");
        filter.addExtension("rpt");
        filter.setDescription("All GCT files");
        File file = FileUtil.getFile((String)"Import GCT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
                this.params.setTwoDatasets(true);
            } else {
                this.GCTFileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName2TextField.setText(file.getAbsolutePath());
                this.params.setGCTFileName2(file.getAbsolutePath());
                this.GCTFileName2TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setData2(true);
        }
    }

    private void selectDataset1FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset 1 result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1FileNameTextField.setText(file.getAbsolutePath());
            this.params.setEnrichmentDataset1FileName1(file.getAbsolutePath());
            this.Dataset1FileNameTextField.setToolTipText(file.getAbsolutePath());
            if (this.GMTFileSelected) {
                this.importButton.setEnabled(true);
            }
            this.Dataset1FileSelected = true;
        }
    }

    private void selectDataset2FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset 2 result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2FileNameTextField.setText(file.getName());
            this.params.setEnrichmentDataset2FileName1(file.getAbsolutePath());
            this.Dataset2FileNameTextField.setToolTipText(file.getAbsolutePath());
            this.params.setTwoDatasets(true);
            if (this.GMTFileSelected && this.Dataset1FileSelected) {
                this.importButton.setEnabled(true);
            }
        }
    }

    private void populateFieldsFromRpt(File file, boolean dataset1) {
        TextFileReader reader = new TextFileReader(file.getAbsolutePath());
        reader.read();
        String fullText = reader.getText();
        HashMap<String, String> rpt = new HashMap<String, String>();
        String[] lines = fullText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length == 2) {
                rpt.put(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length != 3) continue;
            rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
        }
        String timestamp = (String)rpt.get("producer_timestamp");
        String method = (String)rpt.get("producer_class");
        method = method.split("\\p{Punct}")[2];
        String out_dir = (String)rpt.get("param out");
        String data = (String)rpt.get("param res");
        String label = (String)rpt.get("param rpt_label");
        String classes = (String)rpt.get("param cls");
        String gmt = (String)rpt.get("param gmx");
        String gmt_nopath = gmt.substring(gmt.lastIndexOf(File.separator) + 1, gmt.length() - 1);
        String phenotype1 = "na";
        String phenotype2 = "na";
        if (classes != null && method.equalsIgnoreCase("Gsea")) {
            String[] classes_split = classes.split("#");
            String phenotypes = classes_split[1];
            String[] phenotypes_split = phenotypes.split("_versus_");
            phenotype1 = phenotypes_split[0];
            phenotype2 = phenotypes_split[1];
            if (dataset1) {
                this.params.setClassFile1(classes_split[0]);
                this.params.setDataset1Phenotype1(phenotype1);
                this.params.setDataset1Phenotype2(phenotype2);
            } else {
                this.params.setClassFile2(classes_split[0]);
                this.params.setDataset2Phenotype1(phenotype1);
                this.params.setDataset2Phenotype2(phenotype2);
            }
        } else if (method.equalsIgnoreCase("GseaPreranked")) {
            data = (String)rpt.get("param rnk");
            phenotype1 = "na_pos";
            phenotype2 = "na_neg";
            if (dataset1) {
                this.params.setDataset1Phenotype1(phenotype1);
                this.params.setDataset1Phenotype2(phenotype2);
            } else {
                this.params.setDataset2Phenotype1(phenotype1);
                this.params.setDataset2Phenotype2(phenotype2);
            }
        } else {
            JOptionPane.showMessageDialog(this, "The class field in the rpt file has been modified or doesn't specify a class file\n but the analysis is a classic GSEA not PreRanked.  ");
        }
        String results1 = "";
        String results2 = "";
        String ranks = "";
        if (!file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)).equalsIgnoreCase(out_dir)) {
            results1 = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
            results2 = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
            ranks = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
            if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
                out_dir = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator));
                results1 = out_dir + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                results2 = out_dir + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                ranks = out_dir + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
            }
        } else {
            results1 = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
            results2 = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
            ranks = "" + out_dir + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
        }
        if (dataset1) {
            if (!(this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt) || this.GMTFileNameTextField.getText().contains(gmt_nopath) || this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt_instruction))) {
                JOptionPane.showMessageDialog(this, "The gmt files between the two analyses do not match.\n  To compare two analyses the geneset files for the two analyses must be the same.");
            } else if (this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt_instruction)) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.params.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            this.GCTFileName1TextField.setForeground(this.checkFile(data));
            this.GCTFileName1TextField.setText(data);
            this.params.setGCTFileName1(data);
            this.GCTFileName1TextField.setToolTipText(data);
            this.params.setEnrichmentDataset1FileName1(results1);
            this.params.setEnrichmentDataset1FileName2(results2);
            this.params.setDataset1RankedFile(ranks);
            this.setDatasetnames(results1, results2, dataset1);
        } else {
            if (!(this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt) || this.GMTFileNameTextField.getText().contains(gmt_nopath) || this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt_instruction))) {
                JOptionPane.showMessageDialog(this, "The gmt files between the two analyses do not match.\n  To compare two analyses the geneset files for the two analyses must be the same.");
            } else if (this.GMTFileNameTextField.getText().equalsIgnoreCase(gmt_instruction)) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.params.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            this.GCTFileName2TextField.setForeground(this.checkFile(data));
            this.GCTFileName2TextField.setText(data);
            this.params.setGCTFileName2(data);
            this.GCTFileName2TextField.setToolTipText(data);
            this.params.setEnrichmentDataset2FileName1(results1);
            this.params.setEnrichmentDataset2FileName2(results2);
            this.params.setDataset2RankedFile(ranks);
            this.setDatasetnames(results1, results2, dataset1);
        }
    }

    protected void setDatasetnames(String file1, String file2, boolean dataset1) {
        if (dataset1) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset1FileNameTextField.setText(file1);
            this.Dataset1FileNameTextField.setToolTipText(file1);
            this.Dataset1FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset1FileName2TextField.setText(file2);
            this.Dataset1FileName2TextField.setToolTipText(file2);
        } else {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset2FileNameTextField.setText(file1);
            this.Dataset2FileNameTextField.setToolTipText(file1);
            this.Dataset2FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset2FileName2TextField.setText(file2);
            this.Dataset2FileName2TextField.setToolTipText(file2);
        }
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    public boolean checkForChanges() {
        int answer2;
        int answer;
        if (!this.params.getGMTFileName().equalsIgnoreCase(this.GMTFileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The GMT file name has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.checkFile(this.GMTFileNameTextField.getText()) == Color.RED) {
                JOptionPane.showMessageDialog(this, "The file specified in the GMT text field does not exist.");
                return false;
            }
            this.params.setGMTFileName(this.GMTFileNameTextField.getText());
        }
        if (this.params.isData() && !this.params.getGCTFileName1().equalsIgnoreCase(this.GCTFileName1TextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The GCT file name 1 has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.GCTFileName1TextField.getText().equalsIgnoreCase("")) {
                answer2 = JOptionPane.showConfirmDialog(this, "The Data file name has been erased would you like to clear this field?", "File deleted", 0);
                if (answer2 == 0) {
                    this.params.setData(false);
                    this.params.setGCTFileName1("");
                }
            } else {
                if (this.checkFile(this.GCTFileName1TextField.getText()) == Color.RED) {
                    JOptionPane.showMessageDialog(this, "The file specified in the GCT text field 1 does not exist.");
                    return false;
                }
                this.params.setGCTFileName1(this.GCTFileName1TextField.getText());
            }
        }
        if (this.params.isData2() && !this.params.getGCTFileName2().equalsIgnoreCase(this.GCTFileName2TextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The GCT file name 2 has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.GCTFileName2TextField.getText().equalsIgnoreCase("")) {
                answer2 = JOptionPane.showConfirmDialog(this, "The Data 2 file name has been erased would you like to clear this field?", "File deleted", 0);
                if (answer2 == 0) {
                    this.params.setData2(false);
                    this.params.setGCTFileName2("");
                }
            } else {
                if (this.checkFile(this.GCTFileName2TextField.getText()) == Color.RED) {
                    JOptionPane.showMessageDialog(this, "The file specified in the GCT text field 2 does not exist.");
                    return false;
                }
                this.params.setGCTFileName2(this.GCTFileName2TextField.getText());
            }
        }
        return this.checkResultsFiles();
    }

    public boolean checkResultsFiles() {
        int answer;
        if (!this.params.getEnrichmentDataset1FileName1().equalsIgnoreCase(this.Dataset1FileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 1 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.checkFile(this.Dataset1FileNameTextField.getText()) == Color.RED) {
                JOptionPane.showMessageDialog(this, "The file specified in the Dataset 1 file 1 does not exist.");
                return false;
            }
            this.params.setEnrichmentDataset1FileName1(this.Dataset1FileNameTextField.getText());
        }
        if (this.isTwoDatasets() && !this.params.getEnrichmentDataset2FileName1().equalsIgnoreCase(this.Dataset2FileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 2 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.checkFile(this.Dataset2FileNameTextField.getText()) == Color.RED) {
                JOptionPane.showMessageDialog(this, "The file specified in the Dataset 2 file 1 does not exist.");
                return false;
            }
            this.params.setEnrichmentDataset2FileName1(this.Dataset2FileNameTextField.getText());
        }
        return true;
    }

    public void enableImport() {
        this.importButton.setEnabled(true);
    }

    public void setGSEADataset1FileName1(String name) {
        this.params.setEnrichmentDataset1FileName1(name);
    }

    public void setGSEADataset1FileName2(String name) {
        this.params.setEnrichmentDataset1FileName2(name);
    }

    public void setGSEADataset2FileName1(String name) {
        this.params.setEnrichmentDataset2FileName1(name);
    }

    public void setGSEADataset2FileName2(String name) {
        this.params.setEnrichmentDataset2FileName2(name);
    }

    public String getGSEADataset1FileName1() {
        return this.params.getEnrichmentDataset1FileName1();
    }

    public String getGSEADataset1FileName2() {
        return this.params.getEnrichmentDataset1FileName2();
    }

    public String getGSEADataset2FileName1() {
        return this.params.getEnrichmentDataset2FileName1();
    }

    public String getGSEADataset2FileName2() {
        return this.params.getEnrichmentDataset2FileName2();
    }

    public void setTwoDatasets(boolean datasets) {
        this.params.setTwoDatasets(datasets);
    }

    public boolean isTwoDatasets() {
        return this.params.isTwoDatasets();
    }

    public boolean isGCTFileSelected() {
        return this.GCTFileSelected;
    }

    public void setGCTFileSelected(boolean GCTFileSelected) {
        this.GCTFileSelected = GCTFileSelected;
    }

    public boolean isGMTFileSelected() {
        return this.GMTFileSelected;
    }

    public void setGMTFileSelected(boolean GMTFileSelected) {
        this.GMTFileSelected = GMTFileSelected;
    }

    public boolean isDataset1FileSelected() {
        return this.Dataset1FileSelected;
    }

    public void setDataset1FileSelected(boolean dataset1FileSelected) {
        this.Dataset1FileSelected = dataset1FileSelected;
    }
}

