/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import java.awt.Color;
import java.util.HashMap;

public class ColorGradientMapper {
    public static ColorGradientMapper getInstance() {
        return new ColorGradientMapper();
    }

    public static Color getColorGradient(ColorGradientTheme theme, ColorGradientRange range, String gene, Double measurement) {
        if (measurement.equals(Double.NaN)) {
            return theme.getNoDataColor();
        }
        ContinuousMapping continuousMapping = ColorGradientMapper.getContinuousMapping(theme, range);
        if (continuousMapping == null) {
            return theme.getNoDataColor();
        }
        HashMap<String, Double> attrBundle = new HashMap<String, Double>();
        attrBundle.put(gene, measurement);
        ContinuousRangeCalculator calculator = new ContinuousRangeCalculator(continuousMapping.getAllPoints(), continuousMapping.getInterpolator(), attrBundle);
        return (Color)calculator.calculateRangeValue(gene);
    }

    public static ContinuousMapping getContinuousMapping(ColorGradientTheme colorGradientTheme, ColorGradientRange colorGradientRange) {
        if (colorGradientTheme == null || colorGradientRange == null) {
            return null;
        }
        ContinuousMapping continuousMapping = new ContinuousMapping((Object)Color.WHITE, 1);
        continuousMapping.setInterpolator((Interpolator)new LinearNumberToColorInterpolator());
        Color minColor = colorGradientTheme.getMinColor();
        Color medColor = colorGradientTheme.getCenterColor();
        Color maxColor = colorGradientTheme.getMaxColor();
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)minColor, (Object)minColor, (Object)minColor);
        BoundaryRangeValues bv1a = new BoundaryRangeValues((Object)medColor, (Object)medColor, (Object)medColor);
        BoundaryRangeValues bv1b = new BoundaryRangeValues((Object)medColor, (Object)medColor, (Object)medColor);
        BoundaryRangeValues bv2 = new BoundaryRangeValues((Object)maxColor, (Object)maxColor, (Object)maxColor);
        continuousMapping.addPoint(colorGradientRange.getMinValue(), bv0);
        continuousMapping.addPoint(colorGradientRange.getCenterLowValue(), bv1a);
        continuousMapping.addPoint(colorGradientRange.getCenterHighValue(), bv1b);
        continuousMapping.addPoint(colorGradientRange.getMaxValue(), bv2);
        return continuousMapping;
    }

    public static String getColorGradientAsString(ColorGradientTheme theme, ColorGradientRange range, String gene, Double measurement) {
        Color color = ColorGradientMapper.getColorGradient(theme, range, gene, measurement);
        int red = color.getRed();
        String redColor = Integer.toHexString(red);
        if (red <= 9) {
            redColor = "0" + redColor;
        }
        int green = color.getGreen();
        String greenColor = Integer.toHexString(green);
        if (green <= 9) {
            greenColor = "0" + greenColor;
        }
        int blue = color.getBlue();
        String blueColor = Integer.toHexString(blue);
        if (blue <= 9) {
            blueColor = "0" + blueColor;
        }
        return redColor + greenColor + blueColor;
    }

    private ColorGradientMapper() {
    }
}

