/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class SliderBarPanel
extends JPanel {
    private String sliderLabel;
    private int min;
    private int max;
    private NumberRangeModel rangeModel;
    private double precision = 1000.0;
    private JLabel label;

    public SliderBarPanel(double min, double max, String sliderLabel, EnrichmentMapParameters params, String attrib1, String attrib2, int desired_width) {
        if (min <= 1.0 && max <= 1.0) {
            this.min = (int)(min * this.precision);
            this.max = (int)(max * this.precision);
        } else {
            this.min = (int)min;
            this.max = (int)max;
        }
        this.sliderLabel = sliderLabel;
        this.label = new JLabel(sliderLabel);
        this.initPanel(params, attrib1, attrib2, desired_width);
    }

    public void initPanel(EnrichmentMapParameters params, String attrib1, String attrib2, int desired_width) {
        JSlider slider = new JSlider(0, this.min, this.max, this.max);
        slider.addChangeListener(new SliderBarActionListener(this, params, attrib1, attrib2));
        slider.setMajorTickSpacing((this.max - this.min) / 5);
        slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(this.min), new JLabel("" + (double)this.min / this.precision));
        labelTable.put(new Integer(this.max), new JLabel("" + (double)this.max / this.precision));
        slider.setLabelTable(labelTable);
        slider.setPaintLabels(true);
        Dimension currentsize = slider.getPreferredSize();
        currentsize.width = desired_width;
        slider.setPreferredSize(currentsize);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.label);
        this.add(slider);
        this.revalidate();
    }

    public void setLabel(int current_value) {
        this.label.setText(this.sliderLabel + " --> " + (double)current_value / this.precision);
        this.revalidate();
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getMin() {
        return (double)this.min / this.precision;
    }

    public void setMin(double min) {
        this.min = (int)(min * this.precision);
    }

    public double getMax() {
        return (double)this.max / this.precision;
    }

    public void setMax(double max) {
        this.max = (int)(max * this.precision);
    }

    public NumberRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(NumberRangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }
}

