/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.util.FileUtil;
import giny.model.Edge;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.baderlab.csplugins.enrichmentmap.ColorRenderer;
import org.baderlab.csplugins.enrichmentmap.ColumnHeaderVerticalRenderer;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.OverlappingGenesTableModel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.mskcc.colorgradient.ColorGradientMapper;
import org.mskcc.colorgradient.ColorGradientWidget;

public class OverlappingGenesPanel
extends JPanel {
    private Object[] columnNames;
    private Object[] columnNames2;
    private String[] phenotypes;
    private String[] phenotypes2;
    private int numConditions;
    private int numConditions2;
    private HashMap currentExpressionSet;
    private HashMap currentExpressionSet2;
    private boolean node = true;
    private String Dataset1phenotype1;
    private String Dataset1phenotype2;
    private String Dataset2phenotype1;
    private String Dataset2phenotype2;
    private HeatMapParameters hmParams;
    private EnrichmentMapParameters params;

    public OverlappingGenesPanel(boolean node) {
        this.node = node;
        this.setLayout(new BorderLayout());
    }

    public void resetVariables(EnrichmentMapParameters params) {
        this.params = params;
        GeneExpressionMatrix expression = params.getExpression();
        this.numConditions = expression.getNumConditions();
        this.columnNames = expression.getColumnNames();
        this.phenotypes = expression.getPhenotypes();
        this.Dataset1phenotype1 = params.getDataset1Phenotype1();
        this.Dataset1phenotype2 = params.getDataset1Phenotype2();
        this.hmParams = params.getHmParams();
        if (params.getDataset1RankedFile() != null && params.getDataset2RankedFile() != null) {
            this.hmParams.setNum_ranks(2);
        } else if (params.getDataset1RankedFile() != null || params.getDataset2RankedFile() != null) {
            this.hmParams.setNum_ranks(1);
        }
        this.currentExpressionSet = this.node ? this.getNodeExpressionSet(params, expression) : this.getEdgeExpressionSet(params, expression);
        if (params.isData2()) {
            GeneExpressionMatrix expression2 = params.getExpression2();
            this.numConditions2 = expression2.getNumConditions();
            this.columnNames2 = expression2.getColumnNames();
            this.phenotypes2 = expression2.getPhenotypes();
            this.Dataset2phenotype1 = params.getDataset2Phenotype1();
            this.Dataset2phenotype2 = params.getDataset2Phenotype2();
            this.currentExpressionSet2 = this.node ? this.getNodeExpressionSet(params, expression2) : this.getEdgeExpressionSet(params, expression2);
        }
    }

    public void updatePanel(EnrichmentMapParameters params) {
        this.resetVariables(params);
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.currentExpressionSet != null) {
            int i;
            JTable jTable1;
            Object[][] data;
            Object[] mergedcolumnNames = null;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)this.createLegendPanel(), "West");
            if (this.hmParams.getNum_ranks() > 0) {
                mainPanel.add((Component)this.hmParams.createRankOptionsPanel(), "East");
            }
            if (this.params.isData2()) {
                data = this.createSortedMergedTableData();
                mergedcolumnNames = new String[this.columnNames.length + this.columnNames2.length - 2];
                System.arraycopy(this.columnNames, 0, mergedcolumnNames, 0, this.columnNames.length);
                System.arraycopy(this.columnNames2, 2, mergedcolumnNames, this.columnNames.length, this.columnNames2.length - 2);
                jTable1 = new JTable(new OverlappingGenesTableModel(mergedcolumnNames, data));
            } else {
                data = this.createSortedTableData();
                jTable1 = new JTable(new OverlappingGenesTableModel(this.columnNames, data));
            }
            jTable1.setDefaultRenderer(Color.class, new ColorRenderer());
            TableColumnModel tcModel = jTable1.getColumnModel();
            jTable1.setDragEnabled(false);
            jTable1.setCellSelectionEnabled(true);
            ColumnHeaderVerticalRenderer pheno1_renderer = new ColumnHeaderVerticalRenderer();
            pheno1_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype1);
            ColumnHeaderVerticalRenderer pheno2_renderer = new ColumnHeaderVerticalRenderer();
            pheno2_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype2);
            ColumnHeaderVerticalRenderer default_renderer = new ColumnHeaderVerticalRenderer();
            if (this.params.isData2()) {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (!this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) continue;
                        tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
                for (i = this.columnNames.length; i < this.columnNames.length + this.columnNames2.length - 2; ++i) {
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes2 != null) {
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (!this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype2)) continue;
                        tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            } else {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (!this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) continue;
                        tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            }
            jTable1.setColumnModel(tcModel);
            if (this.columnNames.length > 20) {
                jTable1.setAutoResizeMode(0);
            }
            JScrollPane jScrollPane = new JScrollPane(jTable1);
            mainPanel.add(jScrollPane);
            mainPanel.revalidate();
            this.add((Component)mainPanel, "Center");
        }
        this.revalidate();
    }

    private Object[][] createSortedTableData() {
        Object temp;
        HashMap<Integer, Ranking> ranks;
        Object[][] data = new Object[this.currentExpressionSet.size()][this.numConditions];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap<Object, Object> rank2keys = new HashMap<Object, Object>();
        if (this.hmParams.isRank_dataset1()) {
            ranks = this.params.getDataset1Rankings();
        } else if (this.hmParams.isRank_dataset2()) {
            ranks = this.params.getDataset2Rankings();
        } else {
            int r = 1;
            ranks = new HashMap<Integer, Ranking>();
            for (Integer key : this.currentExpressionSet.keySet()) {
                temp = new Ranking(key.toString(), 0.0, r++);
                ranks.put(key, (Ranking)temp);
            }
        }
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ((Ranking)ranks.get(key)).getRank();
            if (!rank2keys.containsKey(ranks_subset[n])) {
                temp = new ArrayList();
                ((ArrayList)temp).add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        Arrays.sort(ranks_subset);
        int k = 0;
        int previous = 0;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer key : keys) {
                GeneExpression row = (GeneExpression)this.currentExpressionSet.get(key);
                Double[] expression_values = this.hmParams.isRowNorm() ? row.rowNormalize() : (this.hmParams.isLogtransform() ? row.rowLogTransform() : row.getExpression());
                data[k][0] = row.getName();
                data[k][1] = row.getDescription();
                for (int j = 0; j < row.getExpression().length; ++j) {
                    data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), row.getName(), expression_values[j]);
                }
                ++k;
            }
        }
        return data;
    }

    private Object[][] createSortedMergedTableData() {
        Object temp;
        HashMap<Integer, Ranking> ranks;
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        Object[][] data = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap<Object, Object> rank2keys = new HashMap<Object, Object>();
        if (this.hmParams.isRank_dataset1()) {
            ranks = this.params.getDataset1Rankings();
        } else if (this.hmParams.isRank_dataset2()) {
            ranks = this.params.getDataset2Rankings();
        } else {
            int r = 1;
            ranks = new HashMap<Integer, Ranking>();
            for (Integer key : this.currentExpressionSet.keySet()) {
                temp = new Ranking(key.toString(), 0.0, r++);
                ranks.put(key, (Ranking)temp);
            }
        }
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ((Ranking)ranks.get(key)).getRank();
            if (!rank2keys.containsKey(ranks_subset[n])) {
                temp = new ArrayList();
                ((ArrayList)temp).add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        Arrays.sort(ranks_subset);
        int k = 0;
        int previous = 0;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer currentKey : keys) {
                int j;
                int q;
                GeneExpression halfRow1 = (GeneExpression)this.currentExpressionSet.get(currentKey);
                GeneExpression halfRow2 = (GeneExpression)this.currentExpressionSet2.get(currentKey);
                Double[] expression_values1 = null;
                Double[] expression_values2 = null;
                if (this.hmParams.isRowNorm()) {
                    if (halfRow1 != null) {
                        expression_values1 = halfRow1.rowNormalize();
                    }
                    if (halfRow2 != null) {
                        expression_values2 = halfRow2.rowNormalize();
                    }
                } else if (this.hmParams.isLogtransform()) {
                    if (halfRow1 != null) {
                        expression_values1 = halfRow1.rowLogTransform();
                    }
                    if (halfRow2 != null) {
                        expression_values2 = halfRow2.rowLogTransform();
                    }
                } else {
                    if (halfRow1 != null) {
                        expression_values1 = halfRow1.getExpression();
                    }
                    if (halfRow2 != null) {
                        expression_values2 = halfRow2.getExpression();
                    }
                }
                if (halfRow1 != null) {
                    data[k][0] = halfRow1.getName();
                    data[k][1] = halfRow1.getDescription();
                } else if (halfRow2 != null) {
                    data[k][0] = halfRow2.getName();
                    data[k][1] = halfRow2.getDescription();
                }
                if (expression_values1 == null) {
                    expression_values1 = new Double[this.columnNames.length - 2];
                    q = 0;
                    while (m < expression_values1.length) {
                        expression_values1[q] = null;
                        ++q;
                    }
                }
                if (expression_values2 == null) {
                    expression_values2 = new Double[this.columnNames2.length - 2];
                    q = 0;
                    while (m < expression_values2.length) {
                        expression_values2[q] = null;
                        ++q;
                    }
                }
                for (j = 0; j < halfRow1.getExpression().length; ++j) {
                    data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), halfRow1.getName(), expression_values1[j]);
                }
                for (j = halfRow1.getExpression().length; j < halfRow1.getExpression().length + halfRow2.getExpression().length; ++j) {
                    data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), halfRow2.getName(), expression_values2[j - halfRow1.getExpression().length]);
                }
                ++k;
            }
        }
        return data;
    }

    private Object[][] createTableData() {
        Object[][] data = new Object[this.currentExpressionSet.size()][this.numConditions];
        int k = 0;
        Iterator i = this.currentExpressionSet.keySet().iterator();
        while (i.hasNext()) {
            GeneExpression row = (GeneExpression)this.currentExpressionSet.get(i.next());
            Double[] expression_values = this.hmParams.isRowNorm() ? row.rowNormalize() : (this.hmParams.isLogtransform() ? row.rowLogTransform() : row.getExpression());
            data[k][0] = row.getName();
            data[k][1] = row.getDescription();
            for (int j = 0; j < row.getExpression().length; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), row.getName(), expression_values[j]);
            }
            ++k;
        }
        return data;
    }

    private Object[][] createMergedTableData() {
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        Object[][] data = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        int k = 0;
        for (Object currentKey : this.currentExpressionSet.keySet()) {
            int j;
            int m;
            GeneExpression halfRow1 = (GeneExpression)this.currentExpressionSet.get(currentKey);
            GeneExpression halfRow2 = (GeneExpression)this.currentExpressionSet2.get(currentKey);
            Double[] expression_values1 = null;
            Double[] expression_values2 = null;
            if (this.hmParams.isRowNorm()) {
                if (halfRow1 != null) {
                    expression_values1 = halfRow1.rowNormalize();
                }
                if (halfRow2 != null) {
                    expression_values2 = halfRow2.rowNormalize();
                }
            } else if (this.hmParams.isLogtransform()) {
                if (halfRow1 != null) {
                    expression_values1 = halfRow1.rowLogTransform();
                }
                if (halfRow2 != null) {
                    expression_values2 = halfRow2.rowLogTransform();
                }
            } else {
                if (halfRow1 != null) {
                    expression_values1 = halfRow1.getExpression();
                }
                if (halfRow2 != null) {
                    expression_values2 = halfRow2.getExpression();
                }
            }
            if (halfRow1 != null) {
                data[k][0] = halfRow1.getName();
                data[k][1] = halfRow1.getDescription();
            } else if (halfRow2 != null) {
                data[k][0] = halfRow2.getName();
                data[k][1] = halfRow2.getDescription();
            }
            if (expression_values1 == null) {
                expression_values1 = new Double[this.columnNames.length - 2];
                for (m = 0; m < expression_values1.length; ++m) {
                    expression_values1[m] = null;
                }
            }
            if (expression_values2 == null) {
                expression_values2 = new Double[this.columnNames2.length - 2];
                for (m = 0; m < expression_values2.length; ++m) {
                    expression_values2[m] = null;
                }
            }
            for (j = 0; j < halfRow1.getExpression().length; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), halfRow1.getName(), expression_values1[j]);
            }
            for (j = halfRow1.getExpression().length; j < halfRow1.getExpression().length + halfRow2.getExpression().length; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(this.hmParams.getTheme(), this.hmParams.getRange(), halfRow2.getName(), expression_values2[j - halfRow1.getExpression().length]);
            }
            ++k;
        }
        return data;
    }

    private JPanel createLegendPanel() {
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        topPanel.setLayout(new GridLayout(2, 1));
        ColorGradientWidget new_legend = ColorGradientWidget.getInstance("expression legend", 150, 60, 5, 5, this.hmParams.getTheme(), this.hmParams.getRange(), true, ColorGradientWidget.LEGEND_POSITION.TOP);
        JButton SaveExpressionSet = new JButton("Save Expression Set");
        SaveExpressionSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverlappingGenesPanel.this.saveExpressionSetActionPerformed(evt);
            }
        });
        buttonPanel.add(SaveExpressionSet);
        topPanel.add(new_legend);
        topPanel.add(buttonPanel);
        westPanel.add((Component)topPanel, "North");
        westPanel.add((Component)this.hmParams.createHeatMapOptionsPanel(), "South");
        westPanel.revalidate();
        return westPanel;
    }

    private void saveExpressionSetActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"Export Heatmap as txt File", (int)FileUtil.SAVE);
        if (file != null && file.toString() != null) {
            String fileName = file.toString();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
                file = new File(fileName);
            }
            int response = 0;
            if (file.exists()) {
                response = JOptionPane.showConfirmDialog(this, "The file already exists.  Would you like to overwrite it?");
            }
            if (response != 1 && response != 2 && (response == 0 || response == 0)) {
                try {
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    for (int j = 0; j < this.columnNames.length; ++j) {
                        if (j == this.columnNames.length - 1) {
                            output.write(this.columnNames[j] + "\n");
                            continue;
                        }
                        output.write(this.columnNames[j] + "\t");
                    }
                    Iterator i = this.currentExpressionSet.keySet().iterator();
                    while (i.hasNext()) {
                        GeneExpression row = (GeneExpression)this.currentExpressionSet.get(i.next());
                        output.write(row.toString());
                    }
                    output.flush();
                    output.close();
                    JOptionPane.showMessageDialog(this, "File " + fileName + " saved.");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "unable to write to file " + fileName);
                }
            }
        }
    }

    private HashMap getNodeExpressionSet(EnrichmentMapParameters params, GeneExpressionMatrix expressionSet) {
        Object[] nodes = params.getSelectedNodes().toArray();
        if (nodes.length > 0) {
            HashSet<Integer> union = null;
            for (int i = 0; i < nodes.length; ++i) {
                Node current_node = (Node)nodes[i];
                String nodename = current_node.getIdentifier();
                GeneSet current_geneset = (GeneSet)params.getGenesetsOfInterest().get(nodename);
                HashSet<Integer> current_set = current_geneset.getGenes();
                if (union == null) {
                    union = new HashSet<Integer>(current_set);
                    continue;
                }
                union.addAll(current_set);
            }
            return expressionSet.getExpressionMatrix(union);
        }
        return null;
    }

    private HashMap getEdgeExpressionSet(EnrichmentMapParameters params, GeneExpressionMatrix expressionSet) {
        Object[] edges = params.getSelectedEdges().toArray();
        if (edges.length > 0) {
            HashSet<Integer> intersect = null;
            HashSet<Integer> union = null;
            for (int i = 0; i < edges.length; ++i) {
                Edge current_edge = (Edge)edges[i];
                String edgename = current_edge.getIdentifier();
                GenesetSimilarity similarity = params.getGenesetSimilarity().get(edgename);
                HashSet<Integer> current_set = similarity.getOverlapping_genes();
                if (intersect == null && union == null) {
                    intersect = new HashSet<Integer>(current_set);
                    union = new HashSet<Integer>(current_set);
                    continue;
                }
                intersect.retainAll(current_set);
                union.addAll(current_set);
            }
            return expressionSet.getExpressionMatrix(intersect);
        }
        return null;
    }

    public void clearPanel() {
        this.removeAll();
        this.revalidate();
    }
}

