/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;

public class EnrichmentMapVisualStyle {
    EnrichmentMapParameters params;
    public static final int maxNodeLabelLength = 15;
    public static String NAME = "Name";
    public static String GS_DESCR = "GS_DESCR";
    public static String FORMATTED_NAME = "Formatted_name";
    public static String GENES = "Genes";
    public static String ES_DATASET1 = "ES_dataset1";
    public static String NES_DATASET1 = "NES_dataset1";
    public static String GS_SIZE_DATASET1 = "gs_size_dataset1";
    public static String PVALUE_DATASET1 = "pvalue_dataset1";
    public static String FDR_QVALUE_DATASET1 = "fdr_qvalue_dataset1";
    public static String FWER_QVALUE_DATASET1 = "fwer_qvalue_dataset1";
    public static String COLOURING_DATASET1 = "Colouring_dataset1";
    public static String ES_DATASET2 = "ES_dataset2";
    public static String NES_DATASET2 = "NES_dataset2";
    public static String GS_SIZE_DATASET2 = "gs_size_dataset2";
    public static String PVALUE_DATASET2 = "pvalue_dataset2";
    public static String FDR_QVALUE_DATASET2 = "fdr_qvalue_dataset2";
    public static String FWER_QVALUE_DATASET2 = "fwer_qvalue_dataset2";
    public static String COLOURING_DATASET2 = "Colouring_dataset2";
    public static String OVERLAP_SIZE = "Overlap_size";
    public static String JACCARD_COEFFECIENT = "jaccard_coeffecient";
    public static String OVERLAP_GENES = "Overlap_genes";
    public static String HYPERGEOM_PVALUE = "Overlap_Hypergeom_pVal";
    public static Color max_phenotype1 = new Color(255, 0, 0);
    public static Color lighter_phenotype1 = new Color(255, 102, 102);
    public static Color lightest_phenotype1 = new Color(255, 179, 179);
    public static Color max_phenotype2 = new Color(0, 100, 255);
    public static Color lighter_phenotype2 = new Color(102, 162, 255);
    public static Color lightest_phenotype2 = new Color(179, 208, 255);
    public static Color overColor = Color.WHITE;
    private VisualStyle vs;

    public EnrichmentMapVisualStyle(String string, EnrichmentMapParameters params) {
        this.params = params;
        this.vs = new VisualStyle(string);
    }

    public VisualStyle createVisualStyle(CyNetwork network, String prefix) {
        GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator();
        globalAppCalc.setDefaultBackgroundColor(new Color(205, 205, 235));
        this.vs.setGlobalAppearanceCalculator(globalAppCalc);
        this.createEdgeAppearance(network, prefix);
        this.createNodeAppearance(network, prefix);
        return this.vs;
    }

    private void createEdgeAppearance(CyNetwork network, String prefix) {
        EdgeAppearanceCalculator edgeAppCalc = new EdgeAppearanceCalculator();
        EdgeAppearance edgeAppear = new EdgeAppearance();
        edgeAppear.set(VisualPropertyType.EDGE_COLOR, (Object)new Color(100, 200, 0));
        edgeAppCalc.setDefaultAppearance(edgeAppear);
        ContinuousMapping continuousMapping_edgewidth = new ContinuousMapping((Object)1, 0);
        continuousMapping_edgewidth.setControllingAttributeName(prefix + JACCARD_COEFFECIENT, network, false);
        LinearNumberToNumberInterpolator numTonum2 = new LinearNumberToNumberInterpolator();
        continuousMapping_edgewidth.setInterpolator((Interpolator)numTonum2);
        Double under_width = 0.5;
        Double min_width = 1.0;
        Double max_width = 5.0;
        Double over_width = 6.0;
        BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width);
        BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width);
        continuousMapping_edgewidth.addPoint(this.params.getJaccardCutOff(), bv4);
        continuousMapping_edgewidth.addPoint(1.0, bv5);
        BasicCalculator edgeWidthCalculator = new BasicCalculator(prefix + "edgesize", (ObjectMapping)continuousMapping_edgewidth, VisualPropertyType.EDGE_LINE_WIDTH);
        edgeAppCalc.setCalculator((Calculator)edgeWidthCalculator);
        this.vs.setEdgeAppearanceCalculator(edgeAppCalc);
    }

    private void createNodeAppearance(CyNetwork network, String prefix) {
        BoundaryRangeValues bv3a = new BoundaryRangeValues((Object)max_phenotype2, (Object)max_phenotype2, (Object)max_phenotype2);
        BoundaryRangeValues bv3b = new BoundaryRangeValues((Object)lighter_phenotype2, (Object)lighter_phenotype2, (Object)max_phenotype2);
        BoundaryRangeValues bv3c = new BoundaryRangeValues((Object)lightest_phenotype2, (Object)lightest_phenotype2, (Object)lighter_phenotype2);
        BoundaryRangeValues bv3d = new BoundaryRangeValues((Object)lightest_phenotype2, (Object)overColor, (Object)overColor);
        BoundaryRangeValues bv3e = new BoundaryRangeValues((Object)overColor, (Object)overColor, (Object)overColor);
        BoundaryRangeValues bv3f = new BoundaryRangeValues((Object)overColor, (Object)overColor, (Object)lightest_phenotype1);
        BoundaryRangeValues bv3g = new BoundaryRangeValues((Object)lightest_phenotype1, (Object)lightest_phenotype1, (Object)lighter_phenotype1);
        BoundaryRangeValues bv3h = new BoundaryRangeValues((Object)lighter_phenotype1, (Object)lighter_phenotype1, (Object)max_phenotype1);
        BoundaryRangeValues bv3i = new BoundaryRangeValues((Object)max_phenotype1, (Object)max_phenotype1, (Object)max_phenotype1);
        NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator();
        NodeAppearance nodeAppear = new NodeAppearance();
        nodeAppear.set(VisualPropertyType.NODE_FILL_COLOR, (Object)Color.GRAY);
        nodeAppear.set(VisualPropertyType.NODE_BORDER_COLOR, (Object)Color.GRAY);
        nodeAppear.set(VisualPropertyType.NODE_SHAPE, (Object)NodeShape.ELLIPSE);
        nodeAppear.set(VisualPropertyType.NODE_SIZE, (Object)new Double(35.0));
        nodeAppear.set(VisualPropertyType.NODE_LINE_WIDTH, (Object)new Double(4.0));
        nodeAppCalc.setDefaultAppearance(nodeAppear);
        PassThroughMapping pm = new PassThroughMapping((Object)new String(), prefix + FORMATTED_NAME);
        BasicCalculator nlc = new BasicCalculator(prefix + "nodeLabel", (ObjectMapping)pm, VisualPropertyType.NODE_LABEL);
        nodeAppCalc.setCalculator((Calculator)nlc);
        ContinuousMapping continuousMapping_size = new ContinuousMapping((Object)35, 1);
        continuousMapping_size.setControllingAttributeName(prefix + GS_SIZE_DATASET1, network, false);
        LinearNumberToNumberInterpolator numTonum = new LinearNumberToNumberInterpolator();
        continuousMapping_size.setInterpolator((Interpolator)numTonum);
        Integer min = 20;
        Integer max = 65;
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)min, (Object)min, (Object)min);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)max, (Object)max, (Object)max);
        continuousMapping_size.addPoint(10.0, bv0);
        continuousMapping_size.addPoint(474.0, bv1);
        BasicCalculator nodeSizeCalculator = new BasicCalculator(prefix + "size2size", (ObjectMapping)continuousMapping_size, VisualPropertyType.NODE_SIZE);
        nodeAppCalc.setCalculator((Calculator)nodeSizeCalculator);
        if (this.params.isTwoDatasets()) {
            ContinuousMapping continuousMapping_size_dataset2 = new ContinuousMapping((Object)35, 1);
            continuousMapping_size_dataset2.setControllingAttributeName(prefix + GS_SIZE_DATASET2, network, false);
            LinearNumberToNumberInterpolator numTonum3 = new LinearNumberToNumberInterpolator();
            continuousMapping_size_dataset2.setInterpolator((Interpolator)numTonum3);
            Integer min_line = 4;
            Integer max_line = 15;
            BoundaryRangeValues bv0a = new BoundaryRangeValues((Object)min_line, (Object)min_line, (Object)min_line);
            BoundaryRangeValues bv1a = new BoundaryRangeValues((Object)max_line, (Object)max_line, (Object)max_line);
            continuousMapping_size_dataset2.addPoint(10.0, bv0a);
            continuousMapping_size_dataset2.addPoint(474.0, bv1a);
            BasicCalculator nodelineSizeCalculator = new BasicCalculator(prefix + "size2size", (ObjectMapping)continuousMapping_size_dataset2, VisualPropertyType.NODE_LINE_WIDTH);
            nodeAppCalc.setCalculator((Calculator)nodelineSizeCalculator);
            ContinuousMapping continuousMapping_width_col = new ContinuousMapping((Object)Color.WHITE, 1);
            continuousMapping_width_col.setControllingAttributeName(prefix + COLOURING_DATASET2, network, false);
            LinearNumberToColorInterpolator numToColor2 = new LinearNumberToColorInterpolator();
            continuousMapping_width_col.setInterpolator((Interpolator)numToColor2);
            continuousMapping_width_col.addPoint(-1.0, bv3a);
            continuousMapping_width_col.addPoint(-0.995, bv3b);
            continuousMapping_width_col.addPoint(-0.95, bv3c);
            continuousMapping_width_col.addPoint(-0.9, bv3d);
            continuousMapping_width_col.addPoint(0.0, bv3e);
            continuousMapping_width_col.addPoint(0.9, bv3f);
            continuousMapping_width_col.addPoint(0.95, bv3g);
            continuousMapping_width_col.addPoint(0.995, bv3h);
            continuousMapping_width_col.addPoint(1.0, bv3i);
            BasicCalculator nodeColorCalculator_width_col = new BasicCalculator(prefix + "ES2Colour", (ObjectMapping)continuousMapping_width_col, VisualPropertyType.NODE_BORDER_COLOR);
            nodeAppCalc.setCalculator((Calculator)nodeColorCalculator_width_col);
        }
        ContinuousMapping continuousMapping = new ContinuousMapping((Object)Color.WHITE, 1);
        continuousMapping.setControllingAttributeName(prefix + COLOURING_DATASET1, network, false);
        LinearNumberToColorInterpolator numToColor = new LinearNumberToColorInterpolator();
        continuousMapping.setInterpolator((Interpolator)numToColor);
        continuousMapping.addPoint(-1.0, bv3a);
        continuousMapping.addPoint(-0.995, bv3b);
        continuousMapping.addPoint(-0.95, bv3c);
        continuousMapping.addPoint(-0.9, bv3d);
        continuousMapping.addPoint(0.0, bv3e);
        continuousMapping.addPoint(0.9, bv3f);
        continuousMapping.addPoint(0.95, bv3g);
        continuousMapping.addPoint(0.995, bv3h);
        continuousMapping.addPoint(1.0, bv3i);
        BasicCalculator nodeColorCalculator = new BasicCalculator(prefix + "ES2Colour", (ObjectMapping)continuousMapping, VisualPropertyType.NODE_FILL_COLOR);
        nodeAppCalc.setCalculator((Calculator)nodeColorCalculator);
        this.vs.setNodeAppearanceCalculator(nodeAppCalc);
    }
}

