/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;

public class EnrichmentResultFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String EnrichmentResultFileName;
    private HashMap results;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public EnrichmentResultFileReaderTask(EnrichmentMapParameters params, TaskMonitor taskMonitor, String FileName, int dataset) {
        this(params, FileName, dataset);
        this.taskMonitor = taskMonitor;
    }

    public EnrichmentResultFileReaderTask(EnrichmentMapParameters params, String FileName, int dataset) {
        this.params = params;
        this.EnrichmentResultFileName = FileName;
        if (dataset == 1) {
            this.results = params.getEnrichmentResults1();
        } else if (dataset == 2) {
            this.results = params.getEnrichmentResults2();
        }
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.EnrichmentResultFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        if (tokens.length == 11) {
            if (tokens[4].equalsIgnoreCase("ES") && tokens[5].equalsIgnoreCase("NES")) {
                this.parseGSEAFile(lines);
            } else {
                this.parseGenericFile(lines);
            }
        } else {
            this.parseGenericFile(lines);
        }
    }

    public void parseGSEAFile(String[] lines) {
        this.params.setFDR(true);
        int currentProgress = 0;
        int maxValue = lines.length;
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            int size = 0;
            double ES = 0.0;
            double NES = 0.0;
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            double FWERqvalue = 1.0;
            String Name = tokens[0].toUpperCase().trim();
            if (!tokens[3].equalsIgnoreCase("")) {
                size = Integer.parseInt(tokens[3]);
            }
            if (!tokens[4].equalsIgnoreCase("")) {
                ES = Double.parseDouble(tokens[4]);
            }
            if (!tokens[5].equalsIgnoreCase("")) {
                NES = Double.parseDouble(tokens[5]);
            }
            if (!tokens[6].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[6]);
            }
            if (!tokens[7].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[7]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                FWERqvalue = Double.parseDouble(tokens[8]);
            }
            GSEAResult result = new GSEAResult(Name, size, ES, NES, pvalue, FDRqvalue, FWERqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing Enrichment Results file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            this.results.put(Name, result);
        }
    }

    public void parseGenericFile(String[] lines) {
        HashMap genesets = this.params.getFilteredGenesets();
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = false;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        for (int i = 1; i < lines.length; ++i) {
            GenericResult result;
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[0].toUpperCase();
            if (genesets.containsKey(name)) {
                GeneSet current_set = (GeneSet)genesets.get(name);
                gs_size = current_set.getGenes().size();
            }
            String description = tokens[1].toUpperCase();
            if (!tokens[2].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[2]);
            }
            if (length > 3) {
                if (!tokens[3].equalsIgnoreCase("")) {
                    FDRqvalue = Double.parseDouble(tokens[3]);
                    FDR = true;
                }
                if (length > 4) {
                    if (!tokens[4].equalsIgnoreCase("")) {
                        NES = Double.parseDouble(tokens[4]);
                    }
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue, NES);
                } else {
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
                }
            } else {
                result = new GenericResult(name, description, pvalue, gs_size);
            }
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing Generic Results file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            this.results.put(name, result);
        }
        if (FDR) {
            this.params.setFDR(FDR);
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Enrichment Result file");
    }
}

